/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationAnswerOutput;
import software.amazon.awssdk.services.connect.model.EvaluationAnswersOutputMapCopier;
import software.amazon.awssdk.services.connect.model.EvaluationMetadata;
import software.amazon.awssdk.services.connect.model.EvaluationNote;
import software.amazon.awssdk.services.connect.model.EvaluationNotesMapCopier;
import software.amazon.awssdk.services.connect.model.EvaluationScore;
import software.amazon.awssdk.services.connect.model.EvaluationScoresMapCopier;
import software.amazon.awssdk.services.connect.model.EvaluationStatus;
import software.amazon.awssdk.services.connect.model.EvaluationType;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Evaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Evaluation> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationId").getter(Evaluation.getter(Evaluation::evaluationId)).setter(Evaluation.setter(Builder::evaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()}).build();
    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationArn").getter(Evaluation.getter(Evaluation::evaluationArn)).setter(Evaluation.setter(Builder::evaluationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()}).build();
    private static final SdkField<EvaluationMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(Evaluation.getter(Evaluation::metadata)).setter(Evaluation.setter(Builder::metadata)).constructor(EvaluationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<Map<String, EvaluationAnswerOutput>> ANSWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Answers").getter(Evaluation.getter(Evaluation::answers)).setter(Evaluation.setter(Builder::answers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationAnswerOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, EvaluationNote>> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Notes").getter(Evaluation.getter(Evaluation::notes)).setter(Evaluation.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationNote::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Evaluation.getter(Evaluation::statusAsString)).setter(Evaluation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, EvaluationScore>> SCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Scores").getter(Evaluation.getter(Evaluation::scores)).setter(Evaluation.setter(Builder::scores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scores").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Evaluation.getter(Evaluation::createdTime)).setter(Evaluation.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Evaluation.getter(Evaluation::lastModifiedTime)).setter(Evaluation.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationType").getter(Evaluation.getter(Evaluation::evaluationTypeAsString)).setter(Evaluation.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Evaluation.getter(Evaluation::tags)).setter(Evaluation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD, EVALUATION_ARN_FIELD, METADATA_FIELD, ANSWERS_FIELD, NOTES_FIELD, STATUS_FIELD, SCORES_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, EVALUATION_TYPE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Evaluation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String evaluationId;
    private final String evaluationArn;
    private final EvaluationMetadata metadata;
    private final Map<String, EvaluationAnswerOutput> answers;
    private final Map<String, EvaluationNote> notes;
    private final String status;
    private final Map<String, EvaluationScore> scores;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final String evaluationType;
    private final Map<String, String> tags;

    private Evaluation(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationArn = builder.evaluationArn;
        this.metadata = builder.metadata;
        this.answers = builder.answers;
        this.notes = builder.notes;
        this.status = builder.status;
        this.scores = builder.scores;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.evaluationType = builder.evaluationType;
        this.tags = builder.tags;
    }

    public final String evaluationId() {
        return this.evaluationId;
    }

    public final String evaluationArn() {
        return this.evaluationArn;
    }

    public final EvaluationMetadata metadata() {
        return this.metadata;
    }

    public final boolean hasAnswers() {
        return this.answers != null && !(this.answers instanceof SdkAutoConstructMap);
    }

    public final Map<String, EvaluationAnswerOutput> answers() {
        return this.answers;
    }

    public final boolean hasNotes() {
        return this.notes != null && !(this.notes instanceof SdkAutoConstructMap);
    }

    public final Map<String, EvaluationNote> notes() {
        return this.notes;
    }

    public final EvaluationStatus status() {
        return EvaluationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasScores() {
        return this.scores != null && !(this.scores instanceof SdkAutoConstructMap);
    }

    public final Map<String, EvaluationScore> scores() {
        return this.scores;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public final String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnswers() ? this.answers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotes() ? this.notes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScores() ? this.scores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation)obj;
        return Objects.equals(this.evaluationId(), other.evaluationId()) && Objects.equals(this.evaluationArn(), other.evaluationArn()) && Objects.equals(this.metadata(), other.metadata()) && this.hasAnswers() == other.hasAnswers() && Objects.equals(this.answers(), other.answers()) && this.hasNotes() == other.hasNotes() && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasScores() == other.hasScores() && Objects.equals(this.scores(), other.scores()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Evaluation").add("EvaluationId", (Object)this.evaluationId()).add("EvaluationArn", (Object)this.evaluationArn()).add("Metadata", (Object)this.metadata()).add("Answers", this.hasAnswers() ? this.answers() : null).add("Notes", this.hasNotes() ? this.notes() : null).add("Status", (Object)this.statusAsString()).add("Scores", this.hasScores() ? this.scores() : null).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvaluationId": {
                return Optional.ofNullable(clazz.cast(this.evaluationId()));
            }
            case "EvaluationArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationArn()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "Answers": {
                return Optional.ofNullable(clazz.cast(this.answers()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Scores": {
                return Optional.ofNullable(clazz.cast(this.scores()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("Answers", ANSWERS_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Scores", SCORES_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("EvaluationType", EVALUATION_TYPE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Evaluation, T> g) {
        return obj -> g.apply((Evaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evaluationId;
        private String evaluationArn;
        private EvaluationMetadata metadata;
        private Map<String, EvaluationAnswerOutput> answers = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, EvaluationNote> notes = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private Map<String, EvaluationScore> scores = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdTime;
        private Instant lastModifiedTime;
        private String evaluationType;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            this.evaluationId(model.evaluationId);
            this.evaluationArn(model.evaluationArn);
            this.metadata(model.metadata);
            this.answers(model.answers);
            this.notes(model.notes);
            this.status(model.status);
            this.scores(model.scores);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.evaluationType(model.evaluationType);
            this.tags(model.tags);
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationArn() {
            return this.evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final EvaluationMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(EvaluationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EvaluationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Map<String, EvaluationAnswerOutput.Builder> getAnswers() {
            Map<String, EvaluationAnswerOutput.Builder> result = EvaluationAnswersOutputMapCopier.copyToBuilder(this.answers);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAnswers(Map<String, EvaluationAnswerOutput.BuilderImpl> answers) {
            this.answers = EvaluationAnswersOutputMapCopier.copyFromBuilder(answers);
        }

        @Override
        public final Builder answers(Map<String, EvaluationAnswerOutput> answers) {
            this.answers = EvaluationAnswersOutputMapCopier.copy(answers);
            return this;
        }

        public final Map<String, EvaluationNote.Builder> getNotes() {
            Map<String, EvaluationNote.Builder> result = EvaluationNotesMapCopier.copyToBuilder(this.notes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNotes(Map<String, EvaluationNote.BuilderImpl> notes) {
            this.notes = EvaluationNotesMapCopier.copyFromBuilder(notes);
        }

        @Override
        public final Builder notes(Map<String, EvaluationNote> notes) {
            this.notes = EvaluationNotesMapCopier.copy(notes);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, EvaluationScore.Builder> getScores() {
            Map<String, EvaluationScore.Builder> result = EvaluationScoresMapCopier.copyToBuilder(this.scores);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setScores(Map<String, EvaluationScore.BuilderImpl> scores) {
            this.scores = EvaluationScoresMapCopier.copyFromBuilder(scores);
        }

        @Override
        public final Builder scores(Map<String, EvaluationScore> scores) {
            this.scores = EvaluationScoresMapCopier.copy(scores);
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getEvaluationType() {
            return this.evaluationType;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Evaluation build() {
            return new Evaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Evaluation> {
        public Builder evaluationId(String var1);

        public Builder evaluationArn(String var1);

        public Builder metadata(EvaluationMetadata var1);

        default public Builder metadata(Consumer<EvaluationMetadata.Builder> metadata) {
            return this.metadata((EvaluationMetadata)((EvaluationMetadata.Builder)EvaluationMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder answers(Map<String, EvaluationAnswerOutput> var1);

        public Builder notes(Map<String, EvaluationNote> var1);

        public Builder status(String var1);

        public Builder status(EvaluationStatus var1);

        public Builder scores(Map<String, EvaluationScore> var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder tags(Map<String, String> var1);
    }
}

