/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AliasConfiguration;
import software.amazon.awssdk.services.connect.model.AliasConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailAddressMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailAddressMetadata> {
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddressId").getter(EmailAddressMetadata.getter(EmailAddressMetadata::emailAddressId)).setter(EmailAddressMetadata.setter(Builder::emailAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressId").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddressArn").getter(EmailAddressMetadata.getter(EmailAddressMetadata::emailAddressArn)).setter(EmailAddressMetadata.setter(Builder::emailAddressArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddressArn").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(EmailAddressMetadata.getter(EmailAddressMetadata::emailAddress)).setter(EmailAddressMetadata.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(EmailAddressMetadata.getter(EmailAddressMetadata::description)).setter(EmailAddressMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(EmailAddressMetadata.getter(EmailAddressMetadata::displayName)).setter(EmailAddressMetadata.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<List<AliasConfiguration>> ALIAS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AliasConfigurations").getter(EmailAddressMetadata.getter(EmailAddressMetadata::aliasConfigurations)).setter(EmailAddressMetadata.setter(Builder::aliasConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AliasConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_ID_FIELD, EMAIL_ADDRESS_ARN_FIELD, EMAIL_ADDRESS_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, ALIAS_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailAddressMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String emailAddressId;
    private final String emailAddressArn;
    private final String emailAddress;
    private final String description;
    private final String displayName;
    private final List<AliasConfiguration> aliasConfigurations;

    private EmailAddressMetadata(BuilderImpl builder) {
        this.emailAddressId = builder.emailAddressId;
        this.emailAddressArn = builder.emailAddressArn;
        this.emailAddress = builder.emailAddress;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.aliasConfigurations = builder.aliasConfigurations;
    }

    public final String emailAddressId() {
        return this.emailAddressId;
    }

    public final String emailAddressArn() {
        return this.emailAddressArn;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasAliasConfigurations() {
        return this.aliasConfigurations != null && !(this.aliasConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AliasConfiguration> aliasConfigurations() {
        return this.aliasConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddressArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliasConfigurations() ? this.aliasConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailAddressMetadata)) {
            return false;
        }
        EmailAddressMetadata other = (EmailAddressMetadata)obj;
        return Objects.equals(this.emailAddressId(), other.emailAddressId()) && Objects.equals(this.emailAddressArn(), other.emailAddressArn()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && this.hasAliasConfigurations() == other.hasAliasConfigurations() && Objects.equals(this.aliasConfigurations(), other.aliasConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"EmailAddressMetadata").add("EmailAddressId", (Object)this.emailAddressId()).add("EmailAddressArn", (Object)this.emailAddressArn()).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("AliasConfigurations", this.hasAliasConfigurations() ? this.aliasConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailAddressId": {
                return Optional.ofNullable(clazz.cast(this.emailAddressId()));
            }
            case "EmailAddressArn": {
                return Optional.ofNullable(clazz.cast(this.emailAddressArn()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "AliasConfigurations": {
                return Optional.ofNullable(clazz.cast(this.aliasConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
        map.put("EmailAddressArn", EMAIL_ADDRESS_ARN_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("AliasConfigurations", ALIAS_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailAddressMetadata, T> g) {
        return obj -> g.apply((EmailAddressMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String emailAddressId;
        private String emailAddressArn;
        private String emailAddress;
        private String description;
        private String displayName;
        private List<AliasConfiguration> aliasConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EmailAddressMetadata model) {
            this.emailAddressId(model.emailAddressId);
            this.emailAddressArn(model.emailAddressArn);
            this.emailAddress(model.emailAddress);
            this.description(model.description);
            this.displayName(model.displayName);
            this.aliasConfigurations(model.aliasConfigurations);
        }

        public final String getEmailAddressId() {
            return this.emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        public final String getEmailAddressArn() {
            return this.emailAddressArn;
        }

        public final void setEmailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
        }

        @Override
        public final Builder emailAddressArn(String emailAddressArn) {
            this.emailAddressArn = emailAddressArn;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final List<AliasConfiguration.Builder> getAliasConfigurations() {
            List<AliasConfiguration.Builder> result = AliasConfigurationListCopier.copyToBuilder(this.aliasConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliasConfigurations(Collection<AliasConfiguration.BuilderImpl> aliasConfigurations) {
            this.aliasConfigurations = AliasConfigurationListCopier.copyFromBuilder(aliasConfigurations);
        }

        @Override
        public final Builder aliasConfigurations(Collection<AliasConfiguration> aliasConfigurations) {
            this.aliasConfigurations = AliasConfigurationListCopier.copy(aliasConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasConfigurations(AliasConfiguration ... aliasConfigurations) {
            this.aliasConfigurations(Arrays.asList(aliasConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasConfigurations(Consumer<AliasConfiguration.Builder> ... aliasConfigurations) {
            this.aliasConfigurations(Stream.of(aliasConfigurations).map(c -> (AliasConfiguration)((AliasConfiguration.Builder)AliasConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EmailAddressMetadata build() {
            return new EmailAddressMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailAddressMetadata> {
        public Builder emailAddressId(String var1);

        public Builder emailAddressArn(String var1);

        public Builder emailAddress(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder aliasConfigurations(Collection<AliasConfiguration> var1);

        public Builder aliasConfigurations(AliasConfiguration ... var1);

        public Builder aliasConfigurations(Consumer<AliasConfiguration.Builder> ... var1);
    }
}

