/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.DataTableLockVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataTableResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, CreateDataTableResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateDataTableResponse.getter(CreateDataTableResponse::id)).setter(CreateDataTableResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateDataTableResponse.getter(CreateDataTableResponse::arn)).setter(CreateDataTableResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LockVersion").getter(CreateDataTableResponse.getter(CreateDataTableResponse::lockVersion)).setter(CreateDataTableResponse.setter(Builder::lockVersion)).constructor(DataTableLockVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, LOCK_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataTableResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final DataTableLockVersion lockVersion;

    private CreateDataTableResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.lockVersion = builder.lockVersion;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final DataTableLockVersion lockVersion() {
        return this.lockVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataTableResponse)) {
            return false;
        }
        CreateDataTableResponse other = (CreateDataTableResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.lockVersion(), other.lockVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataTableResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("LockVersion", (Object)this.lockVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "LockVersion": {
                return Optional.ofNullable(clazz.cast(this.lockVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataTableResponse, T> g) {
        return obj -> g.apply((CreateDataTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private DataTableLockVersion lockVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataTableResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.lockVersion(model.lockVersion);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return this.lockVersion != null ? this.lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        @Override
        public CreateDataTableResponse build() {
            return new CreateDataTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataTableResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder lockVersion(DataTableLockVersion var1);

        default public Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return this.lockVersion((DataTableLockVersion)((DataTableLockVersion.Builder)DataTableLockVersion.builder().applyMutation(lockVersion)).build());
        }
    }
}

