/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.DataTableAttributeValueType;
import software.amazon.awssdk.services.connect.model.Validation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataTableAttributeRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateDataTableAttributeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateDataTableAttributeRequest.getter(CreateDataTableAttributeRequest::instanceId)).setter(CreateDataTableAttributeRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTableId").getter(CreateDataTableAttributeRequest.getter(CreateDataTableAttributeRequest::dataTableId)).setter(CreateDataTableAttributeRequest.setter(Builder::dataTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDataTableAttributeRequest.getter(CreateDataTableAttributeRequest::name)).setter(CreateDataTableAttributeRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValueType").getter(CreateDataTableAttributeRequest.getter(CreateDataTableAttributeRequest::valueTypeAsString)).setter(CreateDataTableAttributeRequest.setter(Builder::valueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateDataTableAttributeRequest.getter(CreateDataTableAttributeRequest::description)).setter(CreateDataTableAttributeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Primary").getter(CreateDataTableAttributeRequest.getter(CreateDataTableAttributeRequest::primary)).setter(CreateDataTableAttributeRequest.setter(Builder::primary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()}).build();
    private static final SdkField<Validation> VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Validation").getter(CreateDataTableAttributeRequest.getter(CreateDataTableAttributeRequest::validation)).setter(CreateDataTableAttributeRequest.setter(Builder::validation)).constructor(Validation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, DATA_TABLE_ID_FIELD, NAME_FIELD, VALUE_TYPE_FIELD, DESCRIPTION_FIELD, PRIMARY_FIELD, VALIDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataTableAttributeRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String dataTableId;
    private final String name;
    private final String valueType;
    private final String description;
    private final Boolean primary;
    private final Validation validation;

    private CreateDataTableAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.name = builder.name;
        this.valueType = builder.valueType;
        this.description = builder.description;
        this.primary = builder.primary;
        this.validation = builder.validation;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String dataTableId() {
        return this.dataTableId;
    }

    public final String name() {
        return this.name;
    }

    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(this.valueType);
    }

    public final String valueTypeAsString() {
        return this.valueType;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean primary() {
        return this.primary;
    }

    public final Validation validation() {
        return this.validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.primary());
        hashCode = 31 * hashCode + Objects.hashCode(this.validation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataTableAttributeRequest)) {
            return false;
        }
        CreateDataTableAttributeRequest other = (CreateDataTableAttributeRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.dataTableId(), other.dataTableId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.valueTypeAsString(), other.valueTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.primary(), other.primary()) && Objects.equals(this.validation(), other.validation());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataTableAttributeRequest").add("InstanceId", (Object)this.instanceId()).add("DataTableId", (Object)this.dataTableId()).add("Name", (Object)this.name()).add("ValueType", (Object)this.valueTypeAsString()).add("Description", (Object)this.description()).add("Primary", (Object)this.primary()).add("Validation", (Object)this.validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "DataTableId": {
                return Optional.ofNullable(clazz.cast(this.dataTableId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ValueType": {
                return Optional.ofNullable(clazz.cast(this.valueTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Primary": {
                return Optional.ofNullable(clazz.cast(this.primary()));
            }
            case "Validation": {
                return Optional.ofNullable(clazz.cast(this.validation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        map.put("Validation", VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataTableAttributeRequest, T> g) {
        return obj -> g.apply((CreateDataTableAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String dataTableId;
        private String name;
        private String valueType;
        private String description;
        private Boolean primary;
        private Validation validation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataTableAttributeRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.dataTableId(model.dataTableId);
            this.name(model.name);
            this.valueType(model.valueType);
            this.description(model.description);
            this.primary(model.primary);
            this.validation(model.validation);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return this.dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueType() {
            return this.valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final Validation.Builder getValidation() {
            return this.validation != null ? this.validation.toBuilder() : null;
        }

        public final void setValidation(Validation.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(Validation validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataTableAttributeRequest build() {
            return new CreateDataTableAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataTableAttributeRequest> {
        public Builder instanceId(String var1);

        public Builder dataTableId(String var1);

        public Builder name(String var1);

        public Builder valueType(String var1);

        public Builder valueType(DataTableAttributeValueType var1);

        public Builder description(String var1);

        public Builder primary(Boolean var1);

        public Builder validation(Validation var1);

        default public Builder validation(Consumer<Validation.Builder> validation) {
            return this.validation((Validation)((Validation.Builder)Validation.builder().applyMutation(validation)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

