/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains color palette configuration for different areas of a workspace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceThemePalette implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceThemePalette.Builder, WorkspaceThemePalette> {
    private static final SdkField<PaletteHeader> HEADER_FIELD = SdkField.<PaletteHeader> builder(MarshallingType.SDK_POJO)
            .memberName("Header").getter(getter(WorkspaceThemePalette::header)).setter(setter(Builder::header))
            .constructor(PaletteHeader::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()).build();

    private static final SdkField<PaletteNavigation> NAVIGATION_FIELD = SdkField
            .<PaletteNavigation> builder(MarshallingType.SDK_POJO).memberName("Navigation")
            .getter(getter(WorkspaceThemePalette::navigation)).setter(setter(Builder::navigation))
            .constructor(PaletteNavigation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Navigation").build()).build();

    private static final SdkField<PaletteCanvas> CANVAS_FIELD = SdkField.<PaletteCanvas> builder(MarshallingType.SDK_POJO)
            .memberName("Canvas").getter(getter(WorkspaceThemePalette::canvas)).setter(setter(Builder::canvas))
            .constructor(PaletteCanvas::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Canvas").build()).build();

    private static final SdkField<PalettePrimary> PRIMARY_FIELD = SdkField.<PalettePrimary> builder(MarshallingType.SDK_POJO)
            .memberName("Primary").getter(getter(WorkspaceThemePalette::primary)).setter(setter(Builder::primary))
            .constructor(PalettePrimary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD,
            NAVIGATION_FIELD, CANVAS_FIELD, PRIMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PaletteHeader header;

    private final PaletteNavigation navigation;

    private final PaletteCanvas canvas;

    private final PalettePrimary primary;

    private WorkspaceThemePalette(BuilderImpl builder) {
        this.header = builder.header;
        this.navigation = builder.navigation;
        this.canvas = builder.canvas;
        this.primary = builder.primary;
    }

    /**
     * <p>
     * The color configuration for the header area.
     * </p>
     * 
     * @return The color configuration for the header area.
     */
    public final PaletteHeader header() {
        return header;
    }

    /**
     * <p>
     * The color configuration for the navigation area.
     * </p>
     * 
     * @return The color configuration for the navigation area.
     */
    public final PaletteNavigation navigation() {
        return navigation;
    }

    /**
     * <p>
     * The color configuration for the canvas area.
     * </p>
     * 
     * @return The color configuration for the canvas area.
     */
    public final PaletteCanvas canvas() {
        return canvas;
    }

    /**
     * <p>
     * The primary color configuration used throughout the workspace.
     * </p>
     * 
     * @return The primary color configuration used throughout the workspace.
     */
    public final PalettePrimary primary() {
        return primary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(navigation());
        hashCode = 31 * hashCode + Objects.hashCode(canvas());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceThemePalette)) {
            return false;
        }
        WorkspaceThemePalette other = (WorkspaceThemePalette) obj;
        return Objects.equals(header(), other.header()) && Objects.equals(navigation(), other.navigation())
                && Objects.equals(canvas(), other.canvas()) && Objects.equals(primary(), other.primary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceThemePalette").add("Header", header()).add("Navigation", navigation())
                .add("Canvas", canvas()).add("Primary", primary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        case "Navigation":
            return Optional.ofNullable(clazz.cast(navigation()));
        case "Canvas":
            return Optional.ofNullable(clazz.cast(canvas()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Header", HEADER_FIELD);
        map.put("Navigation", NAVIGATION_FIELD);
        map.put("Canvas", CANVAS_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceThemePalette, T> g) {
        return obj -> g.apply((WorkspaceThemePalette) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceThemePalette> {
        /**
         * <p>
         * The color configuration for the header area.
         * </p>
         * 
         * @param header
         *        The color configuration for the header area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(PaletteHeader header);

        /**
         * <p>
         * The color configuration for the header area.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaletteHeader.Builder} avoiding the need
         * to create one manually via {@link PaletteHeader#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaletteHeader.Builder#build()} is called immediately and its
         * result is passed to {@link #header(PaletteHeader)}.
         * 
         * @param header
         *        a consumer that will call methods on {@link PaletteHeader.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #header(PaletteHeader)
         */
        default Builder header(Consumer<PaletteHeader.Builder> header) {
            return header(PaletteHeader.builder().applyMutation(header).build());
        }

        /**
         * <p>
         * The color configuration for the navigation area.
         * </p>
         * 
         * @param navigation
         *        The color configuration for the navigation area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder navigation(PaletteNavigation navigation);

        /**
         * <p>
         * The color configuration for the navigation area.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaletteNavigation.Builder} avoiding the
         * need to create one manually via {@link PaletteNavigation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaletteNavigation.Builder#build()} is called immediately and its
         * result is passed to {@link #navigation(PaletteNavigation)}.
         * 
         * @param navigation
         *        a consumer that will call methods on {@link PaletteNavigation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #navigation(PaletteNavigation)
         */
        default Builder navigation(Consumer<PaletteNavigation.Builder> navigation) {
            return navigation(PaletteNavigation.builder().applyMutation(navigation).build());
        }

        /**
         * <p>
         * The color configuration for the canvas area.
         * </p>
         * 
         * @param canvas
         *        The color configuration for the canvas area.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canvas(PaletteCanvas canvas);

        /**
         * <p>
         * The color configuration for the canvas area.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaletteCanvas.Builder} avoiding the need
         * to create one manually via {@link PaletteCanvas#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaletteCanvas.Builder#build()} is called immediately and its
         * result is passed to {@link #canvas(PaletteCanvas)}.
         * 
         * @param canvas
         *        a consumer that will call methods on {@link PaletteCanvas.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #canvas(PaletteCanvas)
         */
        default Builder canvas(Consumer<PaletteCanvas.Builder> canvas) {
            return canvas(PaletteCanvas.builder().applyMutation(canvas).build());
        }

        /**
         * <p>
         * The primary color configuration used throughout the workspace.
         * </p>
         * 
         * @param primary
         *        The primary color configuration used throughout the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(PalettePrimary primary);

        /**
         * <p>
         * The primary color configuration used throughout the workspace.
         * </p>
         * This is a convenience method that creates an instance of the {@link PalettePrimary.Builder} avoiding the need
         * to create one manually via {@link PalettePrimary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PalettePrimary.Builder#build()} is called immediately and its
         * result is passed to {@link #primary(PalettePrimary)}.
         * 
         * @param primary
         *        a consumer that will call methods on {@link PalettePrimary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primary(PalettePrimary)
         */
        default Builder primary(Consumer<PalettePrimary.Builder> primary) {
            return primary(PalettePrimary.builder().applyMutation(primary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PaletteHeader header;

        private PaletteNavigation navigation;

        private PaletteCanvas canvas;

        private PalettePrimary primary;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceThemePalette model) {
            header(model.header);
            navigation(model.navigation);
            canvas(model.canvas);
            primary(model.primary);
        }

        public final PaletteHeader.Builder getHeader() {
            return header != null ? header.toBuilder() : null;
        }

        public final void setHeader(PaletteHeader.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        public final Builder header(PaletteHeader header) {
            this.header = header;
            return this;
        }

        public final PaletteNavigation.Builder getNavigation() {
            return navigation != null ? navigation.toBuilder() : null;
        }

        public final void setNavigation(PaletteNavigation.BuilderImpl navigation) {
            this.navigation = navigation != null ? navigation.build() : null;
        }

        @Override
        public final Builder navigation(PaletteNavigation navigation) {
            this.navigation = navigation;
            return this;
        }

        public final PaletteCanvas.Builder getCanvas() {
            return canvas != null ? canvas.toBuilder() : null;
        }

        public final void setCanvas(PaletteCanvas.BuilderImpl canvas) {
            this.canvas = canvas != null ? canvas.build() : null;
        }

        @Override
        public final Builder canvas(PaletteCanvas canvas) {
            this.canvas = canvas;
            return this;
        }

        public final PalettePrimary.Builder getPrimary() {
            return primary != null ? primary.toBuilder() : null;
        }

        public final void setPrimary(PalettePrimary.BuilderImpl primary) {
            this.primary = primary != null ? primary.build() : null;
        }

        @Override
        public final Builder primary(PalettePrimary primary) {
            this.primary = primary;
            return this;
        }

        @Override
        public WorkspaceThemePalette build() {
            return new WorkspaceThemePalette(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
