/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a workspace association with a user or routing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceAssociationSearchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceAssociationSearchSummary.Builder, WorkspaceAssociationSearchSummary> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceId").getter(getter(WorkspaceAssociationSearchSummary::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceId").build()).build();

    private static final SdkField<String> WORKSPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceArn").getter(getter(WorkspaceAssociationSearchSummary::workspaceArn))
            .setter(setter(Builder::workspaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(WorkspaceAssociationSearchSummary::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(WorkspaceAssociationSearchSummary::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(WorkspaceAssociationSearchSummary::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(WorkspaceAssociationSearchSummary::resourceName))
            .setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            WORKSPACE_ARN_FIELD, RESOURCE_ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workspaceId;

    private final String workspaceArn;

    private final String resourceId;

    private final String resourceArn;

    private final String resourceType;

    private final String resourceName;

    private WorkspaceAssociationSearchSummary(BuilderImpl builder) {
        this.workspaceId = builder.workspaceId;
        this.workspaceArn = builder.workspaceArn;
        this.resourceId = builder.resourceId;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.resourceName = builder.resourceName;
    }

    /**
     * <p>
     * The identifier of the workspace.
     * </p>
     * 
     * @return The identifier of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the workspace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the workspace.
     */
    public final String workspaceArn() {
        return workspaceArn;
    }

    /**
     * <p>
     * The identifier of the associated resource (user or routing profile).
     * </p>
     * 
     * @return The identifier of the associated resource (user or routing profile).
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the associated resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the associated resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of resource associated with the workspace. Valid values are: <code>USER</code> and
     * <code>ROUTING_PROFILE</code>.
     * </p>
     * 
     * @return The type of resource associated with the workspace. Valid values are: <code>USER</code> and
     *         <code>ROUTING_PROFILE</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The name of the associated resource.
     * </p>
     * 
     * @return The name of the associated resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceAssociationSearchSummary)) {
            return false;
        }
        WorkspaceAssociationSearchSummary other = (WorkspaceAssociationSearchSummary) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(workspaceArn(), other.workspaceArn())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceType(), other.resourceType()) && Objects.equals(resourceName(), other.resourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceAssociationSearchSummary").add("WorkspaceId", workspaceId())
                .add("WorkspaceArn", workspaceArn()).add("ResourceId", resourceId()).add("ResourceArn", resourceArn())
                .add("ResourceType", resourceType()).add("ResourceName", resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "WorkspaceArn":
            return Optional.ofNullable(clazz.cast(workspaceArn()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("WorkspaceArn", WORKSPACE_ARN_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceAssociationSearchSummary, T> g) {
        return obj -> g.apply((WorkspaceAssociationSearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceAssociationSearchSummary> {
        /**
         * <p>
         * The identifier of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the workspace.
         * </p>
         * 
         * @param workspaceArn
         *        The Amazon Resource Name (ARN) of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceArn(String workspaceArn);

        /**
         * <p>
         * The identifier of the associated resource (user or routing profile).
         * </p>
         * 
         * @param resourceId
         *        The identifier of the associated resource (user or routing profile).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the associated resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of resource associated with the workspace. Valid values are: <code>USER</code> and
         * <code>ROUTING_PROFILE</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource associated with the workspace. Valid values are: <code>USER</code> and
         *        <code>ROUTING_PROFILE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The name of the associated resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);
    }

    static final class BuilderImpl implements Builder {
        private String workspaceId;

        private String workspaceArn;

        private String resourceId;

        private String resourceArn;

        private String resourceType;

        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceAssociationSearchSummary model) {
            workspaceId(model.workspaceId);
            workspaceArn(model.workspaceArn);
            resourceId(model.resourceId);
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            resourceName(model.resourceName);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getWorkspaceArn() {
            return workspaceArn;
        }

        public final void setWorkspaceArn(String workspaceArn) {
            this.workspaceArn = workspaceArn;
        }

        @Override
        public final Builder workspaceArn(String workspaceArn) {
            this.workspaceArn = workspaceArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public WorkspaceAssociationSearchSummary build() {
            return new WorkspaceAssociationSearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
