/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the search criteria for filtering workspace associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceAssociationSearchCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceAssociationSearchCriteria.Builder, WorkspaceAssociationSearchCriteria> {
    private static final SdkField<List<WorkspaceAssociationSearchCriteria>> OR_CONDITIONS_FIELD = SdkField
            .<List<WorkspaceAssociationSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(WorkspaceAssociationSearchCriteria::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceAssociationSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceAssociationSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WorkspaceAssociationSearchCriteria>> AND_CONDITIONS_FIELD = SdkField
            .<List<WorkspaceAssociationSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("AndConditions")
            .getter(getter(WorkspaceAssociationSearchCriteria::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkspaceAssociationSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkspaceAssociationSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField
            .<StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(WorkspaceAssociationSearchCriteria::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<WorkspaceAssociationSearchCriteria> orConditions;

    private final List<WorkspaceAssociationSearchCriteria> andConditions;

    private final StringCondition stringCondition;

    private WorkspaceAssociationSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions to be met, where at least one condition must be satisfied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions to be met, where at least one condition must be satisfied.
     */
    public final List<WorkspaceAssociationSearchCriteria> orConditions() {
        return orConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions that must all be satisfied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions that must all be satisfied.
     */
    public final List<WorkspaceAssociationSearchCriteria> andConditions() {
        return andConditions;
    }

    /**
     * Returns the value of the StringCondition property for this object.
     * 
     * @return The value of the StringCondition property for this object.
     */
    public final StringCondition stringCondition() {
        return stringCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceAssociationSearchCriteria)) {
            return false;
        }
        WorkspaceAssociationSearchCriteria other = (WorkspaceAssociationSearchCriteria) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(stringCondition(), other.stringCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceAssociationSearchCriteria")
                .add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndConditions", hasAndConditions() ? andConditions() : null).add("StringCondition", stringCondition())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndConditions", AND_CONDITIONS_FIELD);
        map.put("StringCondition", STRING_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceAssociationSearchCriteria, T> g) {
        return obj -> g.apply((WorkspaceAssociationSearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceAssociationSearchCriteria> {
        /**
         * <p>
         * A list of conditions to be met, where at least one condition must be satisfied.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions to be met, where at least one condition must be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<WorkspaceAssociationSearchCriteria> orConditions);

        /**
         * <p>
         * A list of conditions to be met, where at least one condition must be satisfied.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions to be met, where at least one condition must be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(WorkspaceAssociationSearchCriteria... orConditions);

        /**
         * <p>
         * A list of conditions to be met, where at least one condition must be satisfied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #orConditions(List<WorkspaceAssociationSearchCriteria>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<WorkspaceAssociationSearchCriteria>)
         */
        Builder orConditions(Consumer<Builder>... orConditions);

        /**
         * <p>
         * A list of conditions that must all be satisfied.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions that must all be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<WorkspaceAssociationSearchCriteria> andConditions);

        /**
         * <p>
         * A list of conditions that must all be satisfied.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions that must all be satisfied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(WorkspaceAssociationSearchCriteria... andConditions);

        /**
         * <p>
         * A list of conditions that must all be satisfied.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #andConditions(List<WorkspaceAssociationSearchCriteria>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.WorkspaceAssociationSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<WorkspaceAssociationSearchCriteria>)
         */
        Builder andConditions(Consumer<Builder>... andConditions);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * @param stringCondition
         *        The new value for the StringCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(StringCondition stringCondition);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StringCondition.Builder} avoiding the
         * need to create one manually via {@link StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stringCondition(StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(StringCondition)
         */
        default Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return stringCondition(StringCondition.builder().applyMutation(stringCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<WorkspaceAssociationSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();

        private List<WorkspaceAssociationSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();

        private StringCondition stringCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceAssociationSearchCriteria model) {
            orConditions(model.orConditions);
            andConditions(model.andConditions);
            stringCondition(model.stringCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = WorkspaceAssociationSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = WorkspaceAssociationSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<WorkspaceAssociationSearchCriteria> orConditions) {
            this.orConditions = WorkspaceAssociationSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(WorkspaceAssociationSearchCriteria... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> WorkspaceAssociationSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = WorkspaceAssociationSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = WorkspaceAssociationSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<WorkspaceAssociationSearchCriteria> andConditions) {
            this.andConditions = WorkspaceAssociationSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(WorkspaceAssociationSearchCriteria... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder>... andConditions) {
            andConditions(Stream.of(andConditions)
                    .map(c -> WorkspaceAssociationSearchCriteria.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        @Override
        public WorkspaceAssociationSearchCriteria build() {
            return new WorkspaceAssociationSearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
