/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about Amazon Connect Wisdom.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WisdomInfo implements SdkPojo, Serializable, ToCopyableBuilder<WisdomInfo.Builder, WisdomInfo> {
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionArn").getter(getter(WisdomInfo::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionArn").build()).build();

    private static final SdkField<List<AiAgentInfo>> AI_AGENTS_FIELD = SdkField
            .<List<AiAgentInfo>> builder(MarshallingType.LIST)
            .memberName("AiAgents")
            .getter(getter(WisdomInfo::aiAgents))
            .setter(setter(Builder::aiAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiAgents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AiAgentInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AiAgentInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ARN_FIELD,
            AI_AGENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionArn;

    private final List<AiAgentInfo> aiAgents;

    private WisdomInfo(BuilderImpl builder) {
        this.sessionArn = builder.sessionArn;
        this.aiAgents = builder.aiAgents;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Wisdom session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Wisdom session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AiAgents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAiAgents() {
        return aiAgents != null && !(aiAgents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of AI agents involved in the contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiAgents} method.
     * </p>
     * 
     * @return The array of AI agents involved in the contact.
     */
    public final List<AiAgentInfo> aiAgents() {
        return aiAgents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAiAgents() ? aiAgents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WisdomInfo)) {
            return false;
        }
        WisdomInfo other = (WisdomInfo) obj;
        return Objects.equals(sessionArn(), other.sessionArn()) && hasAiAgents() == other.hasAiAgents()
                && Objects.equals(aiAgents(), other.aiAgents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WisdomInfo").add("SessionArn", sessionArn()).add("AiAgents", hasAiAgents() ? aiAgents() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "AiAgents":
            return Optional.ofNullable(clazz.cast(aiAgents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionArn", SESSION_ARN_FIELD);
        map.put("AiAgents", AI_AGENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WisdomInfo, T> g) {
        return obj -> g.apply((WisdomInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WisdomInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Wisdom session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the Wisdom session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The array of AI agents involved in the contact.
         * </p>
         * 
         * @param aiAgents
         *        The array of AI agents involved in the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgents(Collection<AiAgentInfo> aiAgents);

        /**
         * <p>
         * The array of AI agents involved in the contact.
         * </p>
         * 
         * @param aiAgents
         *        The array of AI agents involved in the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgents(AiAgentInfo... aiAgents);

        /**
         * <p>
         * The array of AI agents involved in the contact.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.AiAgentInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.AiAgentInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.AiAgentInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #aiAgents(List<AiAgentInfo>)}.
         * 
         * @param aiAgents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.AiAgentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiAgents(java.util.Collection<AiAgentInfo>)
         */
        Builder aiAgents(Consumer<AiAgentInfo.Builder>... aiAgents);
    }

    static final class BuilderImpl implements Builder {
        private String sessionArn;

        private List<AiAgentInfo> aiAgents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WisdomInfo model) {
            sessionArn(model.sessionArn);
            aiAgents(model.aiAgents);
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final List<AiAgentInfo.Builder> getAiAgents() {
            List<AiAgentInfo.Builder> result = AiAgentsCopier.copyToBuilder(this.aiAgents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiAgents(Collection<AiAgentInfo.BuilderImpl> aiAgents) {
            this.aiAgents = AiAgentsCopier.copyFromBuilder(aiAgents);
        }

        @Override
        public final Builder aiAgents(Collection<AiAgentInfo> aiAgents) {
            this.aiAgents = AiAgentsCopier.copy(aiAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgents(AiAgentInfo... aiAgents) {
            aiAgents(Arrays.asList(aiAgents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiAgents(Consumer<AiAgentInfo.Builder>... aiAgents) {
            aiAgents(Stream.of(aiAgents).map(c -> AiAgentInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public WisdomInfo build() {
            return new WisdomInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
