/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the recording configuration settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceRecordingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceRecordingConfiguration.Builder, VoiceRecordingConfiguration> {
    private static final SdkField<String> VOICE_RECORDING_TRACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceRecordingTrack").getter(getter(VoiceRecordingConfiguration::voiceRecordingTrackAsString))
            .setter(setter(Builder::voiceRecordingTrack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceRecordingTrack").build())
            .build();

    private static final SdkField<String> IVR_RECORDING_TRACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IvrRecordingTrack").getter(getter(VoiceRecordingConfiguration::ivrRecordingTrackAsString))
            .setter(setter(Builder::ivrRecordingTrack))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IvrRecordingTrack").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_RECORDING_TRACK_FIELD,
            IVR_RECORDING_TRACK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String voiceRecordingTrack;

    private final String ivrRecordingTrack;

    private VoiceRecordingConfiguration(BuilderImpl builder) {
        this.voiceRecordingTrack = builder.voiceRecordingTrack;
        this.ivrRecordingTrack = builder.ivrRecordingTrack;
    }

    /**
     * <p>
     * Identifies which track is being recorded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #voiceRecordingTrack} will return {@link VoiceRecordingTrack#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #voiceRecordingTrackAsString}.
     * </p>
     * 
     * @return Identifies which track is being recorded.
     * @see VoiceRecordingTrack
     */
    public final VoiceRecordingTrack voiceRecordingTrack() {
        return VoiceRecordingTrack.fromValue(voiceRecordingTrack);
    }

    /**
     * <p>
     * Identifies which track is being recorded.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #voiceRecordingTrack} will return {@link VoiceRecordingTrack#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #voiceRecordingTrackAsString}.
     * </p>
     * 
     * @return Identifies which track is being recorded.
     * @see VoiceRecordingTrack
     */
    public final String voiceRecordingTrackAsString() {
        return voiceRecordingTrack;
    }

    /**
     * <p>
     * Identifies which IVR track is being recorded.
     * </p>
     * <p>
     * One and only one of the track configurations should be presented in the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ivrRecordingTrack}
     * will return {@link IvrRecordingTrack#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ivrRecordingTrackAsString}.
     * </p>
     * 
     * @return Identifies which IVR track is being recorded.</p>
     *         <p>
     *         One and only one of the track configurations should be presented in the request.
     * @see IvrRecordingTrack
     */
    public final IvrRecordingTrack ivrRecordingTrack() {
        return IvrRecordingTrack.fromValue(ivrRecordingTrack);
    }

    /**
     * <p>
     * Identifies which IVR track is being recorded.
     * </p>
     * <p>
     * One and only one of the track configurations should be presented in the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ivrRecordingTrack}
     * will return {@link IvrRecordingTrack#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ivrRecordingTrackAsString}.
     * </p>
     * 
     * @return Identifies which IVR track is being recorded.</p>
     *         <p>
     *         One and only one of the track configurations should be presented in the request.
     * @see IvrRecordingTrack
     */
    public final String ivrRecordingTrackAsString() {
        return ivrRecordingTrack;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceRecordingTrackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ivrRecordingTrackAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceRecordingConfiguration)) {
            return false;
        }
        VoiceRecordingConfiguration other = (VoiceRecordingConfiguration) obj;
        return Objects.equals(voiceRecordingTrackAsString(), other.voiceRecordingTrackAsString())
                && Objects.equals(ivrRecordingTrackAsString(), other.ivrRecordingTrackAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoiceRecordingConfiguration").add("VoiceRecordingTrack", voiceRecordingTrackAsString())
                .add("IvrRecordingTrack", ivrRecordingTrackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceRecordingTrack":
            return Optional.ofNullable(clazz.cast(voiceRecordingTrackAsString()));
        case "IvrRecordingTrack":
            return Optional.ofNullable(clazz.cast(ivrRecordingTrackAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VoiceRecordingTrack", VOICE_RECORDING_TRACK_FIELD);
        map.put("IvrRecordingTrack", IVR_RECORDING_TRACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoiceRecordingConfiguration, T> g) {
        return obj -> g.apply((VoiceRecordingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceRecordingConfiguration> {
        /**
         * <p>
         * Identifies which track is being recorded.
         * </p>
         * 
         * @param voiceRecordingTrack
         *        Identifies which track is being recorded.
         * @see VoiceRecordingTrack
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceRecordingTrack
         */
        Builder voiceRecordingTrack(String voiceRecordingTrack);

        /**
         * <p>
         * Identifies which track is being recorded.
         * </p>
         * 
         * @param voiceRecordingTrack
         *        Identifies which track is being recorded.
         * @see VoiceRecordingTrack
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceRecordingTrack
         */
        Builder voiceRecordingTrack(VoiceRecordingTrack voiceRecordingTrack);

        /**
         * <p>
         * Identifies which IVR track is being recorded.
         * </p>
         * <p>
         * One and only one of the track configurations should be presented in the request.
         * </p>
         * 
         * @param ivrRecordingTrack
         *        Identifies which IVR track is being recorded.</p>
         *        <p>
         *        One and only one of the track configurations should be presented in the request.
         * @see IvrRecordingTrack
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IvrRecordingTrack
         */
        Builder ivrRecordingTrack(String ivrRecordingTrack);

        /**
         * <p>
         * Identifies which IVR track is being recorded.
         * </p>
         * <p>
         * One and only one of the track configurations should be presented in the request.
         * </p>
         * 
         * @param ivrRecordingTrack
         *        Identifies which IVR track is being recorded.</p>
         *        <p>
         *        One and only one of the track configurations should be presented in the request.
         * @see IvrRecordingTrack
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IvrRecordingTrack
         */
        Builder ivrRecordingTrack(IvrRecordingTrack ivrRecordingTrack);
    }

    static final class BuilderImpl implements Builder {
        private String voiceRecordingTrack;

        private String ivrRecordingTrack;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceRecordingConfiguration model) {
            voiceRecordingTrack(model.voiceRecordingTrack);
            ivrRecordingTrack(model.ivrRecordingTrack);
        }

        public final String getVoiceRecordingTrack() {
            return voiceRecordingTrack;
        }

        public final void setVoiceRecordingTrack(String voiceRecordingTrack) {
            this.voiceRecordingTrack = voiceRecordingTrack;
        }

        @Override
        public final Builder voiceRecordingTrack(String voiceRecordingTrack) {
            this.voiceRecordingTrack = voiceRecordingTrack;
            return this;
        }

        @Override
        public final Builder voiceRecordingTrack(VoiceRecordingTrack voiceRecordingTrack) {
            this.voiceRecordingTrack(voiceRecordingTrack == null ? null : voiceRecordingTrack.toString());
            return this;
        }

        public final String getIvrRecordingTrack() {
            return ivrRecordingTrack;
        }

        public final void setIvrRecordingTrack(String ivrRecordingTrack) {
            this.ivrRecordingTrack = ivrRecordingTrack;
        }

        @Override
        public final Builder ivrRecordingTrack(String ivrRecordingTrack) {
            this.ivrRecordingTrack = ivrRecordingTrack;
            return this;
        }

        @Override
        public final Builder ivrRecordingTrack(IvrRecordingTrack ivrRecordingTrack) {
            this.ivrRecordingTrack(ivrRecordingTrack == null ? null : ivrRecordingTrack.toString());
            return this;
        }

        @Override
        public VoiceRecordingConfiguration build() {
            return new VoiceRecordingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
