/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkspaceThemeRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateWorkspaceThemeRequest.Builder, UpdateWorkspaceThemeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateWorkspaceThemeRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceId").getter(getter(UpdateWorkspaceThemeRequest::workspaceId))
            .setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkspaceId").build()).build();

    private static final SdkField<WorkspaceTheme> THEME_FIELD = SdkField.<WorkspaceTheme> builder(MarshallingType.SDK_POJO)
            .memberName("Theme").getter(getter(UpdateWorkspaceThemeRequest::theme)).setter(setter(Builder::theme))
            .constructor(WorkspaceTheme::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Theme").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            WORKSPACE_ID_FIELD, THEME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String workspaceId;

    private final WorkspaceTheme theme;

    private UpdateWorkspaceThemeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.workspaceId = builder.workspaceId;
        this.theme = builder.theme;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the workspace.
     * </p>
     * 
     * @return The identifier of the workspace.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The theme configuration, including color schemes and visual styles.
     * </p>
     * 
     * @return The theme configuration, including color schemes and visual styles.
     */
    public final WorkspaceTheme theme() {
        return theme;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(theme());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkspaceThemeRequest)) {
            return false;
        }
        UpdateWorkspaceThemeRequest other = (UpdateWorkspaceThemeRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(workspaceId(), other.workspaceId())
                && Objects.equals(theme(), other.theme());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkspaceThemeRequest").add("InstanceId", instanceId()).add("WorkspaceId", workspaceId())
                .add("Theme", theme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "WorkspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "Theme":
            return Optional.ofNullable(clazz.cast(theme()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("WorkspaceId", WORKSPACE_ID_FIELD);
        map.put("Theme", THEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkspaceThemeRequest, T> g) {
        return obj -> g.apply((UpdateWorkspaceThemeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkspaceThemeRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the workspace.
         * </p>
         * 
         * @param workspaceId
         *        The identifier of the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The theme configuration, including color schemes and visual styles.
         * </p>
         * 
         * @param theme
         *        The theme configuration, including color schemes and visual styles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder theme(WorkspaceTheme theme);

        /**
         * <p>
         * The theme configuration, including color schemes and visual styles.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceTheme.Builder} avoiding the need
         * to create one manually via {@link WorkspaceTheme#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceTheme.Builder#build()} is called immediately and its
         * result is passed to {@link #theme(WorkspaceTheme)}.
         * 
         * @param theme
         *        a consumer that will call methods on {@link WorkspaceTheme.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #theme(WorkspaceTheme)
         */
        default Builder theme(Consumer<WorkspaceTheme.Builder> theme) {
            return theme(WorkspaceTheme.builder().applyMutation(theme).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String workspaceId;

        private WorkspaceTheme theme;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkspaceThemeRequest model) {
            super(model);
            instanceId(model.instanceId);
            workspaceId(model.workspaceId);
            theme(model.theme);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final WorkspaceTheme.Builder getTheme() {
            return theme != null ? theme.toBuilder() : null;
        }

        public final void setTheme(WorkspaceTheme.BuilderImpl theme) {
            this.theme = theme != null ? theme.build() : null;
        }

        @Override
        public final Builder theme(WorkspaceTheme theme) {
            this.theme = theme;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkspaceThemeRequest build() {
            return new UpdateWorkspaceThemeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
