/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataTableMetadataRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateDataTableMetadataRequest.Builder, UpdateDataTableMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateDataTableMetadataRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableId").getter(getter(UpdateDataTableMetadataRequest::dataTableId))
            .setter(setter(Builder::dataTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDataTableMetadataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDataTableMetadataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VALUE_LOCK_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueLockLevel").getter(getter(UpdateDataTableMetadataRequest::valueLockLevelAsString))
            .setter(setter(Builder::valueLockLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueLockLevel").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(UpdateDataTableMetadataRequest::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DATA_TABLE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, VALUE_LOCK_LEVEL_FIELD, TIME_ZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String dataTableId;

    private final String name;

    private final String description;

    private final String valueLockLevel;

    private final String timeZone;

    private UpdateDataTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.name = builder.name;
        this.description = builder.description;
        this.valueLockLevel = builder.valueLockLevel;
        this.timeZone = builder.timeZone;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the data table. Must also accept the table ARN with or without a version alias. If the
     * version is provided as part of the identifier or ARN, the version must be $LATEST. Providing any other alias
     * fails with an error.
     * </p>
     * 
     * @return The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     *         If the version is provided as part of the identifier or ARN, the version must be $LATEST. Providing any
     *         other alias fails with an error.
     */
    public final String dataTableId() {
        return dataTableId;
    }

    /**
     * <p>
     * The updated name for the data table. Must conform to Connect human readable string specification and have 1-127
     * characters. Must be unique for the instance using case-insensitive comparison.
     * </p>
     * 
     * @return The updated name for the data table. Must conform to Connect human readable string specification and have
     *         1-127 characters. Must be unique for the instance using case-insensitive comparison.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated description for the data table. Must conform to Connect human readable string specification and have
     * 0-250 characters.
     * </p>
     * 
     * @return The updated description for the data table. Must conform to Connect human readable string specification
     *         and have 0-250 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and NONE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueLockLevel}
     * will return {@link DataTableLockLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #valueLockLevelAsString}.
     * </p>
     * 
     * @return The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and
     *         NONE.
     * @see DataTableLockLevel
     */
    public final DataTableLockLevel valueLockLevel() {
        return DataTableLockLevel.fromValue(valueLockLevel);
    }

    /**
     * <p>
     * The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and NONE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueLockLevel}
     * will return {@link DataTableLockLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #valueLockLevelAsString}.
     * </p>
     * 
     * @return The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and
     *         NONE.
     * @see DataTableLockLevel
     */
    public final String valueLockLevelAsString() {
        return valueLockLevel;
    }

    /**
     * <p>
     * The updated IANA timezone identifier to use when resolving time based dynamic values.
     * </p>
     * 
     * @return The updated IANA timezone identifier to use when resolving time based dynamic values.
     */
    public final String timeZone() {
        return timeZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(valueLockLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataTableMetadataRequest)) {
            return false;
        }
        UpdateDataTableMetadataRequest other = (UpdateDataTableMetadataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(dataTableId(), other.dataTableId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(valueLockLevelAsString(), other.valueLockLevelAsString())
                && Objects.equals(timeZone(), other.timeZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataTableMetadataRequest").add("InstanceId", instanceId())
                .add("DataTableId", dataTableId()).add("Name", name()).add("Description", description())
                .add("ValueLockLevel", valueLockLevelAsString()).add("TimeZone", timeZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DataTableId":
            return Optional.ofNullable(clazz.cast(dataTableId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ValueLockLevel":
            return Optional.ofNullable(clazz.cast(valueLockLevelAsString()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ValueLockLevel", VALUE_LOCK_LEVEL_FIELD);
        map.put("TimeZone", TIME_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataTableMetadataRequest, T> g) {
        return obj -> g.apply((UpdateDataTableMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataTableMetadataRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the data table. Must also accept the table ARN with or without a version alias. If
         * the version is provided as part of the identifier or ARN, the version must be $LATEST. Providing any other
         * alias fails with an error.
         * </p>
         * 
         * @param dataTableId
         *        The unique identifier for the data table. Must also accept the table ARN with or without a version
         *        alias. If the version is provided as part of the identifier or ARN, the version must be $LATEST.
         *        Providing any other alias fails with an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableId(String dataTableId);

        /**
         * <p>
         * The updated name for the data table. Must conform to Connect human readable string specification and have
         * 1-127 characters. Must be unique for the instance using case-insensitive comparison.
         * </p>
         * 
         * @param name
         *        The updated name for the data table. Must conform to Connect human readable string specification and
         *        have 1-127 characters. Must be unique for the instance using case-insensitive comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated description for the data table. Must conform to Connect human readable string specification and
         * have 0-250 characters.
         * </p>
         * 
         * @param description
         *        The updated description for the data table. Must conform to Connect human readable string
         *        specification and have 0-250 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and
         * NONE.
         * </p>
         * 
         * @param valueLockLevel
         *        The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE,
         *        and NONE.
         * @see DataTableLockLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableLockLevel
         */
        Builder valueLockLevel(String valueLockLevel);

        /**
         * <p>
         * The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE, and
         * NONE.
         * </p>
         * 
         * @param valueLockLevel
         *        The updated value lock level for the data table. One of DATA_TABLE, PRIMARY_VALUE, ATTRIBUTE, VALUE,
         *        and NONE.
         * @see DataTableLockLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableLockLevel
         */
        Builder valueLockLevel(DataTableLockLevel valueLockLevel);

        /**
         * <p>
         * The updated IANA timezone identifier to use when resolving time based dynamic values.
         * </p>
         * 
         * @param timeZone
         *        The updated IANA timezone identifier to use when resolving time based dynamic values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String dataTableId;

        private String name;

        private String description;

        private String valueLockLevel;

        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataTableMetadataRequest model) {
            super(model);
            instanceId(model.instanceId);
            dataTableId(model.dataTableId);
            name(model.name);
            description(model.description);
            valueLockLevel(model.valueLockLevel);
            timeZone(model.timeZone);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getValueLockLevel() {
            return valueLockLevel;
        }

        public final void setValueLockLevel(String valueLockLevel) {
            this.valueLockLevel = valueLockLevel;
        }

        @Override
        public final Builder valueLockLevel(String valueLockLevel) {
            this.valueLockLevel = valueLockLevel;
            return this;
        }

        @Override
        public final Builder valueLockLevel(DataTableLockLevel valueLockLevel) {
            this.valueLockLevel(valueLockLevel == null ? null : valueLockLevel.toString());
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataTableMetadataRequest build() {
            return new UpdateDataTableMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
