/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataTableAttributeRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateDataTableAttributeRequest.Builder, UpdateDataTableAttributeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateDataTableAttributeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableId").getter(getter(UpdateDataTableAttributeRequest::dataTableId))
            .setter(setter(Builder::dataTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(UpdateDataTableAttributeRequest::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AttributeName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDataTableAttributeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueType").getter(getter(UpdateDataTableAttributeRequest::valueTypeAsString))
            .setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDataTableAttributeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Primary").getter(getter(UpdateDataTableAttributeRequest::primary)).setter(setter(Builder::primary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<Validation> VALIDATION_FIELD = SdkField.<Validation> builder(MarshallingType.SDK_POJO)
            .memberName("Validation").getter(getter(UpdateDataTableAttributeRequest::validation))
            .setter(setter(Builder::validation)).constructor(Validation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DATA_TABLE_ID_FIELD, ATTRIBUTE_NAME_FIELD, NAME_FIELD, VALUE_TYPE_FIELD, DESCRIPTION_FIELD, PRIMARY_FIELD,
            VALIDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String dataTableId;

    private final String attributeName;

    private final String name;

    private final String valueType;

    private final String description;

    private final Boolean primary;

    private final Validation validation;

    private UpdateDataTableAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.attributeName = builder.attributeName;
        this.name = builder.name;
        this.valueType = builder.valueType;
        this.description = builder.description;
        this.primary = builder.primary;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     * </p>
     * 
     * @return The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     */
    public final String dataTableId() {
        return dataTableId;
    }

    /**
     * <p>
     * The current name of the attribute to update. Used as an identifier since attribute names can be changed.
     * </p>
     * 
     * @return The current name of the attribute to update. Used as an identifier since attribute names can be changed.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The new name for the attribute. Must conform to Connect human readable string specification and be unique within
     * the data table.
     * </p>
     * 
     * @return The new name for the attribute. Must conform to Connect human readable string specification and be unique
     *         within the data table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated value type for the attribute. When changing value types, existing values are not deleted but may
     * return default values if incompatible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The updated value type for the attribute. When changing value types, existing values are not deleted but
     *         may return default values if incompatible.
     * @see DataTableAttributeValueType
     */
    public final DataTableAttributeValueType valueType() {
        return DataTableAttributeValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The updated value type for the attribute. When changing value types, existing values are not deleted but may
     * return default values if incompatible.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link DataTableAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The updated value type for the attribute. When changing value types, existing values are not deleted but
     *         may return default values if incompatible.
     * @see DataTableAttributeValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    /**
     * <p>
     * The updated description for the attribute.
     * </p>
     * 
     * @return The updated description for the attribute.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the attribute should be treated as a primary key. Converting to primary attribute requires existing
     * values to maintain uniqueness.
     * </p>
     * 
     * @return Whether the attribute should be treated as a primary key. Converting to primary attribute requires
     *         existing values to maintain uniqueness.
     */
    public final Boolean primary() {
        return primary;
    }

    /**
     * <p>
     * The updated validation rules for the attribute. Changes do not affect existing values until they are modified.
     * </p>
     * 
     * @return The updated validation rules for the attribute. Changes do not affect existing values until they are
     *         modified.
     */
    public final Validation validation() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(validation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataTableAttributeRequest)) {
            return false;
        }
        UpdateDataTableAttributeRequest other = (UpdateDataTableAttributeRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(dataTableId(), other.dataTableId())
                && Objects.equals(attributeName(), other.attributeName()) && Objects.equals(name(), other.name())
                && Objects.equals(valueTypeAsString(), other.valueTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(primary(), other.primary())
                && Objects.equals(validation(), other.validation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataTableAttributeRequest").add("InstanceId", instanceId())
                .add("DataTableId", dataTableId()).add("AttributeName", attributeName()).add("Name", name())
                .add("ValueType", valueTypeAsString()).add("Description", description()).add("Primary", primary())
                .add("Validation", validation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DataTableId":
            return Optional.ofNullable(clazz.cast(dataTableId()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ValueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "Validation":
            return Optional.ofNullable(clazz.cast(validation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ValueType", VALUE_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        map.put("Validation", VALIDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataTableAttributeRequest, T> g) {
        return obj -> g.apply((UpdateDataTableAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataTableAttributeRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
         * </p>
         * 
         * @param dataTableId
         *        The unique identifier for the data table. Must also accept the table ARN with or without a version
         *        alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableId(String dataTableId);

        /**
         * <p>
         * The current name of the attribute to update. Used as an identifier since attribute names can be changed.
         * </p>
         * 
         * @param attributeName
         *        The current name of the attribute to update. Used as an identifier since attribute names can be
         *        changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The new name for the attribute. Must conform to Connect human readable string specification and be unique
         * within the data table.
         * </p>
         * 
         * @param name
         *        The new name for the attribute. Must conform to Connect human readable string specification and be
         *        unique within the data table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated value type for the attribute. When changing value types, existing values are not deleted but may
         * return default values if incompatible.
         * </p>
         * 
         * @param valueType
         *        The updated value type for the attribute. When changing value types, existing values are not deleted
         *        but may return default values if incompatible.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The updated value type for the attribute. When changing value types, existing values are not deleted but may
         * return default values if incompatible.
         * </p>
         * 
         * @param valueType
         *        The updated value type for the attribute. When changing value types, existing values are not deleted
         *        but may return default values if incompatible.
         * @see DataTableAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataTableAttributeValueType
         */
        Builder valueType(DataTableAttributeValueType valueType);

        /**
         * <p>
         * The updated description for the attribute.
         * </p>
         * 
         * @param description
         *        The updated description for the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the attribute should be treated as a primary key. Converting to primary attribute requires existing
         * values to maintain uniqueness.
         * </p>
         * 
         * @param primary
         *        Whether the attribute should be treated as a primary key. Converting to primary attribute requires
         *        existing values to maintain uniqueness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);

        /**
         * <p>
         * The updated validation rules for the attribute. Changes do not affect existing values until they are
         * modified.
         * </p>
         * 
         * @param validation
         *        The updated validation rules for the attribute. Changes do not affect existing values until they are
         *        modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validation(Validation validation);

        /**
         * <p>
         * The updated validation rules for the attribute. Changes do not affect existing values until they are
         * modified.
         * </p>
         * This is a convenience method that creates an instance of the {@link Validation.Builder} avoiding the need to
         * create one manually via {@link Validation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Validation.Builder#build()} is called immediately and its result
         * is passed to {@link #validation(Validation)}.
         * 
         * @param validation
         *        a consumer that will call methods on {@link Validation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validation(Validation)
         */
        default Builder validation(Consumer<Validation.Builder> validation) {
            return validation(Validation.builder().applyMutation(validation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String dataTableId;

        private String attributeName;

        private String name;

        private String valueType;

        private String description;

        private Boolean primary;

        private Validation validation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataTableAttributeRequest model) {
            super(model);
            instanceId(model.instanceId);
            dataTableId(model.dataTableId);
            attributeName(model.attributeName);
            name(model.name);
            valueType(model.valueType);
            description(model.description);
            primary(model.primary);
            validation(model.validation);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(DataTableAttributeValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final Validation.Builder getValidation() {
            return validation != null ? validation.toBuilder() : null;
        }

        public final void setValidation(Validation.BuilderImpl validation) {
            this.validation = validation != null ? validation.build() : null;
        }

        @Override
        public final Builder validation(Validation validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataTableAttributeRequest build() {
            return new UpdateDataTableAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
