/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search criteria to be used to return tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagSearchCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<TagSearchCondition.Builder, TagSearchCondition> {
    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tagKey")
            .getter(getter(TagSearchCondition::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKey").build()).build();

    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tagValue").getter(getter(TagSearchCondition::tagValue)).setter(setter(Builder::tagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValue").build()).build();

    private static final SdkField<String> TAG_KEY_COMPARISON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tagKeyComparisonType").getter(getter(TagSearchCondition::tagKeyComparisonTypeAsString))
            .setter(setter(Builder::tagKeyComparisonType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagKeyComparisonType").build())
            .build();

    private static final SdkField<String> TAG_VALUE_COMPARISON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tagValueComparisonType").getter(getter(TagSearchCondition::tagValueComparisonTypeAsString))
            .setter(setter(Builder::tagValueComparisonType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagValueComparisonType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_KEY_FIELD,
            TAG_VALUE_FIELD, TAG_KEY_COMPARISON_TYPE_FIELD, TAG_VALUE_COMPARISON_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tagKey;

    private final String tagValue;

    private final String tagKeyComparisonType;

    private final String tagValueComparisonType;

    private TagSearchCondition(BuilderImpl builder) {
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.tagKeyComparisonType = builder.tagKeyComparisonType;
        this.tagValueComparisonType = builder.tagValueComparisonType;
    }

    /**
     * <p>
     * The tag key used in the tag search condition.
     * </p>
     * 
     * @return The tag key used in the tag search condition.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The tag value used in the tag search condition.
     * </p>
     * 
     * @return The tag value used in the tag search condition.
     */
    public final String tagValue() {
        return tagValue;
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the tag key in tag search condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tagKeyComparisonType} will return {@link StringComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tagKeyComparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the tag key in tag search condition.
     * @see StringComparisonType
     */
    public final StringComparisonType tagKeyComparisonType() {
        return StringComparisonType.fromValue(tagKeyComparisonType);
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the tag key in tag search condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tagKeyComparisonType} will return {@link StringComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tagKeyComparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the tag key in tag search condition.
     * @see StringComparisonType
     */
    public final String tagKeyComparisonTypeAsString() {
        return tagKeyComparisonType;
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the tag value in tag search condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tagValueComparisonType} will return {@link StringComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tagValueComparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the tag value in tag search condition.
     * @see StringComparisonType
     */
    public final StringComparisonType tagValueComparisonType() {
        return StringComparisonType.fromValue(tagValueComparisonType);
    }

    /**
     * <p>
     * The type of comparison to be made when evaluating the tag value in tag search condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #tagValueComparisonType} will return {@link StringComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #tagValueComparisonTypeAsString}.
     * </p>
     * 
     * @return The type of comparison to be made when evaluating the tag value in tag search condition.
     * @see StringComparisonType
     */
    public final String tagValueComparisonTypeAsString() {
        return tagValueComparisonType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(tagKeyComparisonTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tagValueComparisonTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagSearchCondition)) {
            return false;
        }
        TagSearchCondition other = (TagSearchCondition) obj;
        return Objects.equals(tagKey(), other.tagKey()) && Objects.equals(tagValue(), other.tagValue())
                && Objects.equals(tagKeyComparisonTypeAsString(), other.tagKeyComparisonTypeAsString())
                && Objects.equals(tagValueComparisonTypeAsString(), other.tagValueComparisonTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagSearchCondition").add("TagKey", tagKey()).add("TagValue", tagValue())
                .add("TagKeyComparisonType", tagKeyComparisonTypeAsString())
                .add("TagValueComparisonType", tagValueComparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "tagValue":
            return Optional.ofNullable(clazz.cast(tagValue()));
        case "tagKeyComparisonType":
            return Optional.ofNullable(clazz.cast(tagKeyComparisonTypeAsString()));
        case "tagValueComparisonType":
            return Optional.ofNullable(clazz.cast(tagValueComparisonTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tagKey", TAG_KEY_FIELD);
        map.put("tagValue", TAG_VALUE_FIELD);
        map.put("tagKeyComparisonType", TAG_KEY_COMPARISON_TYPE_FIELD);
        map.put("tagValueComparisonType", TAG_VALUE_COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TagSearchCondition, T> g) {
        return obj -> g.apply((TagSearchCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagSearchCondition> {
        /**
         * <p>
         * The tag key used in the tag search condition.
         * </p>
         * 
         * @param tagKey
         *        The tag key used in the tag search condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The tag value used in the tag search condition.
         * </p>
         * 
         * @param tagValue
         *        The tag value used in the tag search condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);

        /**
         * <p>
         * The type of comparison to be made when evaluating the tag key in tag search condition.
         * </p>
         * 
         * @param tagKeyComparisonType
         *        The type of comparison to be made when evaluating the tag key in tag search condition.
         * @see StringComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringComparisonType
         */
        Builder tagKeyComparisonType(String tagKeyComparisonType);

        /**
         * <p>
         * The type of comparison to be made when evaluating the tag key in tag search condition.
         * </p>
         * 
         * @param tagKeyComparisonType
         *        The type of comparison to be made when evaluating the tag key in tag search condition.
         * @see StringComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringComparisonType
         */
        Builder tagKeyComparisonType(StringComparisonType tagKeyComparisonType);

        /**
         * <p>
         * The type of comparison to be made when evaluating the tag value in tag search condition.
         * </p>
         * 
         * @param tagValueComparisonType
         *        The type of comparison to be made when evaluating the tag value in tag search condition.
         * @see StringComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringComparisonType
         */
        Builder tagValueComparisonType(String tagValueComparisonType);

        /**
         * <p>
         * The type of comparison to be made when evaluating the tag value in tag search condition.
         * </p>
         * 
         * @param tagValueComparisonType
         *        The type of comparison to be made when evaluating the tag value in tag search condition.
         * @see StringComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StringComparisonType
         */
        Builder tagValueComparisonType(StringComparisonType tagValueComparisonType);
    }

    static final class BuilderImpl implements Builder {
        private String tagKey;

        private String tagValue;

        private String tagKeyComparisonType;

        private String tagValueComparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(TagSearchCondition model) {
            tagKey(model.tagKey);
            tagValue(model.tagValue);
            tagKeyComparisonType(model.tagKeyComparisonType);
            tagValueComparisonType(model.tagValueComparisonType);
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final String getTagKeyComparisonType() {
            return tagKeyComparisonType;
        }

        public final void setTagKeyComparisonType(String tagKeyComparisonType) {
            this.tagKeyComparisonType = tagKeyComparisonType;
        }

        @Override
        public final Builder tagKeyComparisonType(String tagKeyComparisonType) {
            this.tagKeyComparisonType = tagKeyComparisonType;
            return this;
        }

        @Override
        public final Builder tagKeyComparisonType(StringComparisonType tagKeyComparisonType) {
            this.tagKeyComparisonType(tagKeyComparisonType == null ? null : tagKeyComparisonType.toString());
            return this;
        }

        public final String getTagValueComparisonType() {
            return tagValueComparisonType;
        }

        public final void setTagValueComparisonType(String tagValueComparisonType) {
            this.tagValueComparisonType = tagValueComparisonType;
        }

        @Override
        public final Builder tagValueComparisonType(String tagValueComparisonType) {
            this.tagValueComparisonType = tagValueComparisonType;
            return this;
        }

        @Override
        public final Builder tagValueComparisonType(StringComparisonType tagValueComparisonType) {
            this.tagValueComparisonType(tagValueComparisonType == null ? null : tagValueComparisonType.toString());
            return this;
        }

        @Override
        public TagSearchCondition build() {
            return new TagSearchCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
