/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchEmailAddressesResponse extends ConnectResponse implements
        ToCopyableBuilder<SearchEmailAddressesResponse.Builder, SearchEmailAddressesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchEmailAddressesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<EmailAddressMetadata>> EMAIL_ADDRESSES_FIELD = SdkField
            .<List<EmailAddressMetadata>> builder(MarshallingType.LIST)
            .memberName("EmailAddresses")
            .getter(getter(SearchEmailAddressesResponse::emailAddresses))
            .setter(setter(Builder::emailAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailAddressMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailAddressMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> APPROXIMATE_TOTAL_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ApproximateTotalCount").getter(getter(SearchEmailAddressesResponse::approximateTotalCount))
            .setter(setter(Builder::approximateTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateTotalCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            EMAIL_ADDRESSES_FIELD, APPROXIMATE_TOTAL_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<EmailAddressMetadata> emailAddresses;

    private final Long approximateTotalCount;

    private SearchEmailAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.emailAddresses = builder.emailAddresses;
        this.approximateTotalCount = builder.approximateTotalCount;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmailAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmailAddresses() {
        return emailAddresses != null && !(emailAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of email addresses matching SearchFilter and SearchCriteria
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmailAddresses} method.
     * </p>
     * 
     * @return List of email addresses matching SearchFilter and SearchCriteria
     */
    public final List<EmailAddressMetadata> emailAddresses() {
        return emailAddresses;
    }

    /**
     * <p>
     * The total number of email addresses which matched your search query.
     * </p>
     * 
     * @return The total number of email addresses which matched your search query.
     */
    public final Long approximateTotalCount() {
        return approximateTotalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEmailAddresses() ? emailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(approximateTotalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEmailAddressesResponse)) {
            return false;
        }
        SearchEmailAddressesResponse other = (SearchEmailAddressesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasEmailAddresses() == other.hasEmailAddresses()
                && Objects.equals(emailAddresses(), other.emailAddresses())
                && Objects.equals(approximateTotalCount(), other.approximateTotalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchEmailAddressesResponse").add("NextToken", nextToken())
                .add("EmailAddresses", hasEmailAddresses() ? emailAddresses() : null)
                .add("ApproximateTotalCount", approximateTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "EmailAddresses":
            return Optional.ofNullable(clazz.cast(emailAddresses()));
        case "ApproximateTotalCount":
            return Optional.ofNullable(clazz.cast(approximateTotalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EmailAddresses", EMAIL_ADDRESSES_FIELD);
        map.put("ApproximateTotalCount", APPROXIMATE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchEmailAddressesResponse, T> g) {
        return obj -> g.apply((SearchEmailAddressesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchEmailAddressesResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of email addresses matching SearchFilter and SearchCriteria
         * </p>
         * 
         * @param emailAddresses
         *        List of email addresses matching SearchFilter and SearchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddresses(Collection<EmailAddressMetadata> emailAddresses);

        /**
         * <p>
         * List of email addresses matching SearchFilter and SearchCriteria
         * </p>
         * 
         * @param emailAddresses
         *        List of email addresses matching SearchFilter and SearchCriteria
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddresses(EmailAddressMetadata... emailAddresses);

        /**
         * <p>
         * List of email addresses matching SearchFilter and SearchCriteria
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EmailAddressMetadata.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.EmailAddressMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EmailAddressMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #emailAddresses(List<EmailAddressMetadata>)}.
         * 
         * @param emailAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EmailAddressMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailAddresses(java.util.Collection<EmailAddressMetadata>)
         */
        Builder emailAddresses(Consumer<EmailAddressMetadata.Builder>... emailAddresses);

        /**
         * <p>
         * The total number of email addresses which matched your search query.
         * </p>
         * 
         * @param approximateTotalCount
         *        The total number of email addresses which matched your search query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateTotalCount(Long approximateTotalCount);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<EmailAddressMetadata> emailAddresses = DefaultSdkAutoConstructList.getInstance();

        private Long approximateTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEmailAddressesResponse model) {
            super(model);
            nextToken(model.nextToken);
            emailAddresses(model.emailAddresses);
            approximateTotalCount(model.approximateTotalCount);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EmailAddressMetadata.Builder> getEmailAddresses() {
            List<EmailAddressMetadata.Builder> result = EmailAddressListCopier.copyToBuilder(this.emailAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailAddresses(Collection<EmailAddressMetadata.BuilderImpl> emailAddresses) {
            this.emailAddresses = EmailAddressListCopier.copyFromBuilder(emailAddresses);
        }

        @Override
        public final Builder emailAddresses(Collection<EmailAddressMetadata> emailAddresses) {
            this.emailAddresses = EmailAddressListCopier.copy(emailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailAddresses(EmailAddressMetadata... emailAddresses) {
            emailAddresses(Arrays.asList(emailAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailAddresses(Consumer<EmailAddressMetadata.Builder>... emailAddresses) {
            emailAddresses(Stream.of(emailAddresses).map(c -> EmailAddressMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getApproximateTotalCount() {
            return approximateTotalCount;
        }

        public final void setApproximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
        }

        @Override
        public final Builder approximateTotalCount(Long approximateTotalCount) {
            this.approximateTotalCount = approximateTotalCount;
            return this;
        }

        @Override
        public SearchEmailAddressesResponse build() {
            return new SearchEmailAddressesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
