/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchDataTablesRequest extends ConnectRequest implements
        ToCopyableBuilder<SearchDataTablesRequest.Builder, SearchDataTablesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SearchDataTablesRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchDataTablesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchDataTablesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<DataTableSearchFilter> SEARCH_FILTER_FIELD = SdkField
            .<DataTableSearchFilter> builder(MarshallingType.SDK_POJO).memberName("SearchFilter")
            .getter(getter(SearchDataTablesRequest::searchFilter)).setter(setter(Builder::searchFilter))
            .constructor(DataTableSearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchFilter").build()).build();

    private static final SdkField<DataTableSearchCriteria> SEARCH_CRITERIA_FIELD = SdkField
            .<DataTableSearchCriteria> builder(MarshallingType.SDK_POJO).memberName("SearchCriteria")
            .getter(getter(SearchDataTablesRequest::searchCriteria)).setter(setter(Builder::searchCriteria))
            .constructor(DataTableSearchCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SEARCH_FILTER_FIELD, SEARCH_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String nextToken;

    private final Integer maxResults;

    private final DataTableSearchFilter searchFilter;

    private final DataTableSearchCriteria searchCriteria;

    private SearchDataTablesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.searchFilter = builder.searchFilter;
        this.searchCriteria = builder.searchCriteria;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance to search within.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance to search within.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of data tables to return in one page of results.
     * </p>
     * 
     * @return The maximum number of data tables to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Optional filters to apply to the search results, such as tag-based filtering for attribute-based access control.
     * </p>
     * 
     * @return Optional filters to apply to the search results, such as tag-based filtering for attribute-based access
     *         control.
     */
    public final DataTableSearchFilter searchFilter() {
        return searchFilter;
    }

    /**
     * <p>
     * Search criteria including string conditions for matching table names, descriptions, or resource IDs. Supports
     * STARTS_WITH, CONTAINS, and EXACT comparison types.
     * </p>
     * 
     * @return Search criteria including string conditions for matching table names, descriptions, or resource IDs.
     *         Supports STARTS_WITH, CONTAINS, and EXACT comparison types.
     */
    public final DataTableSearchCriteria searchCriteria() {
        return searchCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(searchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(searchCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchDataTablesRequest)) {
            return false;
        }
        SearchDataTablesRequest other = (SearchDataTablesRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(searchFilter(), other.searchFilter())
                && Objects.equals(searchCriteria(), other.searchCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchDataTablesRequest").add("InstanceId", instanceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SearchFilter", searchFilter()).add("SearchCriteria", searchCriteria())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SearchFilter":
            return Optional.ofNullable(clazz.cast(searchFilter()));
        case "SearchCriteria":
            return Optional.ofNullable(clazz.cast(searchCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("SearchFilter", SEARCH_FILTER_FIELD);
        map.put("SearchCriteria", SEARCH_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchDataTablesRequest, T> g) {
        return obj -> g.apply((SearchDataTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchDataTablesRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance to search within.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance to search within.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of data tables to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of data tables to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Optional filters to apply to the search results, such as tag-based filtering for attribute-based access
         * control.
         * </p>
         * 
         * @param searchFilter
         *        Optional filters to apply to the search results, such as tag-based filtering for attribute-based
         *        access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchFilter(DataTableSearchFilter searchFilter);

        /**
         * <p>
         * Optional filters to apply to the search results, such as tag-based filtering for attribute-based access
         * control.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableSearchFilter.Builder} avoiding
         * the need to create one manually via {@link DataTableSearchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableSearchFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #searchFilter(DataTableSearchFilter)}.
         * 
         * @param searchFilter
         *        a consumer that will call methods on {@link DataTableSearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchFilter(DataTableSearchFilter)
         */
        default Builder searchFilter(Consumer<DataTableSearchFilter.Builder> searchFilter) {
            return searchFilter(DataTableSearchFilter.builder().applyMutation(searchFilter).build());
        }

        /**
         * <p>
         * Search criteria including string conditions for matching table names, descriptions, or resource IDs. Supports
         * STARTS_WITH, CONTAINS, and EXACT comparison types.
         * </p>
         * 
         * @param searchCriteria
         *        Search criteria including string conditions for matching table names, descriptions, or resource IDs.
         *        Supports STARTS_WITH, CONTAINS, and EXACT comparison types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCriteria(DataTableSearchCriteria searchCriteria);

        /**
         * <p>
         * Search criteria including string conditions for matching table names, descriptions, or resource IDs. Supports
         * STARTS_WITH, CONTAINS, and EXACT comparison types.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableSearchCriteria.Builder} avoiding
         * the need to create one manually via {@link DataTableSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableSearchCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #searchCriteria(DataTableSearchCriteria)}.
         * 
         * @param searchCriteria
         *        a consumer that will call methods on {@link DataTableSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchCriteria(DataTableSearchCriteria)
         */
        default Builder searchCriteria(Consumer<DataTableSearchCriteria.Builder> searchCriteria) {
            return searchCriteria(DataTableSearchCriteria.builder().applyMutation(searchCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String nextToken;

        private Integer maxResults;

        private DataTableSearchFilter searchFilter;

        private DataTableSearchCriteria searchCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchDataTablesRequest model) {
            super(model);
            instanceId(model.instanceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            searchFilter(model.searchFilter);
            searchCriteria(model.searchCriteria);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final DataTableSearchFilter.Builder getSearchFilter() {
            return searchFilter != null ? searchFilter.toBuilder() : null;
        }

        public final void setSearchFilter(DataTableSearchFilter.BuilderImpl searchFilter) {
            this.searchFilter = searchFilter != null ? searchFilter.build() : null;
        }

        @Override
        public final Builder searchFilter(DataTableSearchFilter searchFilter) {
            this.searchFilter = searchFilter;
            return this;
        }

        public final DataTableSearchCriteria.Builder getSearchCriteria() {
            return searchCriteria != null ? searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(DataTableSearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(DataTableSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchDataTablesRequest build() {
            return new SearchDataTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
