/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of <code>ActionTypes</code> associated with a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleSummary implements SdkPojo, Serializable, ToCopyableBuilder<RuleSummary.Builder, RuleSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RuleSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RuleId")
            .getter(getter(RuleSummary::ruleId)).setter(setter(Builder::ruleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()).build();

    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(RuleSummary::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<String> EVENT_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceName").getter(getter(RuleSummary::eventSourceNameAsString))
            .setter(setter(Builder::eventSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceName").build()).build();

    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishStatus").getter(getter(RuleSummary::publishStatusAsString))
            .setter(setter(Builder::publishStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishStatus").build()).build();

    private static final SdkField<List<ActionSummary>> ACTION_SUMMARIES_FIELD = SdkField
            .<List<ActionSummary>> builder(MarshallingType.LIST)
            .memberName("ActionSummaries")
            .getter(getter(RuleSummary::actionSummaries))
            .setter(setter(Builder::actionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(RuleSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(RuleSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RULE_ID_FIELD,
            RULE_ARN_FIELD, EVENT_SOURCE_NAME_FIELD, PUBLISH_STATUS_FIELD, ACTION_SUMMARIES_FIELD, CREATED_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String ruleId;

    private final String ruleArn;

    private final String eventSourceName;

    private final String publishStatus;

    private final List<ActionSummary> actionSummaries;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private RuleSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.ruleId = builder.ruleId;
        this.ruleArn = builder.ruleArn;
        this.eventSourceName = builder.eventSourceName;
        this.publishStatus = builder.publishStatus;
        this.actionSummaries = builder.actionSummaries;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique identifier for the rule.
     * </p>
     * 
     * @return A unique identifier for the rule.
     */
    public final String ruleId() {
        return ruleId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The name of the event source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSourceName}
     * will return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventSourceNameAsString}.
     * </p>
     * 
     * @return The name of the event source.
     * @see EventSourceName
     */
    public final EventSourceName eventSourceName() {
        return EventSourceName.fromValue(eventSourceName);
    }

    /**
     * <p>
     * The name of the event source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSourceName}
     * will return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventSourceNameAsString}.
     * </p>
     * 
     * @return The name of the event source.
     * @see EventSourceName
     */
    public final String eventSourceNameAsString() {
        return eventSourceName;
    }

    /**
     * <p>
     * The publish status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishStatus}
     * will return {@link RulePublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publishStatusAsString}.
     * </p>
     * 
     * @return The publish status of the rule.
     * @see RulePublishStatus
     */
    public final RulePublishStatus publishStatus() {
        return RulePublishStatus.fromValue(publishStatus);
    }

    /**
     * <p>
     * The publish status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #publishStatus}
     * will return {@link RulePublishStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #publishStatusAsString}.
     * </p>
     * 
     * @return The publish status of the rule.
     * @see RulePublishStatus
     */
    public final String publishStatusAsString() {
        return publishStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionSummaries() {
        return actionSummaries != null && !(actionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ActionTypes associated with a rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionSummaries} method.
     * </p>
     * 
     * @return A list of ActionTypes associated with a rule.
     */
    public final List<ActionSummary> actionSummaries() {
        return actionSummaries;
    }

    /**
     * <p>
     * The timestamp for when the rule was created.
     * </p>
     * 
     * @return The timestamp for when the rule was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp for when the rule was last updated.
     * </p>
     * 
     * @return The timestamp for when the rule was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionSummaries() ? actionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleSummary)) {
            return false;
        }
        RuleSummary other = (RuleSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ruleId(), other.ruleId())
                && Objects.equals(ruleArn(), other.ruleArn())
                && Objects.equals(eventSourceNameAsString(), other.eventSourceNameAsString())
                && Objects.equals(publishStatusAsString(), other.publishStatusAsString())
                && hasActionSummaries() == other.hasActionSummaries()
                && Objects.equals(actionSummaries(), other.actionSummaries())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleSummary").add("Name", name()).add("RuleId", ruleId()).add("RuleArn", ruleArn())
                .add("EventSourceName", eventSourceNameAsString()).add("PublishStatus", publishStatusAsString())
                .add("ActionSummaries", hasActionSummaries() ? actionSummaries() : null).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleId":
            return Optional.ofNullable(clazz.cast(ruleId()));
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "EventSourceName":
            return Optional.ofNullable(clazz.cast(eventSourceNameAsString()));
        case "PublishStatus":
            return Optional.ofNullable(clazz.cast(publishStatusAsString()));
        case "ActionSummaries":
            return Optional.ofNullable(clazz.cast(actionSummaries()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("EventSourceName", EVENT_SOURCE_NAME_FIELD);
        map.put("PublishStatus", PUBLISH_STATUS_FIELD);
        map.put("ActionSummaries", ACTION_SUMMARIES_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleSummary, T> g) {
        return obj -> g.apply((RuleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleSummary> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique identifier for the rule.
         * </p>
         * 
         * @param ruleId
         *        A unique identifier for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleId(String ruleId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The name of the event source.
         * </p>
         * 
         * @param eventSourceName
         *        The name of the event source.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSourceName(String eventSourceName);

        /**
         * <p>
         * The name of the event source.
         * </p>
         * 
         * @param eventSourceName
         *        The name of the event source.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSourceName(EventSourceName eventSourceName);

        /**
         * <p>
         * The publish status of the rule.
         * </p>
         * 
         * @param publishStatus
         *        The publish status of the rule.
         * @see RulePublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RulePublishStatus
         */
        Builder publishStatus(String publishStatus);

        /**
         * <p>
         * The publish status of the rule.
         * </p>
         * 
         * @param publishStatus
         *        The publish status of the rule.
         * @see RulePublishStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RulePublishStatus
         */
        Builder publishStatus(RulePublishStatus publishStatus);

        /**
         * <p>
         * A list of ActionTypes associated with a rule.
         * </p>
         * 
         * @param actionSummaries
         *        A list of ActionTypes associated with a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionSummaries(Collection<ActionSummary> actionSummaries);

        /**
         * <p>
         * A list of ActionTypes associated with a rule.
         * </p>
         * 
         * @param actionSummaries
         *        A list of ActionTypes associated with a rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionSummaries(ActionSummary... actionSummaries);

        /**
         * <p>
         * A list of ActionTypes associated with a rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ActionSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.ActionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ActionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #actionSummaries(List<ActionSummary>)}.
         * 
         * @param actionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ActionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionSummaries(java.util.Collection<ActionSummary>)
         */
        Builder actionSummaries(Consumer<ActionSummary.Builder>... actionSummaries);

        /**
         * <p>
         * The timestamp for when the rule was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp for when the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp for when the rule was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp for when the rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String ruleId;

        private String ruleArn;

        private String eventSourceName;

        private String publishStatus;

        private List<ActionSummary> actionSummaries = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleSummary model) {
            name(model.name);
            ruleId(model.ruleId);
            ruleArn(model.ruleArn);
            eventSourceName(model.eventSourceName);
            publishStatus(model.publishStatus);
            actionSummaries(model.actionSummaries);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleId() {
            return ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getEventSourceName() {
            return eventSourceName;
        }

        public final void setEventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
        }

        @Override
        public final Builder eventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        @Override
        public final Builder eventSourceName(EventSourceName eventSourceName) {
            this.eventSourceName(eventSourceName == null ? null : eventSourceName.toString());
            return this;
        }

        public final String getPublishStatus() {
            return publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(RulePublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final List<ActionSummary.Builder> getActionSummaries() {
            List<ActionSummary.Builder> result = ActionSummariesCopier.copyToBuilder(this.actionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionSummaries(Collection<ActionSummary.BuilderImpl> actionSummaries) {
            this.actionSummaries = ActionSummariesCopier.copyFromBuilder(actionSummaries);
        }

        @Override
        public final Builder actionSummaries(Collection<ActionSummary> actionSummaries) {
            this.actionSummaries = ActionSummariesCopier.copy(actionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionSummaries(ActionSummary... actionSummaries) {
            actionSummaries(Arrays.asList(actionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionSummaries(Consumer<ActionSummary.Builder>... actionSummaries) {
            actionSummaries(Stream.of(actionSummaries).map(c -> ActionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public RuleSummary build() {
            return new RuleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
