/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a voice recording, chat transcript, or screen recording.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordingInfo implements SdkPojo, Serializable, ToCopyableBuilder<RecordingInfo.Builder, RecordingInfo> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(RecordingInfo::storageTypeAsString)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(RecordingInfo::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> MEDIA_STREAM_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaStreamType").getter(getter(RecordingInfo::mediaStreamTypeAsString))
            .setter(setter(Builder::mediaStreamType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStreamType").build()).build();

    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantType").getter(getter(RecordingInfo::participantTypeAsString))
            .setter(setter(Builder::participantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()).build();

    private static final SdkField<String> FRAGMENT_START_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FragmentStartNumber").getter(getter(RecordingInfo::fragmentStartNumber))
            .setter(setter(Builder::fragmentStartNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentStartNumber").build())
            .build();

    private static final SdkField<String> FRAGMENT_STOP_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FragmentStopNumber").getter(getter(RecordingInfo::fragmentStopNumber))
            .setter(setter(Builder::fragmentStopNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentStopNumber").build())
            .build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(RecordingInfo::startTimestamp)).setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> STOP_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopTimestamp").getter(getter(RecordingInfo::stopTimestamp)).setter(setter(Builder::stopTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RecordingInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DELETION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeletionReason").getter(getter(RecordingInfo::deletionReason)).setter(setter(Builder::deletionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionReason").build()).build();

    private static final SdkField<String> UNPROCESSED_TRANSCRIPT_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UnprocessedTranscriptLocation")
            .getter(getter(RecordingInfo::unprocessedTranscriptLocation))
            .setter(setter(Builder::unprocessedTranscriptLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTranscriptLocation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD,
            LOCATION_FIELD, MEDIA_STREAM_TYPE_FIELD, PARTICIPANT_TYPE_FIELD, FRAGMENT_START_NUMBER_FIELD,
            FRAGMENT_STOP_NUMBER_FIELD, START_TIMESTAMP_FIELD, STOP_TIMESTAMP_FIELD, STATUS_FIELD, DELETION_REASON_FIELD,
            UNPROCESSED_TRANSCRIPT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String storageType;

    private final String location;

    private final String mediaStreamType;

    private final String participantType;

    private final String fragmentStartNumber;

    private final String fragmentStopNumber;

    private final Instant startTimestamp;

    private final Instant stopTimestamp;

    private final String status;

    private final String deletionReason;

    private final String unprocessedTranscriptLocation;

    private RecordingInfo(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.location = builder.location;
        this.mediaStreamType = builder.mediaStreamType;
        this.participantType = builder.participantType;
        this.fragmentStartNumber = builder.fragmentStartNumber;
        this.fragmentStopNumber = builder.fragmentStopNumber;
        this.startTimestamp = builder.startTimestamp;
        this.stopTimestamp = builder.stopTimestamp;
        this.status = builder.status;
        this.deletionReason = builder.deletionReason;
        this.unprocessedTranscriptLocation = builder.unprocessedTranscriptLocation;
    }

    /**
     * <p>
     * Where the recording/transcript is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return Where the recording/transcript is stored.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * Where the recording/transcript is stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return Where the recording/transcript is stored.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The location, in Amazon S3, for the recording/transcript.
     * </p>
     * 
     * @return The location, in Amazon S3, for the recording/transcript.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * Information about the media stream used during the conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return Information about the media stream used during the conversation.
     * @see MediaStreamType
     */
    public final MediaStreamType mediaStreamType() {
        return MediaStreamType.fromValue(mediaStreamType);
    }

    /**
     * <p>
     * Information about the media stream used during the conversation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaStreamType}
     * will return {@link MediaStreamType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mediaStreamTypeAsString}.
     * </p>
     * 
     * @return Information about the media stream used during the conversation.
     * @see MediaStreamType
     */
    public final String mediaStreamTypeAsString() {
        return mediaStreamType;
    }

    /**
     * <p>
     * Information about the conversation participant, whether they are an agent or contact. The participant types are
     * as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All
     * </p>
     * </li>
     * <li>
     * <p>
     * Manager
     * </p>
     * </li>
     * <li>
     * <p>
     * Agent
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer
     * </p>
     * </li>
     * <li>
     * <p>
     * Thirdparty
     * </p>
     * </li>
     * <li>
     * <p>
     * Supervisor
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Information about the conversation participant, whether they are an agent or contact. The participant
     *         types are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         All
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Manager
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Agent
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Thirdparty
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Supervisor
     *         </p>
     *         </li>
     * @see ParticipantType
     */
    public final ParticipantType participantType() {
        return ParticipantType.fromValue(participantType);
    }

    /**
     * <p>
     * Information about the conversation participant, whether they are an agent or contact. The participant types are
     * as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All
     * </p>
     * </li>
     * <li>
     * <p>
     * Manager
     * </p>
     * </li>
     * <li>
     * <p>
     * Agent
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer
     * </p>
     * </li>
     * <li>
     * <p>
     * Thirdparty
     * </p>
     * </li>
     * <li>
     * <p>
     * Supervisor
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Information about the conversation participant, whether they are an agent or contact. The participant
     *         types are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         All
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Manager
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Agent
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Thirdparty
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Supervisor
     *         </p>
     *         </li>
     * @see ParticipantType
     */
    public final String participantTypeAsString() {
        return participantType;
    }

    /**
     * <p>
     * The number that identifies the Kinesis Video Streams fragment where the customer audio stream started.
     * </p>
     * 
     * @return The number that identifies the Kinesis Video Streams fragment where the customer audio stream started.
     */
    public final String fragmentStartNumber() {
        return fragmentStartNumber;
    }

    /**
     * <p>
     * The number that identifies the Kinesis Video Streams fragment where the customer audio stream stopped.
     * </p>
     * 
     * @return The number that identifies the Kinesis Video Streams fragment where the customer audio stream stopped.
     */
    public final String fragmentStopNumber() {
        return fragmentStopNumber;
    }

    /**
     * <p>
     * When the conversation of the last leg of the recording started in UTC time.
     * </p>
     * 
     * @return When the conversation of the last leg of the recording started in UTC time.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * When the conversation of the last leg of recording stopped in UTC time.
     * </p>
     * 
     * @return When the conversation of the last leg of recording stopped in UTC time.
     */
    public final Instant stopTimestamp() {
        return stopTimestamp;
    }

    /**
     * <p>
     * The status of the recording/transcript.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecordingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the recording/transcript.
     * @see RecordingStatus
     */
    public final RecordingStatus status() {
        return RecordingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the recording/transcript.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecordingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the recording/transcript.
     * @see RecordingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the recording/transcript was deleted, this is the reason entered for the deletion.
     * </p>
     * 
     * @return If the recording/transcript was deleted, this is the reason entered for the deletion.
     */
    public final String deletionReason() {
        return deletionReason;
    }

    /**
     * <p>
     * The location, in Amazon S3, for the unprocessed transcript if any media processing was performed.
     * </p>
     * 
     * @return The location, in Amazon S3, for the unprocessed transcript if any media processing was performed.
     */
    public final String unprocessedTranscriptLocation() {
        return unprocessedTranscriptLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(mediaStreamTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentStartNumber());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentStopNumber());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(stopTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deletionReason());
        hashCode = 31 * hashCode + Objects.hashCode(unprocessedTranscriptLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingInfo)) {
            return false;
        }
        RecordingInfo other = (RecordingInfo) obj;
        return Objects.equals(storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(location(), other.location())
                && Objects.equals(mediaStreamTypeAsString(), other.mediaStreamTypeAsString())
                && Objects.equals(participantTypeAsString(), other.participantTypeAsString())
                && Objects.equals(fragmentStartNumber(), other.fragmentStartNumber())
                && Objects.equals(fragmentStopNumber(), other.fragmentStopNumber())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(stopTimestamp(), other.stopTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(deletionReason(), other.deletionReason())
                && Objects.equals(unprocessedTranscriptLocation(), other.unprocessedTranscriptLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordingInfo").add("StorageType", storageTypeAsString()).add("Location", location())
                .add("MediaStreamType", mediaStreamTypeAsString()).add("ParticipantType", participantTypeAsString())
                .add("FragmentStartNumber", fragmentStartNumber()).add("FragmentStopNumber", fragmentStopNumber())
                .add("StartTimestamp", startTimestamp()).add("StopTimestamp", stopTimestamp()).add("Status", statusAsString())
                .add("DeletionReason", deletionReason()).add("UnprocessedTranscriptLocation", unprocessedTranscriptLocation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "MediaStreamType":
            return Optional.ofNullable(clazz.cast(mediaStreamTypeAsString()));
        case "ParticipantType":
            return Optional.ofNullable(clazz.cast(participantTypeAsString()));
        case "FragmentStartNumber":
            return Optional.ofNullable(clazz.cast(fragmentStartNumber()));
        case "FragmentStopNumber":
            return Optional.ofNullable(clazz.cast(fragmentStopNumber()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "StopTimestamp":
            return Optional.ofNullable(clazz.cast(stopTimestamp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DeletionReason":
            return Optional.ofNullable(clazz.cast(deletionReason()));
        case "UnprocessedTranscriptLocation":
            return Optional.ofNullable(clazz.cast(unprocessedTranscriptLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("MediaStreamType", MEDIA_STREAM_TYPE_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("FragmentStartNumber", FRAGMENT_START_NUMBER_FIELD);
        map.put("FragmentStopNumber", FRAGMENT_STOP_NUMBER_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("StopTimestamp", STOP_TIMESTAMP_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DeletionReason", DELETION_REASON_FIELD);
        map.put("UnprocessedTranscriptLocation", UNPROCESSED_TRANSCRIPT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordingInfo, T> g) {
        return obj -> g.apply((RecordingInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordingInfo> {
        /**
         * <p>
         * Where the recording/transcript is stored.
         * </p>
         * 
         * @param storageType
         *        Where the recording/transcript is stored.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * Where the recording/transcript is stored.
         * </p>
         * 
         * @param storageType
         *        Where the recording/transcript is stored.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The location, in Amazon S3, for the recording/transcript.
         * </p>
         * 
         * @param location
         *        The location, in Amazon S3, for the recording/transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * Information about the media stream used during the conversation.
         * </p>
         * 
         * @param mediaStreamType
         *        Information about the media stream used during the conversation.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(String mediaStreamType);

        /**
         * <p>
         * Information about the media stream used during the conversation.
         * </p>
         * 
         * @param mediaStreamType
         *        Information about the media stream used during the conversation.
         * @see MediaStreamType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaStreamType
         */
        Builder mediaStreamType(MediaStreamType mediaStreamType);

        /**
         * <p>
         * Information about the conversation participant, whether they are an agent or contact. The participant types
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All
         * </p>
         * </li>
         * <li>
         * <p>
         * Manager
         * </p>
         * </li>
         * <li>
         * <p>
         * Agent
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer
         * </p>
         * </li>
         * <li>
         * <p>
         * Thirdparty
         * </p>
         * </li>
         * <li>
         * <p>
         * Supervisor
         * </p>
         * </li>
         * </ul>
         * 
         * @param participantType
         *        Information about the conversation participant, whether they are an agent or contact. The participant
         *        types are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        All
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Manager
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Agent
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Thirdparty
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Supervisor
         *        </p>
         *        </li>
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(String participantType);

        /**
         * <p>
         * Information about the conversation participant, whether they are an agent or contact. The participant types
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All
         * </p>
         * </li>
         * <li>
         * <p>
         * Manager
         * </p>
         * </li>
         * <li>
         * <p>
         * Agent
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer
         * </p>
         * </li>
         * <li>
         * <p>
         * Thirdparty
         * </p>
         * </li>
         * <li>
         * <p>
         * Supervisor
         * </p>
         * </li>
         * </ul>
         * 
         * @param participantType
         *        Information about the conversation participant, whether they are an agent or contact. The participant
         *        types are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        All
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Manager
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Agent
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Thirdparty
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Supervisor
         *        </p>
         *        </li>
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(ParticipantType participantType);

        /**
         * <p>
         * The number that identifies the Kinesis Video Streams fragment where the customer audio stream started.
         * </p>
         * 
         * @param fragmentStartNumber
         *        The number that identifies the Kinesis Video Streams fragment where the customer audio stream started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentStartNumber(String fragmentStartNumber);

        /**
         * <p>
         * The number that identifies the Kinesis Video Streams fragment where the customer audio stream stopped.
         * </p>
         * 
         * @param fragmentStopNumber
         *        The number that identifies the Kinesis Video Streams fragment where the customer audio stream stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentStopNumber(String fragmentStopNumber);

        /**
         * <p>
         * When the conversation of the last leg of the recording started in UTC time.
         * </p>
         * 
         * @param startTimestamp
         *        When the conversation of the last leg of the recording started in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * When the conversation of the last leg of recording stopped in UTC time.
         * </p>
         * 
         * @param stopTimestamp
         *        When the conversation of the last leg of recording stopped in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTimestamp(Instant stopTimestamp);

        /**
         * <p>
         * The status of the recording/transcript.
         * </p>
         * 
         * @param status
         *        The status of the recording/transcript.
         * @see RecordingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the recording/transcript.
         * </p>
         * 
         * @param status
         *        The status of the recording/transcript.
         * @see RecordingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordingStatus
         */
        Builder status(RecordingStatus status);

        /**
         * <p>
         * If the recording/transcript was deleted, this is the reason entered for the deletion.
         * </p>
         * 
         * @param deletionReason
         *        If the recording/transcript was deleted, this is the reason entered for the deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionReason(String deletionReason);

        /**
         * <p>
         * The location, in Amazon S3, for the unprocessed transcript if any media processing was performed.
         * </p>
         * 
         * @param unprocessedTranscriptLocation
         *        The location, in Amazon S3, for the unprocessed transcript if any media processing was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedTranscriptLocation(String unprocessedTranscriptLocation);
    }

    static final class BuilderImpl implements Builder {
        private String storageType;

        private String location;

        private String mediaStreamType;

        private String participantType;

        private String fragmentStartNumber;

        private String fragmentStopNumber;

        private Instant startTimestamp;

        private Instant stopTimestamp;

        private String status;

        private String deletionReason;

        private String unprocessedTranscriptLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingInfo model) {
            storageType(model.storageType);
            location(model.location);
            mediaStreamType(model.mediaStreamType);
            participantType(model.participantType);
            fragmentStartNumber(model.fragmentStartNumber);
            fragmentStopNumber(model.fragmentStopNumber);
            startTimestamp(model.startTimestamp);
            stopTimestamp(model.stopTimestamp);
            status(model.status);
            deletionReason(model.deletionReason);
            unprocessedTranscriptLocation(model.unprocessedTranscriptLocation);
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getMediaStreamType() {
            return mediaStreamType;
        }

        public final void setMediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
        }

        @Override
        public final Builder mediaStreamType(String mediaStreamType) {
            this.mediaStreamType = mediaStreamType;
            return this;
        }

        @Override
        public final Builder mediaStreamType(MediaStreamType mediaStreamType) {
            this.mediaStreamType(mediaStreamType == null ? null : mediaStreamType.toString());
            return this;
        }

        public final String getParticipantType() {
            return participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final String getFragmentStartNumber() {
            return fragmentStartNumber;
        }

        public final void setFragmentStartNumber(String fragmentStartNumber) {
            this.fragmentStartNumber = fragmentStartNumber;
        }

        @Override
        public final Builder fragmentStartNumber(String fragmentStartNumber) {
            this.fragmentStartNumber = fragmentStartNumber;
            return this;
        }

        public final String getFragmentStopNumber() {
            return fragmentStopNumber;
        }

        public final void setFragmentStopNumber(String fragmentStopNumber) {
            this.fragmentStopNumber = fragmentStopNumber;
        }

        @Override
        public final Builder fragmentStopNumber(String fragmentStopNumber) {
            this.fragmentStopNumber = fragmentStopNumber;
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getStopTimestamp() {
            return stopTimestamp;
        }

        public final void setStopTimestamp(Instant stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
        }

        @Override
        public final Builder stopTimestamp(Instant stopTimestamp) {
            this.stopTimestamp = stopTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecordingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDeletionReason() {
            return deletionReason;
        }

        public final void setDeletionReason(String deletionReason) {
            this.deletionReason = deletionReason;
        }

        @Override
        public final Builder deletionReason(String deletionReason) {
            this.deletionReason = deletionReason;
            return this;
        }

        public final String getUnprocessedTranscriptLocation() {
            return unprocessedTranscriptLocation;
        }

        public final void setUnprocessedTranscriptLocation(String unprocessedTranscriptLocation) {
            this.unprocessedTranscriptLocation = unprocessedTranscriptLocation;
        }

        @Override
        public final Builder unprocessedTranscriptLocation(String unprocessedTranscriptLocation) {
            this.unprocessedTranscriptLocation = unprocessedTranscriptLocation;
            return this;
        }

        @Override
        public RecordingInfo build() {
            return new RecordingInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
