/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A record primary value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordPrimaryValue implements SdkPojo, Serializable,
        ToCopyableBuilder<RecordPrimaryValue.Builder, RecordPrimaryValue> {
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordId").getter(getter(RecordPrimaryValue::recordId)).setter(setter(Builder::recordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()).build();

    private static final SdkField<List<PrimaryValueResponse>> PRIMARY_VALUES_FIELD = SdkField
            .<List<PrimaryValueResponse>> builder(MarshallingType.LIST)
            .memberName("PrimaryValues")
            .getter(getter(RecordPrimaryValue::primaryValues))
            .setter(setter(Builder::primaryValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrimaryValueResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrimaryValueResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(RecordPrimaryValue::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(RecordPrimaryValue::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ID_FIELD,
            PRIMARY_VALUES_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String recordId;

    private final List<PrimaryValueResponse> primaryValues;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private RecordPrimaryValue(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.primaryValues = builder.primaryValues;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The value's record ID.
     * </p>
     * 
     * @return The value's record ID.
     */
    public final String recordId() {
        return recordId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryValues() {
        return primaryValues != null && !(primaryValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value's primary values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryValues} method.
     * </p>
     * 
     * @return The value's primary values.
     */
    public final List<PrimaryValueResponse> primaryValues() {
        return primaryValues;
    }

    /**
     * <p>
     * The value's last modified time.
     * </p>
     * 
     * @return The value's last modified time.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The value's last modified region.
     * </p>
     * 
     * @return The value's last modified region.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryValues() ? primaryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordPrimaryValue)) {
            return false;
        }
        RecordPrimaryValue other = (RecordPrimaryValue) obj;
        return Objects.equals(recordId(), other.recordId()) && hasPrimaryValues() == other.hasPrimaryValues()
                && Objects.equals(primaryValues(), other.primaryValues())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordPrimaryValue").add("RecordId", recordId())
                .add("PrimaryValues", hasPrimaryValues() ? primaryValues() : null).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordId":
            return Optional.ofNullable(clazz.cast(recordId()));
        case "PrimaryValues":
            return Optional.ofNullable(clazz.cast(primaryValues()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("PrimaryValues", PRIMARY_VALUES_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordPrimaryValue, T> g) {
        return obj -> g.apply((RecordPrimaryValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordPrimaryValue> {
        /**
         * <p>
         * The value's record ID.
         * </p>
         * 
         * @param recordId
         *        The value's record ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * The value's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The value's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(Collection<PrimaryValueResponse> primaryValues);

        /**
         * <p>
         * The value's primary values.
         * </p>
         * 
         * @param primaryValues
         *        The value's primary values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryValues(PrimaryValueResponse... primaryValues);

        /**
         * <p>
         * The value's primary values.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse.Builder#build()} is called
         * immediately and its result is passed to {@link #primaryValues(List<PrimaryValueResponse>)}.
         * 
         * @param primaryValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PrimaryValueResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryValues(java.util.Collection<PrimaryValueResponse>)
         */
        Builder primaryValues(Consumer<PrimaryValueResponse.Builder>... primaryValues);

        /**
         * <p>
         * The value's last modified time.
         * </p>
         * 
         * @param lastModifiedTime
         *        The value's last modified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The value's last modified region.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The value's last modified region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String recordId;

        private List<PrimaryValueResponse> primaryValues = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordPrimaryValue model) {
            recordId(model.recordId);
            primaryValues(model.primaryValues);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getRecordId() {
            return recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final List<PrimaryValueResponse.Builder> getPrimaryValues() {
            List<PrimaryValueResponse.Builder> result = PrimaryValuesResponseSetCopier.copyToBuilder(this.primaryValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrimaryValues(Collection<PrimaryValueResponse.BuilderImpl> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copyFromBuilder(primaryValues);
        }

        @Override
        public final Builder primaryValues(Collection<PrimaryValueResponse> primaryValues) {
            this.primaryValues = PrimaryValuesResponseSetCopier.copy(primaryValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(PrimaryValueResponse... primaryValues) {
            primaryValues(Arrays.asList(primaryValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryValues(Consumer<PrimaryValueResponse.Builder>... primaryValues) {
            primaryValues(Stream.of(primaryValues).map(c -> PrimaryValueResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public RecordPrimaryValue build() {
            return new RecordPrimaryValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
