/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The credentials used by the participant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipantTokenCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipantTokenCredentials.Builder, ParticipantTokenCredentials> {
    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantToken").getter(getter(ParticipantTokenCredentials::participantToken))
            .setter(setter(Builder::participantToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantToken").build()).build();

    private static final SdkField<String> EXPIRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Expiry")
            .getter(getter(ParticipantTokenCredentials::expiry)).setter(setter(Builder::expiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_TOKEN_FIELD,
            EXPIRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String participantToken;

    private final String expiry;

    private ParticipantTokenCredentials(BuilderImpl builder) {
        this.participantToken = builder.participantToken;
        this.expiry = builder.expiry;
    }

    /**
     * <p>
     * The token used by the chat participant to call <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
     * </p>
     * 
     * @return The token used by the chat participant to call <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     *         >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
     */
    public final String participantToken() {
        return participantToken;
    }

    /**
     * <p>
     * The expiration of the token. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
     * 2019-11-08T02:41:28.172Z.
     * </p>
     * 
     * @return The expiration of the token. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
     *         2019-11-08T02:41:28.172Z.
     */
    public final String expiry() {
        return expiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(participantToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantTokenCredentials)) {
            return false;
        }
        ParticipantTokenCredentials other = (ParticipantTokenCredentials) obj;
        return Objects.equals(participantToken(), other.participantToken()) && Objects.equals(expiry(), other.expiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipantTokenCredentials").add("ParticipantToken", participantToken())
                .add("Expiry", expiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParticipantToken":
            return Optional.ofNullable(clazz.cast(participantToken()));
        case "Expiry":
            return Optional.ofNullable(clazz.cast(expiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParticipantToken", PARTICIPANT_TOKEN_FIELD);
        map.put("Expiry", EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantTokenCredentials, T> g) {
        return obj -> g.apply((ParticipantTokenCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipantTokenCredentials> {
        /**
         * <p>
         * The token used by the chat participant to call <a href=
         * "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         * >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
         * </p>
         * 
         * @param participantToken
         *        The token used by the chat participant to call <a href=
         *        "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         *        >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat
         *        participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantToken(String participantToken);

        /**
         * <p>
         * The expiration of the token. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
         * 2019-11-08T02:41:28.172Z.
         * </p>
         * 
         * @param expiry
         *        The expiration of the token. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
         *        2019-11-08T02:41:28.172Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiry(String expiry);
    }

    static final class BuilderImpl implements Builder {
        private String participantToken;

        private String expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantTokenCredentials model) {
            participantToken(model.participantToken);
            expiry(model.expiry);
        }

        public final String getParticipantToken() {
            return participantToken;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        public final String getExpiry() {
            return expiry;
        }

        public final void setExpiry(String expiry) {
            this.expiry = expiry;
        }

        @Override
        public final Builder expiry(String expiry) {
            this.expiry = expiry;
            return this;
        }

        @Override
        public ParticipantTokenCredentials build() {
            return new ParticipantTokenCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
