/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the outbound strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundStrategy implements SdkPojo, Serializable,
        ToCopyableBuilder<OutboundStrategy.Builder, OutboundStrategy> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(OutboundStrategy::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<OutboundStrategyConfig> CONFIG_FIELD = SdkField
            .<OutboundStrategyConfig> builder(MarshallingType.SDK_POJO).memberName("Config")
            .getter(getter(OutboundStrategy::config)).setter(setter(Builder::config))
            .constructor(OutboundStrategyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final OutboundStrategyConfig config;

    private OutboundStrategy(BuilderImpl builder) {
        this.type = builder.type;
        this.config = builder.config;
    }

    /**
     * <p>
     * Type of the outbound strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OutboundStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the outbound strategy.
     * @see OutboundStrategyType
     */
    public final OutboundStrategyType type() {
        return OutboundStrategyType.fromValue(type);
    }

    /**
     * <p>
     * Type of the outbound strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OutboundStrategyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the outbound strategy.
     * @see OutboundStrategyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Config of the outbound strategy.
     * </p>
     * 
     * @return Config of the outbound strategy.
     */
    public final OutboundStrategyConfig config() {
        return config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundStrategy)) {
            return false;
        }
        OutboundStrategy other = (OutboundStrategy) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(config(), other.config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutboundStrategy").add("Type", typeAsString()).add("Config", config()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Config", CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundStrategy, T> g) {
        return obj -> g.apply((OutboundStrategy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundStrategy> {
        /**
         * <p>
         * Type of the outbound strategy.
         * </p>
         * 
         * @param type
         *        Type of the outbound strategy.
         * @see OutboundStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutboundStrategyType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the outbound strategy.
         * </p>
         * 
         * @param type
         *        Type of the outbound strategy.
         * @see OutboundStrategyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutboundStrategyType
         */
        Builder type(OutboundStrategyType type);

        /**
         * <p>
         * Config of the outbound strategy.
         * </p>
         * 
         * @param config
         *        Config of the outbound strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(OutboundStrategyConfig config);

        /**
         * <p>
         * Config of the outbound strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundStrategyConfig.Builder} avoiding
         * the need to create one manually via {@link OutboundStrategyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundStrategyConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #config(OutboundStrategyConfig)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link OutboundStrategyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(OutboundStrategyConfig)
         */
        default Builder config(Consumer<OutboundStrategyConfig.Builder> config) {
            return config(OutboundStrategyConfig.builder().applyMutation(config).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private OutboundStrategyConfig config;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundStrategy model) {
            type(model.type);
            config(model.config);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OutboundStrategyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final OutboundStrategyConfig.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(OutboundStrategyConfig.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(OutboundStrategyConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public OutboundStrategy build() {
            return new OutboundStrategy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
