/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class NextContactsCopier {
    static List<NextContactEntry> copy(Collection<? extends NextContactEntry> nextContactsParam) {
        List<NextContactEntry> list;
        if (nextContactsParam == null || nextContactsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<NextContactEntry> modifiableList = new ArrayList<>(nextContactsParam.size());
            nextContactsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<NextContactEntry> copyFromBuilder(Collection<? extends NextContactEntry.Builder> nextContactsParam) {
        List<NextContactEntry> list;
        if (nextContactsParam == null || nextContactsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<NextContactEntry> modifiableList = new ArrayList<>(nextContactsParam.size());
            nextContactsParam.forEach(entry -> {
                NextContactEntry member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<NextContactEntry.Builder> copyToBuilder(Collection<? extends NextContactEntry> nextContactsParam) {
        List<NextContactEntry.Builder> list;
        if (nextContactsParam == null || nextContactsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<NextContactEntry.Builder> modifiableList = new ArrayList<>(nextContactsParam.size());
            nextContactsParam.forEach(entry -> {
                NextContactEntry.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
