/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkspaceMediaResponse extends ConnectResponse implements
        ToCopyableBuilder<ListWorkspaceMediaResponse.Builder, ListWorkspaceMediaResponse> {
    private static final SdkField<List<MediaItem>> MEDIA_FIELD = SdkField
            .<List<MediaItem>> builder(MarshallingType.LIST)
            .memberName("Media")
            .getter(getter(ListWorkspaceMediaResponse::media))
            .setter(setter(Builder::media))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Media").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MediaItem> media;

    private ListWorkspaceMediaResponse(BuilderImpl builder) {
        super(builder);
        this.media = builder.media;
    }

    /**
     * For responses, this returns true if the service returned a value for the Media property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasMedia() {
        return media != null && !(media instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of media assets for the workspace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMedia} method.
     * </p>
     * 
     * @return A list of media assets for the workspace.
     */
    public final List<MediaItem> media() {
        return media;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMedia() ? media() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspaceMediaResponse)) {
            return false;
        }
        ListWorkspaceMediaResponse other = (ListWorkspaceMediaResponse) obj;
        return hasMedia() == other.hasMedia() && Objects.equals(media(), other.media());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkspaceMediaResponse").add("Media", hasMedia() ? media() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Media":
            return Optional.ofNullable(clazz.cast(media()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Media", MEDIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspaceMediaResponse, T> g) {
        return obj -> g.apply((ListWorkspaceMediaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkspaceMediaResponse> {
        /**
         * <p>
         * A list of media assets for the workspace.
         * </p>
         * 
         * @param media
         *        A list of media assets for the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(Collection<MediaItem> media);

        /**
         * <p>
         * A list of media assets for the workspace.
         * </p>
         * 
         * @param media
         *        A list of media assets for the workspace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder media(MediaItem... media);

        /**
         * <p>
         * A list of media assets for the workspace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MediaItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.MediaItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MediaItem.Builder#build()} is called immediately and its
         * result is passed to {@link #media(List<MediaItem>)}.
         * 
         * @param media
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MediaItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #media(java.util.Collection<MediaItem>)
         */
        Builder media(Consumer<MediaItem.Builder>... media);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<MediaItem> media = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspaceMediaResponse model) {
            super(model);
            media(model.media);
        }

        public final List<MediaItem.Builder> getMedia() {
            List<MediaItem.Builder> result = MediaListCopier.copyToBuilder(this.media);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMedia(Collection<MediaItem.BuilderImpl> media) {
            this.media = MediaListCopier.copyFromBuilder(media);
        }

        @Override
        public final Builder media(Collection<MediaItem> media) {
            this.media = MediaListCopier.copy(media);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder media(MediaItem... media) {
            media(Arrays.asList(media));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder media(Consumer<MediaItem.Builder>... media) {
            media(Stream.of(media).map(c -> MediaItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkspaceMediaResponse build() {
            return new ListWorkspaceMediaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
