/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListContactFlowModuleAliasesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListContactFlowModuleAliasesResponse.Builder, ListContactFlowModuleAliasesResponse> {
    private static final SdkField<List<ContactFlowModuleAliasSummary>> CONTACT_FLOW_MODULE_ALIAS_SUMMARY_LIST_FIELD = SdkField
            .<List<ContactFlowModuleAliasSummary>> builder(MarshallingType.LIST)
            .memberName("ContactFlowModuleAliasSummaryList")
            .getter(getter(ListContactFlowModuleAliasesResponse::contactFlowModuleAliasSummaryList))
            .setter(setter(Builder::contactFlowModuleAliasSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowModuleAliasSummaryList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactFlowModuleAliasSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactFlowModuleAliasSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListContactFlowModuleAliasesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTACT_FLOW_MODULE_ALIAS_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ContactFlowModuleAliasSummary> contactFlowModuleAliasSummaryList;

    private final String nextToken;

    private ListContactFlowModuleAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlowModuleAliasSummaryList = builder.contactFlowModuleAliasSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactFlowModuleAliasSummaryList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasContactFlowModuleAliasSummaryList() {
        return contactFlowModuleAliasSummaryList != null && !(contactFlowModuleAliasSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the flow module aliases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactFlowModuleAliasSummaryList}
     * method.
     * </p>
     * 
     * @return Information about the flow module aliases.
     */
    public final List<ContactFlowModuleAliasSummary> contactFlowModuleAliasSummaryList() {
        return contactFlowModuleAliasSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasContactFlowModuleAliasSummaryList() ? contactFlowModuleAliasSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactFlowModuleAliasesResponse)) {
            return false;
        }
        ListContactFlowModuleAliasesResponse other = (ListContactFlowModuleAliasesResponse) obj;
        return hasContactFlowModuleAliasSummaryList() == other.hasContactFlowModuleAliasSummaryList()
                && Objects.equals(contactFlowModuleAliasSummaryList(), other.contactFlowModuleAliasSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListContactFlowModuleAliasesResponse")
                .add("ContactFlowModuleAliasSummaryList",
                        hasContactFlowModuleAliasSummaryList() ? contactFlowModuleAliasSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactFlowModuleAliasSummaryList":
            return Optional.ofNullable(clazz.cast(contactFlowModuleAliasSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactFlowModuleAliasSummaryList", CONTACT_FLOW_MODULE_ALIAS_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListContactFlowModuleAliasesResponse, T> g) {
        return obj -> g.apply((ListContactFlowModuleAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListContactFlowModuleAliasesResponse> {
        /**
         * <p>
         * Information about the flow module aliases.
         * </p>
         * 
         * @param contactFlowModuleAliasSummaryList
         *        Information about the flow module aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleAliasSummaryList(Collection<ContactFlowModuleAliasSummary> contactFlowModuleAliasSummaryList);

        /**
         * <p>
         * Information about the flow module aliases.
         * </p>
         * 
         * @param contactFlowModuleAliasSummaryList
         *        Information about the flow module aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleAliasSummaryList(ContactFlowModuleAliasSummary... contactFlowModuleAliasSummaryList);

        /**
         * <p>
         * Information about the flow module aliases.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowModuleAliasSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowModuleAliasSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowModuleAliasSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #contactFlowModuleAliasSummaryList(List<ContactFlowModuleAliasSummary>)}.
         * 
         * @param contactFlowModuleAliasSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ContactFlowModuleAliasSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactFlowModuleAliasSummaryList(java.util.Collection<ContactFlowModuleAliasSummary>)
         */
        Builder contactFlowModuleAliasSummaryList(
                Consumer<ContactFlowModuleAliasSummary.Builder>... contactFlowModuleAliasSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<ContactFlowModuleAliasSummary> contactFlowModuleAliasSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactFlowModuleAliasesResponse model) {
            super(model);
            contactFlowModuleAliasSummaryList(model.contactFlowModuleAliasSummaryList);
            nextToken(model.nextToken);
        }

        public final List<ContactFlowModuleAliasSummary.Builder> getContactFlowModuleAliasSummaryList() {
            List<ContactFlowModuleAliasSummary.Builder> result = ContactFlowModuleAliasSummaryListCopier
                    .copyToBuilder(this.contactFlowModuleAliasSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContactFlowModuleAliasSummaryList(
                Collection<ContactFlowModuleAliasSummary.BuilderImpl> contactFlowModuleAliasSummaryList) {
            this.contactFlowModuleAliasSummaryList = ContactFlowModuleAliasSummaryListCopier
                    .copyFromBuilder(contactFlowModuleAliasSummaryList);
        }

        @Override
        public final Builder contactFlowModuleAliasSummaryList(
                Collection<ContactFlowModuleAliasSummary> contactFlowModuleAliasSummaryList) {
            this.contactFlowModuleAliasSummaryList = ContactFlowModuleAliasSummaryListCopier
                    .copy(contactFlowModuleAliasSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowModuleAliasSummaryList(ContactFlowModuleAliasSummary... contactFlowModuleAliasSummaryList) {
            contactFlowModuleAliasSummaryList(Arrays.asList(contactFlowModuleAliasSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowModuleAliasSummaryList(
                Consumer<ContactFlowModuleAliasSummary.Builder>... contactFlowModuleAliasSummaryList) {
            contactFlowModuleAliasSummaryList(Stream.of(contactFlowModuleAliasSummaryList)
                    .map(c -> ContactFlowModuleAliasSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactFlowModuleAliasesResponse build() {
            return new ListContactFlowModuleAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
