/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The search criteria to be used to return evaluations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationSearchCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationSearchCriteria.Builder, EvaluationSearchCriteria> {
    private static final SdkField<List<EvaluationSearchCriteria>> OR_CONDITIONS_FIELD = SdkField
            .<List<EvaluationSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(EvaluationSearchCriteria::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EvaluationSearchCriteria>> AND_CONDITIONS_FIELD = SdkField
            .<List<EvaluationSearchCriteria>> builder(MarshallingType.LIST)
            .memberName("AndConditions")
            .getter(getter(EvaluationSearchCriteria::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationSearchCriteria> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationSearchCriteria::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField
            .<StringCondition> builder(MarshallingType.SDK_POJO).memberName("StringCondition")
            .getter(getter(EvaluationSearchCriteria::stringCondition)).setter(setter(Builder::stringCondition))
            .constructor(StringCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()).build();

    private static final SdkField<NumberCondition> NUMBER_CONDITION_FIELD = SdkField
            .<NumberCondition> builder(MarshallingType.SDK_POJO).memberName("NumberCondition")
            .getter(getter(EvaluationSearchCriteria::numberCondition)).setter(setter(Builder::numberCondition))
            .constructor(NumberCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCondition").build()).build();

    private static final SdkField<BooleanCondition> BOOLEAN_CONDITION_FIELD = SdkField
            .<BooleanCondition> builder(MarshallingType.SDK_POJO).memberName("BooleanCondition")
            .getter(getter(EvaluationSearchCriteria::booleanCondition)).setter(setter(Builder::booleanCondition))
            .constructor(BooleanCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanCondition").build()).build();

    private static final SdkField<DateTimeCondition> DATE_TIME_CONDITION_FIELD = SdkField
            .<DateTimeCondition> builder(MarshallingType.SDK_POJO).memberName("DateTimeCondition")
            .getter(getter(EvaluationSearchCriteria::dateTimeCondition)).setter(setter(Builder::dateTimeCondition))
            .constructor(DateTimeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeCondition").build()).build();

    private static final SdkField<DecimalCondition> DECIMAL_CONDITION_FIELD = SdkField
            .<DecimalCondition> builder(MarshallingType.SDK_POJO).memberName("DecimalCondition")
            .getter(getter(EvaluationSearchCriteria::decimalCondition)).setter(setter(Builder::decimalCondition))
            .constructor(DecimalCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, NUMBER_CONDITION_FIELD, BOOLEAN_CONDITION_FIELD,
            DATE_TIME_CONDITION_FIELD, DECIMAL_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationSearchCriteria> orConditions;

    private final List<EvaluationSearchCriteria> andConditions;

    private final StringCondition stringCondition;

    private final NumberCondition numberCondition;

    private final BooleanCondition booleanCondition;

    private final DateTimeCondition dateTimeCondition;

    private final DecimalCondition decimalCondition;

    private EvaluationSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.numberCondition = builder.numberCondition;
        this.booleanCondition = builder.booleanCondition;
        this.dateTimeCondition = builder.dateTimeCondition;
        this.decimalCondition = builder.decimalCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an OR condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an OR condition.
     */
    public final List<EvaluationSearchCriteria> orConditions() {
        return orConditions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an AND condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an AND condition.
     */
    public final List<EvaluationSearchCriteria> andConditions() {
        return andConditions;
    }

    /**
     * Returns the value of the StringCondition property for this object.
     * 
     * @return The value of the StringCondition property for this object.
     */
    public final StringCondition stringCondition() {
        return stringCondition;
    }

    /**
     * Returns the value of the NumberCondition property for this object.
     * 
     * @return The value of the NumberCondition property for this object.
     */
    public final NumberCondition numberCondition() {
        return numberCondition;
    }

    /**
     * <p>
     * The boolean condition search criteria for searching evaluations.
     * </p>
     * 
     * @return The boolean condition search criteria for searching evaluations.
     */
    public final BooleanCondition booleanCondition() {
        return booleanCondition;
    }

    /**
     * <p>
     * The datetime condition search criteria for searching evaluations.
     * </p>
     * 
     * @return The datetime condition search criteria for searching evaluations.
     */
    public final DateTimeCondition dateTimeCondition() {
        return dateTimeCondition;
    }

    /**
     * <p>
     * The decimal condition search criteria for searching evaluations.
     * </p>
     * 
     * @return The decimal condition search criteria for searching evaluations.
     */
    public final DecimalCondition decimalCondition() {
        return decimalCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(numberCondition());
        hashCode = 31 * hashCode + Objects.hashCode(booleanCondition());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeCondition());
        hashCode = 31 * hashCode + Objects.hashCode(decimalCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationSearchCriteria)) {
            return false;
        }
        EvaluationSearchCriteria other = (EvaluationSearchCriteria) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(stringCondition(), other.stringCondition())
                && Objects.equals(numberCondition(), other.numberCondition())
                && Objects.equals(booleanCondition(), other.booleanCondition())
                && Objects.equals(dateTimeCondition(), other.dateTimeCondition())
                && Objects.equals(decimalCondition(), other.decimalCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationSearchCriteria").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndConditions", hasAndConditions() ? andConditions() : null).add("StringCondition", stringCondition())
                .add("NumberCondition", numberCondition()).add("BooleanCondition", booleanCondition())
                .add("DateTimeCondition", dateTimeCondition()).add("DecimalCondition", decimalCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "StringCondition":
            return Optional.ofNullable(clazz.cast(stringCondition()));
        case "NumberCondition":
            return Optional.ofNullable(clazz.cast(numberCondition()));
        case "BooleanCondition":
            return Optional.ofNullable(clazz.cast(booleanCondition()));
        case "DateTimeCondition":
            return Optional.ofNullable(clazz.cast(dateTimeCondition()));
        case "DecimalCondition":
            return Optional.ofNullable(clazz.cast(decimalCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndConditions", AND_CONDITIONS_FIELD);
        map.put("StringCondition", STRING_CONDITION_FIELD);
        map.put("NumberCondition", NUMBER_CONDITION_FIELD);
        map.put("BooleanCondition", BOOLEAN_CONDITION_FIELD);
        map.put("DateTimeCondition", DATE_TIME_CONDITION_FIELD);
        map.put("DecimalCondition", DECIMAL_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationSearchCriteria, T> g) {
        return obj -> g.apply((EvaluationSearchCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationSearchCriteria> {
        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<EvaluationSearchCriteria> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(EvaluationSearchCriteria... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #orConditions(List<EvaluationSearchCriteria>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<EvaluationSearchCriteria>)
         */
        Builder orConditions(Consumer<Builder>... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<EvaluationSearchCriteria> andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(EvaluationSearchCriteria... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an AND condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #andConditions(List<EvaluationSearchCriteria>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<EvaluationSearchCriteria>)
         */
        Builder andConditions(Consumer<Builder>... andConditions);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * @param stringCondition
         *        The new value for the StringCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringCondition(StringCondition stringCondition);

        /**
         * Sets the value of the StringCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StringCondition.Builder} avoiding the
         * need to create one manually via {@link StringCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stringCondition(StringCondition)}.
         * 
         * @param stringCondition
         *        a consumer that will call methods on {@link StringCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringCondition(StringCondition)
         */
        default Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return stringCondition(StringCondition.builder().applyMutation(stringCondition).build());
        }

        /**
         * Sets the value of the NumberCondition property for this object.
         *
         * @param numberCondition
         *        The new value for the NumberCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberCondition(NumberCondition numberCondition);

        /**
         * Sets the value of the NumberCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NumberCondition.Builder} avoiding the
         * need to create one manually via {@link NumberCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumberCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #numberCondition(NumberCondition)}.
         * 
         * @param numberCondition
         *        a consumer that will call methods on {@link NumberCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberCondition(NumberCondition)
         */
        default Builder numberCondition(Consumer<NumberCondition.Builder> numberCondition) {
            return numberCondition(NumberCondition.builder().applyMutation(numberCondition).build());
        }

        /**
         * <p>
         * The boolean condition search criteria for searching evaluations.
         * </p>
         * 
         * @param booleanCondition
         *        The boolean condition search criteria for searching evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanCondition(BooleanCondition booleanCondition);

        /**
         * <p>
         * The boolean condition search criteria for searching evaluations.
         * </p>
         * This is a convenience method that creates an instance of the {@link BooleanCondition.Builder} avoiding the
         * need to create one manually via {@link BooleanCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BooleanCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #booleanCondition(BooleanCondition)}.
         * 
         * @param booleanCondition
         *        a consumer that will call methods on {@link BooleanCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #booleanCondition(BooleanCondition)
         */
        default Builder booleanCondition(Consumer<BooleanCondition.Builder> booleanCondition) {
            return booleanCondition(BooleanCondition.builder().applyMutation(booleanCondition).build());
        }

        /**
         * <p>
         * The datetime condition search criteria for searching evaluations.
         * </p>
         * 
         * @param dateTimeCondition
         *        The datetime condition search criteria for searching evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeCondition(DateTimeCondition dateTimeCondition);

        /**
         * <p>
         * The datetime condition search criteria for searching evaluations.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeCondition.Builder} avoiding the
         * need to create one manually via {@link DateTimeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #dateTimeCondition(DateTimeCondition)}.
         * 
         * @param dateTimeCondition
         *        a consumer that will call methods on {@link DateTimeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeCondition(DateTimeCondition)
         */
        default Builder dateTimeCondition(Consumer<DateTimeCondition.Builder> dateTimeCondition) {
            return dateTimeCondition(DateTimeCondition.builder().applyMutation(dateTimeCondition).build());
        }

        /**
         * <p>
         * The decimal condition search criteria for searching evaluations.
         * </p>
         * 
         * @param decimalCondition
         *        The decimal condition search criteria for searching evaluations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalCondition(DecimalCondition decimalCondition);

        /**
         * <p>
         * The decimal condition search criteria for searching evaluations.
         * </p>
         * This is a convenience method that creates an instance of the {@link DecimalCondition.Builder} avoiding the
         * need to create one manually via {@link DecimalCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecimalCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #decimalCondition(DecimalCondition)}.
         * 
         * @param decimalCondition
         *        a consumer that will call methods on {@link DecimalCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decimalCondition(DecimalCondition)
         */
        default Builder decimalCondition(Consumer<DecimalCondition.Builder> decimalCondition) {
            return decimalCondition(DecimalCondition.builder().applyMutation(decimalCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();

        private List<EvaluationSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();

        private StringCondition stringCondition;

        private NumberCondition numberCondition;

        private BooleanCondition booleanCondition;

        private DateTimeCondition dateTimeCondition;

        private DecimalCondition decimalCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationSearchCriteria model) {
            orConditions(model.orConditions);
            andConditions(model.andConditions);
            stringCondition(model.stringCondition);
            numberCondition(model.numberCondition);
            booleanCondition(model.booleanCondition);
            dateTimeCondition(model.dateTimeCondition);
            decimalCondition(model.decimalCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = EvaluationSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = EvaluationSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<EvaluationSearchCriteria> orConditions) {
            this.orConditions = EvaluationSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(EvaluationSearchCriteria... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> EvaluationSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = EvaluationSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = EvaluationSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<EvaluationSearchCriteria> andConditions) {
            this.andConditions = EvaluationSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(EvaluationSearchCriteria... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> EvaluationSearchCriteria.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return stringCondition != null ? stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final NumberCondition.Builder getNumberCondition() {
            return numberCondition != null ? numberCondition.toBuilder() : null;
        }

        public final void setNumberCondition(NumberCondition.BuilderImpl numberCondition) {
            this.numberCondition = numberCondition != null ? numberCondition.build() : null;
        }

        @Override
        public final Builder numberCondition(NumberCondition numberCondition) {
            this.numberCondition = numberCondition;
            return this;
        }

        public final BooleanCondition.Builder getBooleanCondition() {
            return booleanCondition != null ? booleanCondition.toBuilder() : null;
        }

        public final void setBooleanCondition(BooleanCondition.BuilderImpl booleanCondition) {
            this.booleanCondition = booleanCondition != null ? booleanCondition.build() : null;
        }

        @Override
        public final Builder booleanCondition(BooleanCondition booleanCondition) {
            this.booleanCondition = booleanCondition;
            return this;
        }

        public final DateTimeCondition.Builder getDateTimeCondition() {
            return dateTimeCondition != null ? dateTimeCondition.toBuilder() : null;
        }

        public final void setDateTimeCondition(DateTimeCondition.BuilderImpl dateTimeCondition) {
            this.dateTimeCondition = dateTimeCondition != null ? dateTimeCondition.build() : null;
        }

        @Override
        public final Builder dateTimeCondition(DateTimeCondition dateTimeCondition) {
            this.dateTimeCondition = dateTimeCondition;
            return this;
        }

        public final DecimalCondition.Builder getDecimalCondition() {
            return decimalCondition != null ? decimalCondition.toBuilder() : null;
        }

        public final void setDecimalCondition(DecimalCondition.BuilderImpl decimalCondition) {
            this.decimalCondition = decimalCondition != null ? decimalCondition.build() : null;
        }

        @Override
        public final Builder decimalCondition(DecimalCondition decimalCondition) {
            this.decimalCondition = decimalCondition;
            return this;
        }

        @Override
        public EvaluationSearchCriteria build() {
            return new EvaluationSearchCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
