/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An analysis for a generative AI answer to the question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationGenAIAnswerAnalysisDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationGenAIAnswerAnalysisDetails.Builder, EvaluationGenAIAnswerAnalysisDetails> {
    private static final SdkField<String> JUSTIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Justification").getter(getter(EvaluationGenAIAnswerAnalysisDetails::justification))
            .setter(setter(Builder::justification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Justification").build()).build();

    private static final SdkField<List<EvaluationTranscriptPointOfInterest>> POINTS_OF_INTEREST_FIELD = SdkField
            .<List<EvaluationTranscriptPointOfInterest>> builder(MarshallingType.LIST)
            .memberName("PointsOfInterest")
            .getter(getter(EvaluationGenAIAnswerAnalysisDetails::pointsOfInterest))
            .setter(setter(Builder::pointsOfInterest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointsOfInterest").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationTranscriptPointOfInterest> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationTranscriptPointOfInterest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUSTIFICATION_FIELD,
            POINTS_OF_INTEREST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String justification;

    private final List<EvaluationTranscriptPointOfInterest> pointsOfInterest;

    private EvaluationGenAIAnswerAnalysisDetails(BuilderImpl builder) {
        this.justification = builder.justification;
        this.pointsOfInterest = builder.pointsOfInterest;
    }

    /**
     * <p>
     * Generative AI automation answer justification.
     * </p>
     * 
     * @return Generative AI automation answer justification.
     */
    public final String justification() {
        return justification;
    }

    /**
     * For responses, this returns true if the service returned a value for the PointsOfInterest property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPointsOfInterest() {
        return pointsOfInterest != null && !(pointsOfInterest instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Generative AI automation answer analysis points of interest.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPointsOfInterest} method.
     * </p>
     * 
     * @return Generative AI automation answer analysis points of interest.
     */
    public final List<EvaluationTranscriptPointOfInterest> pointsOfInterest() {
        return pointsOfInterest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(justification());
        hashCode = 31 * hashCode + Objects.hashCode(hasPointsOfInterest() ? pointsOfInterest() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationGenAIAnswerAnalysisDetails)) {
            return false;
        }
        EvaluationGenAIAnswerAnalysisDetails other = (EvaluationGenAIAnswerAnalysisDetails) obj;
        return Objects.equals(justification(), other.justification()) && hasPointsOfInterest() == other.hasPointsOfInterest()
                && Objects.equals(pointsOfInterest(), other.pointsOfInterest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationGenAIAnswerAnalysisDetails").add("Justification", justification())
                .add("PointsOfInterest", hasPointsOfInterest() ? pointsOfInterest() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Justification":
            return Optional.ofNullable(clazz.cast(justification()));
        case "PointsOfInterest":
            return Optional.ofNullable(clazz.cast(pointsOfInterest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Justification", JUSTIFICATION_FIELD);
        map.put("PointsOfInterest", POINTS_OF_INTEREST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationGenAIAnswerAnalysisDetails, T> g) {
        return obj -> g.apply((EvaluationGenAIAnswerAnalysisDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationGenAIAnswerAnalysisDetails> {
        /**
         * <p>
         * Generative AI automation answer justification.
         * </p>
         * 
         * @param justification
         *        Generative AI automation answer justification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder justification(String justification);

        /**
         * <p>
         * Generative AI automation answer analysis points of interest.
         * </p>
         * 
         * @param pointsOfInterest
         *        Generative AI automation answer analysis points of interest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> pointsOfInterest);

        /**
         * <p>
         * Generative AI automation answer analysis points of interest.
         * </p>
         * 
         * @param pointsOfInterest
         *        Generative AI automation answer analysis points of interest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pointsOfInterest(EvaluationTranscriptPointOfInterest... pointsOfInterest);

        /**
         * <p>
         * Generative AI automation answer analysis points of interest.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #pointsOfInterest(List<EvaluationTranscriptPointOfInterest>)}.
         * 
         * @param pointsOfInterest
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationTranscriptPointOfInterest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pointsOfInterest(java.util.Collection<EvaluationTranscriptPointOfInterest>)
         */
        Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder>... pointsOfInterest);
    }

    static final class BuilderImpl implements Builder {
        private String justification;

        private List<EvaluationTranscriptPointOfInterest> pointsOfInterest = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationGenAIAnswerAnalysisDetails model) {
            justification(model.justification);
            pointsOfInterest(model.pointsOfInterest);
        }

        public final String getJustification() {
            return justification;
        }

        public final void setJustification(String justification) {
            this.justification = justification;
        }

        @Override
        public final Builder justification(String justification) {
            this.justification = justification;
            return this;
        }

        public final List<EvaluationTranscriptPointOfInterest.Builder> getPointsOfInterest() {
            List<EvaluationTranscriptPointOfInterest.Builder> result = EvaluationTranscriptPointsOfInterestCopier
                    .copyToBuilder(this.pointsOfInterest);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPointsOfInterest(Collection<EvaluationTranscriptPointOfInterest.BuilderImpl> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copyFromBuilder(pointsOfInterest);
        }

        @Override
        public final Builder pointsOfInterest(Collection<EvaluationTranscriptPointOfInterest> pointsOfInterest) {
            this.pointsOfInterest = EvaluationTranscriptPointsOfInterestCopier.copy(pointsOfInterest);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(EvaluationTranscriptPointOfInterest... pointsOfInterest) {
            pointsOfInterest(Arrays.asList(pointsOfInterest));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pointsOfInterest(Consumer<EvaluationTranscriptPointOfInterest.Builder>... pointsOfInterest) {
            pointsOfInterest(Stream.of(pointsOfInterest)
                    .map(c -> EvaluationTranscriptPointOfInterest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluationGenAIAnswerAnalysisDetails build() {
            return new EvaluationGenAIAnswerAnalysisDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
