/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the automation option of a single select question.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormSingleSelectQuestionAutomationOption
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<EvaluationFormSingleSelectQuestionAutomationOption.Builder, EvaluationFormSingleSelectQuestionAutomationOption> {
    private static final SdkField<SingleSelectQuestionRuleCategoryAutomation> RULE_CATEGORY_FIELD = SdkField
            .<SingleSelectQuestionRuleCategoryAutomation> builder(MarshallingType.SDK_POJO).memberName("RuleCategory")
            .getter(getter(EvaluationFormSingleSelectQuestionAutomationOption::ruleCategory))
            .setter(setter(Builder::ruleCategory)).constructor(SingleSelectQuestionRuleCategoryAutomation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_CATEGORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SingleSelectQuestionRuleCategoryAutomation ruleCategory;

    private final Type type;

    private EvaluationFormSingleSelectQuestionAutomationOption(BuilderImpl builder) {
        this.ruleCategory = builder.ruleCategory;
        this.type = builder.type;
    }

    /**
     * <p>
     * The automation option based on a rule category for the single select question.
     * </p>
     * 
     * @return The automation option based on a rule category for the single select question.
     */
    public final SingleSelectQuestionRuleCategoryAutomation ruleCategory() {
        return ruleCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleCategory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSingleSelectQuestionAutomationOption)) {
            return false;
        }
        EvaluationFormSingleSelectQuestionAutomationOption other = (EvaluationFormSingleSelectQuestionAutomationOption) obj;
        return Objects.equals(ruleCategory(), other.ruleCategory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormSingleSelectQuestionAutomationOption").add("RuleCategory", ruleCategory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleCategory":
            return Optional.ofNullable(clazz.cast(ruleCategory()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ruleCategory()} initialized to the given value.
     *
     * <p>
     * The automation option based on a rule category for the single select question.
     * </p>
     * 
     * @param ruleCategory
     *        The automation option based on a rule category for the single select question.
     */
    public static EvaluationFormSingleSelectQuestionAutomationOption fromRuleCategory(
            SingleSelectQuestionRuleCategoryAutomation ruleCategory) {
        return builder().ruleCategory(ruleCategory).build();
    }

    /**
     * Create an instance of this class with {@link #ruleCategory()} initialized to the given value.
     *
     * <p>
     * The automation option based on a rule category for the single select question.
     * </p>
     * 
     * @param ruleCategory
     *        The automation option based on a rule category for the single select question.
     */
    public static EvaluationFormSingleSelectQuestionAutomationOption fromRuleCategory(
            Consumer<SingleSelectQuestionRuleCategoryAutomation.Builder> ruleCategory) {
        SingleSelectQuestionRuleCategoryAutomation.Builder builder = SingleSelectQuestionRuleCategoryAutomation.builder();
        ruleCategory.accept(builder);
        return fromRuleCategory(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleCategory", RULE_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSingleSelectQuestionAutomationOption, T> g) {
        return obj -> g.apply((EvaluationFormSingleSelectQuestionAutomationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormSingleSelectQuestionAutomationOption> {
        /**
         * <p>
         * The automation option based on a rule category for the single select question.
         * </p>
         * 
         * @param ruleCategory
         *        The automation option based on a rule category for the single select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleCategory(SingleSelectQuestionRuleCategoryAutomation ruleCategory);

        /**
         * <p>
         * The automation option based on a rule category for the single select question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SingleSelectQuestionRuleCategoryAutomation.Builder} avoiding the need to create one manually via
         * {@link SingleSelectQuestionRuleCategoryAutomation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleSelectQuestionRuleCategoryAutomation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #ruleCategory(SingleSelectQuestionRuleCategoryAutomation)}.
         * 
         * @param ruleCategory
         *        a consumer that will call methods on {@link SingleSelectQuestionRuleCategoryAutomation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleCategory(SingleSelectQuestionRuleCategoryAutomation)
         */
        default Builder ruleCategory(Consumer<SingleSelectQuestionRuleCategoryAutomation.Builder> ruleCategory) {
            return ruleCategory(SingleSelectQuestionRuleCategoryAutomation.builder().applyMutation(ruleCategory).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SingleSelectQuestionRuleCategoryAutomation ruleCategory;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSingleSelectQuestionAutomationOption model) {
            ruleCategory(model.ruleCategory);
        }

        public final SingleSelectQuestionRuleCategoryAutomation.Builder getRuleCategory() {
            return ruleCategory != null ? ruleCategory.toBuilder() : null;
        }

        public final void setRuleCategory(SingleSelectQuestionRuleCategoryAutomation.BuilderImpl ruleCategory) {
            Object oldValue = this.ruleCategory;
            this.ruleCategory = ruleCategory != null ? ruleCategory.build() : null;
            handleUnionValueChange(Type.RULE_CATEGORY, oldValue, this.ruleCategory);
        }

        @Override
        public final Builder ruleCategory(SingleSelectQuestionRuleCategoryAutomation ruleCategory) {
            Object oldValue = this.ruleCategory;
            this.ruleCategory = ruleCategory;
            handleUnionValueChange(Type.RULE_CATEGORY, oldValue, this.ruleCategory);
            return this;
        }

        @Override
        public EvaluationFormSingleSelectQuestionAutomationOption build() {
            return new EvaluationFormSingleSelectQuestionAutomationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationFormSingleSelectQuestionAutomationOption#type()
     */
    public enum Type {
        RULE_CATEGORY,

        UNKNOWN_TO_SDK_VERSION
    }
}
