/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A question automation answer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormQuestionAutomationAnswerSource implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormQuestionAutomationAnswerSource.Builder, EvaluationFormQuestionAutomationAnswerSource> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(EvaluationFormQuestionAutomationAnswerSource::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceType;

    private EvaluationFormQuestionAutomationAnswerSource(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * The automation answer source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link EvaluationFormQuestionAutomationAnswerSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The automation answer source type.
     * @see EvaluationFormQuestionAutomationAnswerSourceType
     */
    public final EvaluationFormQuestionAutomationAnswerSourceType sourceType() {
        return EvaluationFormQuestionAutomationAnswerSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The automation answer source type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link EvaluationFormQuestionAutomationAnswerSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The automation answer source type.
     * @see EvaluationFormQuestionAutomationAnswerSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormQuestionAutomationAnswerSource)) {
            return false;
        }
        EvaluationFormQuestionAutomationAnswerSource other = (EvaluationFormQuestionAutomationAnswerSource) obj;
        return Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormQuestionAutomationAnswerSource").add("SourceType", sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceType", SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormQuestionAutomationAnswerSource, T> g) {
        return obj -> g.apply((EvaluationFormQuestionAutomationAnswerSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormQuestionAutomationAnswerSource> {
        /**
         * <p>
         * The automation answer source type.
         * </p>
         * 
         * @param sourceType
         *        The automation answer source type.
         * @see EvaluationFormQuestionAutomationAnswerSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormQuestionAutomationAnswerSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The automation answer source type.
         * </p>
         * 
         * @param sourceType
         *        The automation answer source type.
         * @see EvaluationFormQuestionAutomationAnswerSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormQuestionAutomationAnswerSourceType
         */
        Builder sourceType(EvaluationFormQuestionAutomationAnswerSourceType sourceType);
    }

    static final class BuilderImpl implements Builder {
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormQuestionAutomationAnswerSource model) {
            sourceType(model.sourceType);
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(EvaluationFormQuestionAutomationAnswerSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        @Override
        public EvaluationFormQuestionAutomationAnswerSource build() {
            return new EvaluationFormQuestionAutomationAnswerSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
