/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties for a multi-select question in an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormMultiSelectQuestionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormMultiSelectQuestionProperties.Builder, EvaluationFormMultiSelectQuestionProperties> {
    private static final SdkField<List<EvaluationFormMultiSelectQuestionOption>> OPTIONS_FIELD = SdkField
            .<List<EvaluationFormMultiSelectQuestionOption>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(EvaluationFormMultiSelectQuestionProperties::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormMultiSelectQuestionOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormMultiSelectQuestionOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayAs").getter(getter(EvaluationFormMultiSelectQuestionProperties::displayAsAsString))
            .setter(setter(Builder::displayAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayAs").build()).build();

    private static final SdkField<EvaluationFormMultiSelectQuestionAutomation> AUTOMATION_FIELD = SdkField
            .<EvaluationFormMultiSelectQuestionAutomation> builder(MarshallingType.SDK_POJO).memberName("Automation")
            .getter(getter(EvaluationFormMultiSelectQuestionProperties::automation)).setter(setter(Builder::automation))
            .constructor(EvaluationFormMultiSelectQuestionAutomation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Automation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD,
            DISPLAY_AS_FIELD, AUTOMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EvaluationFormMultiSelectQuestionOption> options;

    private final String displayAs;

    private final EvaluationFormMultiSelectQuestionAutomation automation;

    private EvaluationFormMultiSelectQuestionProperties(BuilderImpl builder) {
        this.options = builder.options;
        this.displayAs = builder.displayAs;
        this.automation = builder.automation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Options available for this multi-select question.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return Options available for this multi-select question.
     */
    public final List<EvaluationFormMultiSelectQuestionOption> options() {
        return options;
    }

    /**
     * <p>
     * Display format for the multi-select question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayAs} will
     * return {@link EvaluationFormMultiSelectQuestionDisplayMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #displayAsAsString}.
     * </p>
     * 
     * @return Display format for the multi-select question.
     * @see EvaluationFormMultiSelectQuestionDisplayMode
     */
    public final EvaluationFormMultiSelectQuestionDisplayMode displayAs() {
        return EvaluationFormMultiSelectQuestionDisplayMode.fromValue(displayAs);
    }

    /**
     * <p>
     * Display format for the multi-select question.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #displayAs} will
     * return {@link EvaluationFormMultiSelectQuestionDisplayMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #displayAsAsString}.
     * </p>
     * 
     * @return Display format for the multi-select question.
     * @see EvaluationFormMultiSelectQuestionDisplayMode
     */
    public final String displayAsAsString() {
        return displayAs;
    }

    /**
     * <p>
     * Automation configuration for this multi-select question.
     * </p>
     * 
     * @return Automation configuration for this multi-select question.
     */
    public final EvaluationFormMultiSelectQuestionAutomation automation() {
        return automation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(automation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormMultiSelectQuestionProperties)) {
            return false;
        }
        EvaluationFormMultiSelectQuestionProperties other = (EvaluationFormMultiSelectQuestionProperties) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && Objects.equals(displayAsAsString(), other.displayAsAsString())
                && Objects.equals(automation(), other.automation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormMultiSelectQuestionProperties").add("Options", hasOptions() ? options() : null)
                .add("DisplayAs", displayAsAsString()).add("Automation", automation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "DisplayAs":
            return Optional.ofNullable(clazz.cast(displayAsAsString()));
        case "Automation":
            return Optional.ofNullable(clazz.cast(automation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Options", OPTIONS_FIELD);
        map.put("DisplayAs", DISPLAY_AS_FIELD);
        map.put("Automation", AUTOMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormMultiSelectQuestionProperties, T> g) {
        return obj -> g.apply((EvaluationFormMultiSelectQuestionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormMultiSelectQuestionProperties> {
        /**
         * <p>
         * Options available for this multi-select question.
         * </p>
         * 
         * @param options
         *        Options available for this multi-select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<EvaluationFormMultiSelectQuestionOption> options);

        /**
         * <p>
         * Options available for this multi-select question.
         * </p>
         * 
         * @param options
         *        Options available for this multi-select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(EvaluationFormMultiSelectQuestionOption... options);

        /**
         * <p>
         * Options available for this multi-select question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionOption.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionOption.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #options(List<EvaluationFormMultiSelectQuestionOption>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormMultiSelectQuestionOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<EvaluationFormMultiSelectQuestionOption>)
         */
        Builder options(Consumer<EvaluationFormMultiSelectQuestionOption.Builder>... options);

        /**
         * <p>
         * Display format for the multi-select question.
         * </p>
         * 
         * @param displayAs
         *        Display format for the multi-select question.
         * @see EvaluationFormMultiSelectQuestionDisplayMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormMultiSelectQuestionDisplayMode
         */
        Builder displayAs(String displayAs);

        /**
         * <p>
         * Display format for the multi-select question.
         * </p>
         * 
         * @param displayAs
         *        Display format for the multi-select question.
         * @see EvaluationFormMultiSelectQuestionDisplayMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormMultiSelectQuestionDisplayMode
         */
        Builder displayAs(EvaluationFormMultiSelectQuestionDisplayMode displayAs);

        /**
         * <p>
         * Automation configuration for this multi-select question.
         * </p>
         * 
         * @param automation
         *        Automation configuration for this multi-select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automation(EvaluationFormMultiSelectQuestionAutomation automation);

        /**
         * <p>
         * Automation configuration for this multi-select question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormMultiSelectQuestionAutomation.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormMultiSelectQuestionAutomation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormMultiSelectQuestionAutomation.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #automation(EvaluationFormMultiSelectQuestionAutomation)}.
         * 
         * @param automation
         *        a consumer that will call methods on {@link EvaluationFormMultiSelectQuestionAutomation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automation(EvaluationFormMultiSelectQuestionAutomation)
         */
        default Builder automation(Consumer<EvaluationFormMultiSelectQuestionAutomation.Builder> automation) {
            return automation(EvaluationFormMultiSelectQuestionAutomation.builder().applyMutation(automation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationFormMultiSelectQuestionOption> options = DefaultSdkAutoConstructList.getInstance();

        private String displayAs;

        private EvaluationFormMultiSelectQuestionAutomation automation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormMultiSelectQuestionProperties model) {
            options(model.options);
            displayAs(model.displayAs);
            automation(model.automation);
        }

        public final List<EvaluationFormMultiSelectQuestionOption.Builder> getOptions() {
            List<EvaluationFormMultiSelectQuestionOption.Builder> result = EvaluationFormMultiSelectQuestionOptionListCopier
                    .copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormMultiSelectQuestionOption.BuilderImpl> options) {
            this.options = EvaluationFormMultiSelectQuestionOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormMultiSelectQuestionOption> options) {
            this.options = EvaluationFormMultiSelectQuestionOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormMultiSelectQuestionOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormMultiSelectQuestionOption.Builder>... options) {
            options(Stream.of(options).map(c -> EvaluationFormMultiSelectQuestionOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayAs() {
            return displayAs;
        }

        public final void setDisplayAs(String displayAs) {
            this.displayAs = displayAs;
        }

        @Override
        public final Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public final Builder displayAs(EvaluationFormMultiSelectQuestionDisplayMode displayAs) {
            this.displayAs(displayAs == null ? null : displayAs.toString());
            return this;
        }

        public final EvaluationFormMultiSelectQuestionAutomation.Builder getAutomation() {
            return automation != null ? automation.toBuilder() : null;
        }

        public final void setAutomation(EvaluationFormMultiSelectQuestionAutomation.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        @Override
        public final Builder automation(EvaluationFormMultiSelectQuestionAutomation automation) {
            this.automation = automation;
            return this;
        }

        @Override
        public EvaluationFormMultiSelectQuestionProperties build() {
            return new EvaluationFormMultiSelectQuestionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
