/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Language configuration for an evaluation form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormLanguageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormLanguageConfiguration.Builder, EvaluationFormLanguageConfiguration> {
    private static final SdkField<String> FORM_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FormLanguage").getter(getter(EvaluationFormLanguageConfiguration::formLanguageAsString))
            .setter(setter(Builder::formLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormLanguage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORM_LANGUAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String formLanguage;

    private EvaluationFormLanguageConfiguration(BuilderImpl builder) {
        this.formLanguage = builder.formLanguage;
    }

    /**
     * <p>
     * The language for the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formLanguage} will
     * return {@link EvaluationFormLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formLanguageAsString}.
     * </p>
     * 
     * @return The language for the evaluation form.
     * @see EvaluationFormLanguageCode
     */
    public final EvaluationFormLanguageCode formLanguage() {
        return EvaluationFormLanguageCode.fromValue(formLanguage);
    }

    /**
     * <p>
     * The language for the evaluation form.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formLanguage} will
     * return {@link EvaluationFormLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #formLanguageAsString}.
     * </p>
     * 
     * @return The language for the evaluation form.
     * @see EvaluationFormLanguageCode
     */
    public final String formLanguageAsString() {
        return formLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formLanguageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormLanguageConfiguration)) {
            return false;
        }
        EvaluationFormLanguageConfiguration other = (EvaluationFormLanguageConfiguration) obj;
        return Objects.equals(formLanguageAsString(), other.formLanguageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormLanguageConfiguration").add("FormLanguage", formLanguageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FormLanguage":
            return Optional.ofNullable(clazz.cast(formLanguageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FormLanguage", FORM_LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormLanguageConfiguration, T> g) {
        return obj -> g.apply((EvaluationFormLanguageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormLanguageConfiguration> {
        /**
         * <p>
         * The language for the evaluation form.
         * </p>
         * 
         * @param formLanguage
         *        The language for the evaluation form.
         * @see EvaluationFormLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormLanguageCode
         */
        Builder formLanguage(String formLanguage);

        /**
         * <p>
         * The language for the evaluation form.
         * </p>
         * 
         * @param formLanguage
         *        The language for the evaluation form.
         * @see EvaluationFormLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormLanguageCode
         */
        Builder formLanguage(EvaluationFormLanguageCode formLanguage);
    }

    static final class BuilderImpl implements Builder {
        private String formLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormLanguageConfiguration model) {
            formLanguage(model.formLanguage);
        }

        public final String getFormLanguage() {
            return formLanguage;
        }

        public final void setFormLanguage(String formLanguage) {
            this.formLanguage = formLanguage;
        }

        @Override
        public final Builder formLanguage(String formLanguage) {
            this.formLanguage = formLanguage;
            return this;
        }

        @Override
        public final Builder formLanguage(EvaluationFormLanguageCode formLanguage) {
            this.formLanguage(formLanguage == null ? null : formLanguage.toString());
            return this;
        }

        @Override
        public EvaluationFormLanguageConfiguration build() {
            return new EvaluationFormLanguageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
