/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An item enablement configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormItemEnablementConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormItemEnablementConfiguration.Builder, EvaluationFormItemEnablementConfiguration> {
    private static final SdkField<EvaluationFormItemEnablementCondition> CONDITION_FIELD = SdkField
            .<EvaluationFormItemEnablementCondition> builder(MarshallingType.SDK_POJO).memberName("Condition")
            .getter(getter(EvaluationFormItemEnablementConfiguration::condition)).setter(setter(Builder::condition))
            .constructor(EvaluationFormItemEnablementCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(EvaluationFormItemEnablementConfiguration::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultAction").getter(getter(EvaluationFormItemEnablementConfiguration::defaultActionAsString))
            .setter(setter(Builder::defaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD, ACTION_FIELD,
            DEFAULT_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationFormItemEnablementCondition condition;

    private final String action;

    private final String defaultAction;

    private EvaluationFormItemEnablementConfiguration(BuilderImpl builder) {
        this.condition = builder.condition;
        this.action = builder.action;
        this.defaultAction = builder.defaultAction;
    }

    /**
     * <p>
     * A condition for item enablement configuration.
     * </p>
     * 
     * @return A condition for item enablement configuration.
     */
    public final EvaluationFormItemEnablementCondition condition() {
        return condition;
    }

    /**
     * <p>
     * An enablement action that if condition is satisfied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link EvaluationFormItemEnablementAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return An enablement action that if condition is satisfied.
     * @see EvaluationFormItemEnablementAction
     */
    public final EvaluationFormItemEnablementAction action() {
        return EvaluationFormItemEnablementAction.fromValue(action);
    }

    /**
     * <p>
     * An enablement action that if condition is satisfied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link EvaluationFormItemEnablementAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return An enablement action that if condition is satisfied.
     * @see EvaluationFormItemEnablementAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * An enablement action that if condition is not satisfied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link EvaluationFormItemEnablementAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultActionAsString}.
     * </p>
     * 
     * @return An enablement action that if condition is not satisfied.
     * @see EvaluationFormItemEnablementAction
     */
    public final EvaluationFormItemEnablementAction defaultAction() {
        return EvaluationFormItemEnablementAction.fromValue(defaultAction);
    }

    /**
     * <p>
     * An enablement action that if condition is not satisfied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultAction}
     * will return {@link EvaluationFormItemEnablementAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #defaultActionAsString}.
     * </p>
     * 
     * @return An enablement action that if condition is not satisfied.
     * @see EvaluationFormItemEnablementAction
     */
    public final String defaultActionAsString() {
        return defaultAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItemEnablementConfiguration)) {
            return false;
        }
        EvaluationFormItemEnablementConfiguration other = (EvaluationFormItemEnablementConfiguration) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(defaultActionAsString(), other.defaultActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormItemEnablementConfiguration").add("Condition", condition())
                .add("Action", actionAsString()).add("DefaultAction", defaultActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Condition", CONDITION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("DefaultAction", DEFAULT_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItemEnablementConfiguration, T> g) {
        return obj -> g.apply((EvaluationFormItemEnablementConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormItemEnablementConfiguration> {
        /**
         * <p>
         * A condition for item enablement configuration.
         * </p>
         * 
         * @param condition
         *        A condition for item enablement configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(EvaluationFormItemEnablementCondition condition);

        /**
         * <p>
         * A condition for item enablement configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationFormItemEnablementCondition.Builder} avoiding the need to create one manually via
         * {@link EvaluationFormItemEnablementCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormItemEnablementCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #condition(EvaluationFormItemEnablementCondition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link EvaluationFormItemEnablementCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(EvaluationFormItemEnablementCondition)
         */
        default Builder condition(Consumer<EvaluationFormItemEnablementCondition.Builder> condition) {
            return condition(EvaluationFormItemEnablementCondition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * An enablement action that if condition is satisfied.
         * </p>
         * 
         * @param action
         *        An enablement action that if condition is satisfied.
         * @see EvaluationFormItemEnablementAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementAction
         */
        Builder action(String action);

        /**
         * <p>
         * An enablement action that if condition is satisfied.
         * </p>
         * 
         * @param action
         *        An enablement action that if condition is satisfied.
         * @see EvaluationFormItemEnablementAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementAction
         */
        Builder action(EvaluationFormItemEnablementAction action);

        /**
         * <p>
         * An enablement action that if condition is not satisfied.
         * </p>
         * 
         * @param defaultAction
         *        An enablement action that if condition is not satisfied.
         * @see EvaluationFormItemEnablementAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementAction
         */
        Builder defaultAction(String defaultAction);

        /**
         * <p>
         * An enablement action that if condition is not satisfied.
         * </p>
         * 
         * @param defaultAction
         *        An enablement action that if condition is not satisfied.
         * @see EvaluationFormItemEnablementAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationFormItemEnablementAction
         */
        Builder defaultAction(EvaluationFormItemEnablementAction defaultAction);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationFormItemEnablementCondition condition;

        private String action;

        private String defaultAction;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItemEnablementConfiguration model) {
            condition(model.condition);
            action(model.action);
            defaultAction(model.defaultAction);
        }

        public final EvaluationFormItemEnablementCondition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(EvaluationFormItemEnablementCondition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(EvaluationFormItemEnablementCondition condition) {
            this.condition = condition;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(EvaluationFormItemEnablementAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getDefaultAction() {
            return defaultAction;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        @Override
        public final Builder defaultAction(EvaluationFormItemEnablementAction defaultAction) {
            this.defaultAction(defaultAction == null ? null : defaultAction.toString());
            return this;
        }

        @Override
        public EvaluationFormItemEnablementConfiguration build() {
            return new EvaluationFormItemEnablementConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
