/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about output answers for a contact evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationAnswerOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationAnswerOutput.Builder, EvaluationAnswerOutput> {
    private static final SdkField<EvaluationAnswerData> VALUE_FIELD = SdkField
            .<EvaluationAnswerData> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(EvaluationAnswerOutput::value)).setter(setter(Builder::value))
            .constructor(EvaluationAnswerData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<EvaluationAnswerData> SYSTEM_SUGGESTED_VALUE_FIELD = SdkField
            .<EvaluationAnswerData> builder(MarshallingType.SDK_POJO).memberName("SystemSuggestedValue")
            .getter(getter(EvaluationAnswerOutput::systemSuggestedValue)).setter(setter(Builder::systemSuggestedValue))
            .constructor(EvaluationAnswerData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemSuggestedValue").build())
            .build();

    private static final SdkField<List<EvaluationSuggestedAnswer>> SUGGESTED_ANSWERS_FIELD = SdkField
            .<List<EvaluationSuggestedAnswer>> builder(MarshallingType.LIST)
            .memberName("SuggestedAnswers")
            .getter(getter(EvaluationAnswerOutput::suggestedAnswers))
            .setter(setter(Builder::suggestedAnswers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestedAnswers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationSuggestedAnswer> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationSuggestedAnswer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD,
            SYSTEM_SUGGESTED_VALUE_FIELD, SUGGESTED_ANSWERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationAnswerData value;

    private final EvaluationAnswerData systemSuggestedValue;

    private final List<EvaluationSuggestedAnswer> suggestedAnswers;

    private EvaluationAnswerOutput(BuilderImpl builder) {
        this.value = builder.value;
        this.systemSuggestedValue = builder.systemSuggestedValue;
        this.suggestedAnswers = builder.suggestedAnswers;
    }

    /**
     * <p>
     * The value for an answer in a contact evaluation.
     * </p>
     * 
     * @return The value for an answer in a contact evaluation.
     */
    public final EvaluationAnswerData value() {
        return value;
    }

    /**
     * <p>
     * The system suggested value for an answer in a contact evaluation.
     * </p>
     * 
     * @return The system suggested value for an answer in a contact evaluation.
     */
    public final EvaluationAnswerData systemSuggestedValue() {
        return systemSuggestedValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the SuggestedAnswers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSuggestedAnswers() {
        return suggestedAnswers != null && !(suggestedAnswers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Automation suggested answers for the questions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuggestedAnswers} method.
     * </p>
     * 
     * @return Automation suggested answers for the questions.
     */
    public final List<EvaluationSuggestedAnswer> suggestedAnswers() {
        return suggestedAnswers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(systemSuggestedValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasSuggestedAnswers() ? suggestedAnswers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAnswerOutput)) {
            return false;
        }
        EvaluationAnswerOutput other = (EvaluationAnswerOutput) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(systemSuggestedValue(), other.systemSuggestedValue())
                && hasSuggestedAnswers() == other.hasSuggestedAnswers()
                && Objects.equals(suggestedAnswers(), other.suggestedAnswers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationAnswerOutput").add("Value", value())
                .add("SystemSuggestedValue", systemSuggestedValue())
                .add("SuggestedAnswers", hasSuggestedAnswers() ? suggestedAnswers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "SystemSuggestedValue":
            return Optional.ofNullable(clazz.cast(systemSuggestedValue()));
        case "SuggestedAnswers":
            return Optional.ofNullable(clazz.cast(suggestedAnswers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("SystemSuggestedValue", SYSTEM_SUGGESTED_VALUE_FIELD);
        map.put("SuggestedAnswers", SUGGESTED_ANSWERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAnswerOutput, T> g) {
        return obj -> g.apply((EvaluationAnswerOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationAnswerOutput> {
        /**
         * <p>
         * The value for an answer in a contact evaluation.
         * </p>
         * 
         * @param value
         *        The value for an answer in a contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(EvaluationAnswerData value);

        /**
         * <p>
         * The value for an answer in a contact evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationAnswerData.Builder} avoiding
         * the need to create one manually via {@link EvaluationAnswerData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationAnswerData.Builder#build()} is called immediately and
         * its result is passed to {@link #value(EvaluationAnswerData)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link EvaluationAnswerData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(EvaluationAnswerData)
         */
        default Builder value(Consumer<EvaluationAnswerData.Builder> value) {
            return value(EvaluationAnswerData.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The system suggested value for an answer in a contact evaluation.
         * </p>
         * 
         * @param systemSuggestedValue
         *        The system suggested value for an answer in a contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemSuggestedValue(EvaluationAnswerData systemSuggestedValue);

        /**
         * <p>
         * The system suggested value for an answer in a contact evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationAnswerData.Builder} avoiding
         * the need to create one manually via {@link EvaluationAnswerData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationAnswerData.Builder#build()} is called immediately and
         * its result is passed to {@link #systemSuggestedValue(EvaluationAnswerData)}.
         * 
         * @param systemSuggestedValue
         *        a consumer that will call methods on {@link EvaluationAnswerData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemSuggestedValue(EvaluationAnswerData)
         */
        default Builder systemSuggestedValue(Consumer<EvaluationAnswerData.Builder> systemSuggestedValue) {
            return systemSuggestedValue(EvaluationAnswerData.builder().applyMutation(systemSuggestedValue).build());
        }

        /**
         * <p>
         * Automation suggested answers for the questions.
         * </p>
         * 
         * @param suggestedAnswers
         *        Automation suggested answers for the questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedAnswers(Collection<EvaluationSuggestedAnswer> suggestedAnswers);

        /**
         * <p>
         * Automation suggested answers for the questions.
         * </p>
         * 
         * @param suggestedAnswers
         *        Automation suggested answers for the questions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedAnswers(EvaluationSuggestedAnswer... suggestedAnswers);

        /**
         * <p>
         * Automation suggested answers for the questions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSuggestedAnswer.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSuggestedAnswer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationSuggestedAnswer.Builder#build()} is called
         * immediately and its result is passed to {@link #suggestedAnswers(List<EvaluationSuggestedAnswer>)}.
         * 
         * @param suggestedAnswers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationSuggestedAnswer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suggestedAnswers(java.util.Collection<EvaluationSuggestedAnswer>)
         */
        Builder suggestedAnswers(Consumer<EvaluationSuggestedAnswer.Builder>... suggestedAnswers);
    }

    static final class BuilderImpl implements Builder {
        private EvaluationAnswerData value;

        private EvaluationAnswerData systemSuggestedValue;

        private List<EvaluationSuggestedAnswer> suggestedAnswers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAnswerOutput model) {
            value(model.value);
            systemSuggestedValue(model.systemSuggestedValue);
            suggestedAnswers(model.suggestedAnswers);
        }

        public final EvaluationAnswerData.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(EvaluationAnswerData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(EvaluationAnswerData value) {
            this.value = value;
            return this;
        }

        public final EvaluationAnswerData.Builder getSystemSuggestedValue() {
            return systemSuggestedValue != null ? systemSuggestedValue.toBuilder() : null;
        }

        public final void setSystemSuggestedValue(EvaluationAnswerData.BuilderImpl systemSuggestedValue) {
            this.systemSuggestedValue = systemSuggestedValue != null ? systemSuggestedValue.build() : null;
        }

        @Override
        public final Builder systemSuggestedValue(EvaluationAnswerData systemSuggestedValue) {
            this.systemSuggestedValue = systemSuggestedValue;
            return this;
        }

        public final List<EvaluationSuggestedAnswer.Builder> getSuggestedAnswers() {
            List<EvaluationSuggestedAnswer.Builder> result = EvaluationSuggestedAnswersListCopier
                    .copyToBuilder(this.suggestedAnswers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestedAnswers(Collection<EvaluationSuggestedAnswer.BuilderImpl> suggestedAnswers) {
            this.suggestedAnswers = EvaluationSuggestedAnswersListCopier.copyFromBuilder(suggestedAnswers);
        }

        @Override
        public final Builder suggestedAnswers(Collection<EvaluationSuggestedAnswer> suggestedAnswers) {
            this.suggestedAnswers = EvaluationSuggestedAnswersListCopier.copy(suggestedAnswers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedAnswers(EvaluationSuggestedAnswer... suggestedAnswers) {
            suggestedAnswers(Arrays.asList(suggestedAnswers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestedAnswers(Consumer<EvaluationSuggestedAnswer.Builder>... suggestedAnswers) {
            suggestedAnswers(Stream.of(suggestedAnswers).map(c -> EvaluationSuggestedAnswer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EvaluationAnswerOutput build() {
            return new EvaluationAnswerOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
