/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateDataTableValuesResponse extends ConnectResponse implements
        ToCopyableBuilder<EvaluateDataTableValuesResponse.Builder, EvaluateDataTableValuesResponse> {
    private static final SdkField<List<DataTableEvaluatedValue>> VALUES_FIELD = SdkField
            .<List<DataTableEvaluatedValue>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(EvaluateDataTableValuesResponse::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataTableEvaluatedValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataTableEvaluatedValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(EvaluateDataTableValuesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VALUES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DataTableEvaluatedValue> values;

    private final String nextToken;

    private EvaluateDataTableValuesResponse(BuilderImpl builder) {
        super(builder);
        this.values = builder.values;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of evaluated values with their computed results, error information, and metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of evaluated values with their computed results, error information, and metadata.
     */
    public final List<DataTableEvaluatedValue> values() {
        return values;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataTableValuesResponse)) {
            return false;
        }
        EvaluateDataTableValuesResponse other = (EvaluateDataTableValuesResponse) obj;
        return hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateDataTableValuesResponse").add("Values", hasValues() ? values() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Values", VALUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateDataTableValuesResponse, T> g) {
        return obj -> g.apply((EvaluateDataTableValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateDataTableValuesResponse> {
        /**
         * <p>
         * A list of evaluated values with their computed results, error information, and metadata.
         * </p>
         * 
         * @param values
         *        A list of evaluated values with their computed results, error information, and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<DataTableEvaluatedValue> values);

        /**
         * <p>
         * A list of evaluated values with their computed results, error information, and metadata.
         * </p>
         * 
         * @param values
         *        A list of evaluated values with their computed results, error information, and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(DataTableEvaluatedValue... values);

        /**
         * <p>
         * A list of evaluated values with their computed results, error information, and metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.DataTableEvaluatedValue.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.DataTableEvaluatedValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.DataTableEvaluatedValue.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<DataTableEvaluatedValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.DataTableEvaluatedValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<DataTableEvaluatedValue>)
         */
        Builder values(Consumer<DataTableEvaluatedValue.Builder>... values);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<DataTableEvaluatedValue> values = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateDataTableValuesResponse model) {
            super(model);
            values(model.values);
            nextToken(model.nextToken);
        }

        public final List<DataTableEvaluatedValue.Builder> getValues() {
            List<DataTableEvaluatedValue.Builder> result = DataTableEvaluatedValueListCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<DataTableEvaluatedValue.BuilderImpl> values) {
            this.values = DataTableEvaluatedValueListCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<DataTableEvaluatedValue> values) {
            this.values = DataTableEvaluatedValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(DataTableEvaluatedValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<DataTableEvaluatedValue.Builder>... values) {
            values(Stream.of(values).map(c -> DataTableEvaluatedValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public EvaluateDataTableValuesResponse build() {
            return new EvaluateDataTableValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
