/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateEmailAddressAliasRequest extends ConnectRequest implements
        ToCopyableBuilder<DisassociateEmailAddressAliasRequest.Builder, DisassociateEmailAddressAliasRequest> {
    private static final SdkField<String> EMAIL_ADDRESS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddressId").getter(getter(DisassociateEmailAddressAliasRequest::emailAddressId))
            .setter(setter(Builder::emailAddressId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailAddressId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DisassociateEmailAddressAliasRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<AliasConfiguration> ALIAS_CONFIGURATION_FIELD = SdkField
            .<AliasConfiguration> builder(MarshallingType.SDK_POJO).memberName("AliasConfiguration")
            .getter(getter(DisassociateEmailAddressAliasRequest::aliasConfiguration)).setter(setter(Builder::aliasConfiguration))
            .constructor(AliasConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(DisassociateEmailAddressAliasRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_ID_FIELD,
            INSTANCE_ID_FIELD, ALIAS_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String emailAddressId;

    private final String instanceId;

    private final AliasConfiguration aliasConfiguration;

    private final String clientToken;

    private DisassociateEmailAddressAliasRequest(BuilderImpl builder) {
        super(builder);
        this.emailAddressId = builder.emailAddressId;
        this.instanceId = builder.instanceId;
        this.aliasConfiguration = builder.aliasConfiguration;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the email address.
     * </p>
     * 
     * @return The identifier of the email address.
     */
    public final String emailAddressId() {
        return emailAddressId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Configuration object that specifies which alias relationship to remove. The alias association must currently
     * exist between the primary email address and the specified alias email address.
     * </p>
     * 
     * @return Configuration object that specifies which alias relationship to remove. The alias association must
     *         currently exist between the primary email address and the specified alias email address.
     */
    public final AliasConfiguration aliasConfiguration() {
        return aliasConfiguration;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateEmailAddressAliasRequest)) {
            return false;
        }
        DisassociateEmailAddressAliasRequest other = (DisassociateEmailAddressAliasRequest) obj;
        return Objects.equals(emailAddressId(), other.emailAddressId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(aliasConfiguration(), other.aliasConfiguration())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateEmailAddressAliasRequest").add("EmailAddressId", emailAddressId())
                .add("InstanceId", instanceId()).add("AliasConfiguration", aliasConfiguration())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailAddressId":
            return Optional.ofNullable(clazz.cast(emailAddressId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AliasConfiguration":
            return Optional.ofNullable(clazz.cast(aliasConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmailAddressId", EMAIL_ADDRESS_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AliasConfiguration", ALIAS_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateEmailAddressAliasRequest, T> g) {
        return obj -> g.apply((DisassociateEmailAddressAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateEmailAddressAliasRequest> {
        /**
         * <p>
         * The identifier of the email address.
         * </p>
         * 
         * @param emailAddressId
         *        The identifier of the email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddressId(String emailAddressId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Configuration object that specifies which alias relationship to remove. The alias association must currently
         * exist between the primary email address and the specified alias email address.
         * </p>
         * 
         * @param aliasConfiguration
         *        Configuration object that specifies which alias relationship to remove. The alias association must
         *        currently exist between the primary email address and the specified alias email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasConfiguration(AliasConfiguration aliasConfiguration);

        /**
         * <p>
         * Configuration object that specifies which alias relationship to remove. The alias association must currently
         * exist between the primary email address and the specified alias email address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AliasConfiguration.Builder} avoiding the
         * need to create one manually via {@link AliasConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AliasConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #aliasConfiguration(AliasConfiguration)}.
         * 
         * @param aliasConfiguration
         *        a consumer that will call methods on {@link AliasConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliasConfiguration(AliasConfiguration)
         */
        default Builder aliasConfiguration(Consumer<AliasConfiguration.Builder> aliasConfiguration) {
            return aliasConfiguration(AliasConfiguration.builder().applyMutation(aliasConfiguration).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String emailAddressId;

        private String instanceId;

        private AliasConfiguration aliasConfiguration;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateEmailAddressAliasRequest model) {
            super(model);
            emailAddressId(model.emailAddressId);
            instanceId(model.instanceId);
            aliasConfiguration(model.aliasConfiguration);
            clientToken(model.clientToken);
        }

        public final String getEmailAddressId() {
            return emailAddressId;
        }

        public final void setEmailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
        }

        @Override
        public final Builder emailAddressId(String emailAddressId) {
            this.emailAddressId = emailAddressId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final AliasConfiguration.Builder getAliasConfiguration() {
            return aliasConfiguration != null ? aliasConfiguration.toBuilder() : null;
        }

        public final void setAliasConfiguration(AliasConfiguration.BuilderImpl aliasConfiguration) {
            this.aliasConfiguration = aliasConfiguration != null ? aliasConfiguration.build() : null;
        }

        @Override
        public final Builder aliasConfiguration(AliasConfiguration aliasConfiguration) {
            this.aliasConfiguration = aliasConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateEmailAddressAliasRequest build() {
            return new DisassociateEmailAddressAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
