/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataTableAttributeResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeDataTableAttributeResponse.Builder, DescribeDataTableAttributeResponse> {
    private static final SdkField<DataTableAttribute> ATTRIBUTE_FIELD = SdkField
            .<DataTableAttribute> builder(MarshallingType.SDK_POJO).memberName("Attribute")
            .getter(getter(DescribeDataTableAttributeResponse::attribute)).setter(setter(Builder::attribute))
            .constructor(DataTableAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataTableAttribute attribute;

    private DescribeDataTableAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
    }

    /**
     * <p>
     * The complete attribute information including configuration, validation rules, lock version, and metadata.
     * </p>
     * 
     * @return The complete attribute information including configuration, validation rules, lock version, and metadata.
     */
    public final DataTableAttribute attribute() {
        return attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataTableAttributeResponse)) {
            return false;
        }
        DescribeDataTableAttributeResponse other = (DescribeDataTableAttributeResponse) obj;
        return Objects.equals(attribute(), other.attribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataTableAttributeResponse").add("Attribute", attribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataTableAttributeResponse, T> g) {
        return obj -> g.apply((DescribeDataTableAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataTableAttributeResponse> {
        /**
         * <p>
         * The complete attribute information including configuration, validation rules, lock version, and metadata.
         * </p>
         * 
         * @param attribute
         *        The complete attribute information including configuration, validation rules, lock version, and
         *        metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(DataTableAttribute attribute);

        /**
         * <p>
         * The complete attribute information including configuration, validation rules, lock version, and metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableAttribute.Builder} avoiding the
         * need to create one manually via {@link DataTableAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableAttribute.Builder#build()} is called immediately and its
         * result is passed to {@link #attribute(DataTableAttribute)}.
         * 
         * @param attribute
         *        a consumer that will call methods on {@link DataTableAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attribute(DataTableAttribute)
         */
        default Builder attribute(Consumer<DataTableAttribute.Builder> attribute) {
            return attribute(DataTableAttribute.builder().applyMutation(attribute).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private DataTableAttribute attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataTableAttributeResponse model) {
            super(model);
            attribute(model.attribute);
        }

        public final DataTableAttribute.Builder getAttribute() {
            return attribute != null ? attribute.toBuilder() : null;
        }

        public final void setAttribute(DataTableAttribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        @Override
        public final Builder attribute(DataTableAttribute attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public DescribeDataTableAttributeResponse build() {
            return new DescribeDataTableAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
