/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataTableAttributeRequest extends ConnectRequest implements
        ToCopyableBuilder<DescribeDataTableAttributeRequest.Builder, DescribeDataTableAttributeRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DescribeDataTableAttributeRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> DATA_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataTableId").getter(getter(DescribeDataTableAttributeRequest::dataTableId))
            .setter(setter(Builder::dataTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataTableId").build()).build();

    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(DescribeDataTableAttributeRequest::attributeName))
            .setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AttributeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DATA_TABLE_ID_FIELD, ATTRIBUTE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String dataTableId;

    private final String attributeName;

    private DescribeDataTableAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.dataTableId = builder.dataTableId;
        this.attributeName = builder.attributeName;
    }

    /**
     * <p>
     * The unique identifier for the Amazon Connect instance.
     * </p>
     * 
     * @return The unique identifier for the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     * </p>
     * 
     * @return The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
     */
    public final String dataTableId() {
        return dataTableId;
    }

    /**
     * <p>
     * The name of the attribute to retrieve detailed information for.
     * </p>
     * 
     * @return The name of the attribute to retrieve detailed information for.
     */
    public final String attributeName() {
        return attributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(dataTableId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataTableAttributeRequest)) {
            return false;
        }
        DescribeDataTableAttributeRequest other = (DescribeDataTableAttributeRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(dataTableId(), other.dataTableId())
                && Objects.equals(attributeName(), other.attributeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataTableAttributeRequest").add("InstanceId", instanceId())
                .add("DataTableId", dataTableId()).add("AttributeName", attributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DataTableId":
            return Optional.ofNullable(clazz.cast(dataTableId()));
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DataTableId", DATA_TABLE_ID_FIELD);
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataTableAttributeRequest, T> g) {
        return obj -> g.apply((DescribeDataTableAttributeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDataTableAttributeRequest> {
        /**
         * <p>
         * The unique identifier for the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier for the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the data table. Must also accept the table ARN with or without a version alias.
         * </p>
         * 
         * @param dataTableId
         *        The unique identifier for the data table. Must also accept the table ARN with or without a version
         *        alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTableId(String dataTableId);

        /**
         * <p>
         * The name of the attribute to retrieve detailed information for.
         * </p>
         * 
         * @param attributeName
         *        The name of the attribute to retrieve detailed information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String dataTableId;

        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataTableAttributeRequest model) {
            super(model);
            instanceId(model.instanceId);
            dataTableId(model.dataTableId);
            attributeName(model.attributeName);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getDataTableId() {
            return dataTableId;
        }

        public final void setDataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
        }

        @Override
        public final Builder dataTableId(String dataTableId) {
            this.dataTableId = dataTableId;
            return this;
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDataTableAttributeRequest build() {
            return new DescribeDataTableAttributeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
