/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DataTableValueIdentifierListCopier {
    static List<DataTableValueIdentifier> copy(Collection<? extends DataTableValueIdentifier> dataTableValueIdentifierListParam) {
        List<DataTableValueIdentifier> list;
        if (dataTableValueIdentifierListParam == null || dataTableValueIdentifierListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataTableValueIdentifier> modifiableList = new ArrayList<>(dataTableValueIdentifierListParam.size());
            dataTableValueIdentifierListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataTableValueIdentifier> copyFromBuilder(
            Collection<? extends DataTableValueIdentifier.Builder> dataTableValueIdentifierListParam) {
        List<DataTableValueIdentifier> list;
        if (dataTableValueIdentifierListParam == null || dataTableValueIdentifierListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataTableValueIdentifier> modifiableList = new ArrayList<>(dataTableValueIdentifierListParam.size());
            dataTableValueIdentifierListParam.forEach(entry -> {
                DataTableValueIdentifier member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataTableValueIdentifier.Builder> copyToBuilder(
            Collection<? extends DataTableValueIdentifier> dataTableValueIdentifierListParam) {
        List<DataTableValueIdentifier.Builder> list;
        if (dataTableValueIdentifierListParam == null || dataTableValueIdentifierListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataTableValueIdentifier.Builder> modifiableList = new ArrayList<>(dataTableValueIdentifierListParam.size());
            dataTableValueIdentifierListParam.forEach(entry -> {
                DataTableValueIdentifier.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
