/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data table access control configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataTableAccessControlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataTableAccessControlConfiguration.Builder, DataTableAccessControlConfiguration> {
    private static final SdkField<PrimaryAttributeAccessControlConfigurationItem> PRIMARY_ATTRIBUTE_ACCESS_CONTROL_CONFIGURATION_FIELD = SdkField
            .<PrimaryAttributeAccessControlConfigurationItem> builder(MarshallingType.SDK_POJO)
            .memberName("PrimaryAttributeAccessControlConfiguration")
            .getter(getter(DataTableAccessControlConfiguration::primaryAttributeAccessControlConfiguration))
            .setter(setter(Builder::primaryAttributeAccessControlConfiguration))
            .constructor(PrimaryAttributeAccessControlConfigurationItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PrimaryAttributeAccessControlConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRIMARY_ATTRIBUTE_ACCESS_CONTROL_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PrimaryAttributeAccessControlConfigurationItem primaryAttributeAccessControlConfiguration;

    private DataTableAccessControlConfiguration(BuilderImpl builder) {
        this.primaryAttributeAccessControlConfiguration = builder.primaryAttributeAccessControlConfiguration;
    }

    /**
     * <p>
     * The configuration's primary attribute access control configuration.
     * </p>
     * 
     * @return The configuration's primary attribute access control configuration.
     */
    public final PrimaryAttributeAccessControlConfigurationItem primaryAttributeAccessControlConfiguration() {
        return primaryAttributeAccessControlConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryAttributeAccessControlConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataTableAccessControlConfiguration)) {
            return false;
        }
        DataTableAccessControlConfiguration other = (DataTableAccessControlConfiguration) obj;
        return Objects.equals(primaryAttributeAccessControlConfiguration(), other.primaryAttributeAccessControlConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataTableAccessControlConfiguration")
                .add("PrimaryAttributeAccessControlConfiguration", primaryAttributeAccessControlConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryAttributeAccessControlConfiguration":
            return Optional.ofNullable(clazz.cast(primaryAttributeAccessControlConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrimaryAttributeAccessControlConfiguration", PRIMARY_ATTRIBUTE_ACCESS_CONTROL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataTableAccessControlConfiguration, T> g) {
        return obj -> g.apply((DataTableAccessControlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataTableAccessControlConfiguration> {
        /**
         * <p>
         * The configuration's primary attribute access control configuration.
         * </p>
         * 
         * @param primaryAttributeAccessControlConfiguration
         *        The configuration's primary attribute access control configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryAttributeAccessControlConfiguration(
                PrimaryAttributeAccessControlConfigurationItem primaryAttributeAccessControlConfiguration);

        /**
         * <p>
         * The configuration's primary attribute access control configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PrimaryAttributeAccessControlConfigurationItem.Builder} avoiding the need to create one manually via
         * {@link PrimaryAttributeAccessControlConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrimaryAttributeAccessControlConfigurationItem.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #primaryAttributeAccessControlConfiguration(PrimaryAttributeAccessControlConfigurationItem)}.
         * 
         * @param primaryAttributeAccessControlConfiguration
         *        a consumer that will call methods on {@link PrimaryAttributeAccessControlConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryAttributeAccessControlConfiguration(PrimaryAttributeAccessControlConfigurationItem)
         */
        default Builder primaryAttributeAccessControlConfiguration(
                Consumer<PrimaryAttributeAccessControlConfigurationItem.Builder> primaryAttributeAccessControlConfiguration) {
            return primaryAttributeAccessControlConfiguration(PrimaryAttributeAccessControlConfigurationItem.builder()
                    .applyMutation(primaryAttributeAccessControlConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PrimaryAttributeAccessControlConfigurationItem primaryAttributeAccessControlConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataTableAccessControlConfiguration model) {
            primaryAttributeAccessControlConfiguration(model.primaryAttributeAccessControlConfiguration);
        }

        public final PrimaryAttributeAccessControlConfigurationItem.Builder getPrimaryAttributeAccessControlConfiguration() {
            return primaryAttributeAccessControlConfiguration != null ? primaryAttributeAccessControlConfiguration.toBuilder()
                    : null;
        }

        public final void setPrimaryAttributeAccessControlConfiguration(
                PrimaryAttributeAccessControlConfigurationItem.BuilderImpl primaryAttributeAccessControlConfiguration) {
            this.primaryAttributeAccessControlConfiguration = primaryAttributeAccessControlConfiguration != null ? primaryAttributeAccessControlConfiguration
                    .build() : null;
        }

        @Override
        public final Builder primaryAttributeAccessControlConfiguration(
                PrimaryAttributeAccessControlConfigurationItem primaryAttributeAccessControlConfiguration) {
            this.primaryAttributeAccessControlConfiguration = primaryAttributeAccessControlConfiguration;
            return this;
        }

        @Override
        public DataTableAccessControlConfiguration build() {
            return new DataTableAccessControlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
