/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataTableAttributeResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateDataTableAttributeResponse.Builder, CreateDataTableAttributeResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataTableAttributeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ATTRIBUTE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeId").getter(getter(CreateDataTableAttributeResponse::attributeId))
            .setter(setter(Builder::attributeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeId").build()).build();

    private static final SdkField<DataTableLockVersion> LOCK_VERSION_FIELD = SdkField
            .<DataTableLockVersion> builder(MarshallingType.SDK_POJO).memberName("LockVersion")
            .getter(getter(CreateDataTableAttributeResponse::lockVersion)).setter(setter(Builder::lockVersion))
            .constructor(DataTableLockVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LockVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ATTRIBUTE_ID_FIELD, LOCK_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String attributeId;

    private final DataTableLockVersion lockVersion;

    private CreateDataTableAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.attributeId = builder.attributeId;
        this.lockVersion = builder.lockVersion;
    }

    /**
     * <p>
     * The name of the created attribute since it also serves as the identifier. This could be different than the
     * parameter passed in since it will be trimmed for whitespace.
     * </p>
     * 
     * @return The name of the created attribute since it also serves as the identifier. This could be different than
     *         the parameter passed in since it will be trimmed for whitespace.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier assigned to the created attribute.
     * </p>
     * 
     * @return The unique identifier assigned to the created attribute.
     */
    public final String attributeId() {
        return attributeId;
    }

    /**
     * <p>
     * The lock version information for the data table and attribute, used for optimistic locking and versioning.
     * </p>
     * 
     * @return The lock version information for the data table and attribute, used for optimistic locking and
     *         versioning.
     */
    public final DataTableLockVersion lockVersion() {
        return lockVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(attributeId());
        hashCode = 31 * hashCode + Objects.hashCode(lockVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataTableAttributeResponse)) {
            return false;
        }
        CreateDataTableAttributeResponse other = (CreateDataTableAttributeResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(attributeId(), other.attributeId())
                && Objects.equals(lockVersion(), other.lockVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataTableAttributeResponse").add("Name", name()).add("AttributeId", attributeId())
                .add("LockVersion", lockVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AttributeId":
            return Optional.ofNullable(clazz.cast(attributeId()));
        case "LockVersion":
            return Optional.ofNullable(clazz.cast(lockVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("AttributeId", ATTRIBUTE_ID_FIELD);
        map.put("LockVersion", LOCK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataTableAttributeResponse, T> g) {
        return obj -> g.apply((CreateDataTableAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataTableAttributeResponse> {
        /**
         * <p>
         * The name of the created attribute since it also serves as the identifier. This could be different than the
         * parameter passed in since it will be trimmed for whitespace.
         * </p>
         * 
         * @param name
         *        The name of the created attribute since it also serves as the identifier. This could be different than
         *        the parameter passed in since it will be trimmed for whitespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier assigned to the created attribute.
         * </p>
         * 
         * @param attributeId
         *        The unique identifier assigned to the created attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeId(String attributeId);

        /**
         * <p>
         * The lock version information for the data table and attribute, used for optimistic locking and versioning.
         * </p>
         * 
         * @param lockVersion
         *        The lock version information for the data table and attribute, used for optimistic locking and
         *        versioning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lockVersion(DataTableLockVersion lockVersion);

        /**
         * <p>
         * The lock version information for the data table and attribute, used for optimistic locking and versioning.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataTableLockVersion.Builder} avoiding
         * the need to create one manually via {@link DataTableLockVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataTableLockVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #lockVersion(DataTableLockVersion)}.
         * 
         * @param lockVersion
         *        a consumer that will call methods on {@link DataTableLockVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lockVersion(DataTableLockVersion)
         */
        default Builder lockVersion(Consumer<DataTableLockVersion.Builder> lockVersion) {
            return lockVersion(DataTableLockVersion.builder().applyMutation(lockVersion).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String name;

        private String attributeId;

        private DataTableLockVersion lockVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataTableAttributeResponse model) {
            super(model);
            name(model.name);
            attributeId(model.attributeId);
            lockVersion(model.lockVersion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAttributeId() {
            return attributeId;
        }

        public final void setAttributeId(String attributeId) {
            this.attributeId = attributeId;
        }

        @Override
        public final Builder attributeId(String attributeId) {
            this.attributeId = attributeId;
            return this;
        }

        public final DataTableLockVersion.Builder getLockVersion() {
            return lockVersion != null ? lockVersion.toBuilder() : null;
        }

        public final void setLockVersion(DataTableLockVersion.BuilderImpl lockVersion) {
            this.lockVersion = lockVersion != null ? lockVersion.build() : null;
        }

        @Override
        public final Builder lockVersion(DataTableLockVersion lockVersion) {
            this.lockVersion = lockVersion;
            return this;
        }

        @Override
        public CreateDataTableAttributeResponse build() {
            return new CreateDataTableAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
