/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowModuleAliasInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowModuleAliasInfo.Builder, ContactFlowModuleAliasInfo> {
    private static final SdkField<String> CONTACT_FLOW_MODULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleId").getter(getter(ContactFlowModuleAliasInfo::contactFlowModuleId))
            .setter(setter(Builder::contactFlowModuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowModuleId").build())
            .build();

    private static final SdkField<String> CONTACT_FLOW_MODULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleArn").getter(getter(ContactFlowModuleAliasInfo::contactFlowModuleArn))
            .setter(setter(Builder::contactFlowModuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowModuleArn").build())
            .build();

    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasId").getter(getter(ContactFlowModuleAliasInfo::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(ContactFlowModuleAliasInfo::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContactFlowModuleAliasInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ContactFlowModuleAliasInfo::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(ContactFlowModuleAliasInfo::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ContactFlowModuleAliasInfo::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_MODULE_ID_FIELD,
            CONTACT_FLOW_MODULE_ARN_FIELD, ALIAS_ID_FIELD, VERSION_FIELD, NAME_FIELD, DESCRIPTION_FIELD,
            LAST_MODIFIED_REGION_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactFlowModuleId;

    private final String contactFlowModuleArn;

    private final String aliasId;

    private final Long version;

    private final String name;

    private final String description;

    private final String lastModifiedRegion;

    private final Instant lastModifiedTime;

    private ContactFlowModuleAliasInfo(BuilderImpl builder) {
        this.contactFlowModuleId = builder.contactFlowModuleId;
        this.contactFlowModuleArn = builder.contactFlowModuleArn;
        this.aliasId = builder.aliasId;
        this.version = builder.version;
        this.name = builder.name;
        this.description = builder.description;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */
    public final String contactFlowModuleId() {
        return contactFlowModuleId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow module.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow module.
     */
    public final String contactFlowModuleArn() {
        return contactFlowModuleArn;
    }

    /**
     * <p>
     * The identifier of the alias.
     * </p>
     * 
     * @return The identifier of the alias.
     */
    public final String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * The version of the flow module.
     * </p>
     * 
     * @return The version of the flow module.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The name of the alias.
     * </p>
     * 
     * @return The name of the alias.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the alias.
     * </p>
     * 
     * @return The description of the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowModuleAliasInfo)) {
            return false;
        }
        ContactFlowModuleAliasInfo other = (ContactFlowModuleAliasInfo) obj;
        return Objects.equals(contactFlowModuleId(), other.contactFlowModuleId())
                && Objects.equals(contactFlowModuleArn(), other.contactFlowModuleArn())
                && Objects.equals(aliasId(), other.aliasId()) && Objects.equals(version(), other.version())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowModuleAliasInfo").add("ContactFlowModuleId", contactFlowModuleId())
                .add("ContactFlowModuleArn", contactFlowModuleArn()).add("AliasId", aliasId()).add("Version", version())
                .add("Name", name()).add("Description", description()).add("LastModifiedRegion", lastModifiedRegion())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactFlowModuleId":
            return Optional.ofNullable(clazz.cast(contactFlowModuleId()));
        case "ContactFlowModuleArn":
            return Optional.ofNullable(clazz.cast(contactFlowModuleArn()));
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactFlowModuleId", CONTACT_FLOW_MODULE_ID_FIELD);
        map.put("ContactFlowModuleArn", CONTACT_FLOW_MODULE_ARN_FIELD);
        map.put("AliasId", ALIAS_ID_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowModuleAliasInfo, T> g) {
        return obj -> g.apply((ContactFlowModuleAliasInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowModuleAliasInfo> {
        /**
         * <p>
         * The identifier of the flow module.
         * </p>
         * 
         * @param contactFlowModuleId
         *        The identifier of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleId(String contactFlowModuleId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow module.
         * </p>
         * 
         * @param contactFlowModuleArn
         *        The Amazon Resource Name (ARN) of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleArn(String contactFlowModuleArn);

        /**
         * <p>
         * The identifier of the alias.
         * </p>
         * 
         * @param aliasId
         *        The identifier of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * The version of the flow module.
         * </p>
         * 
         * @param version
         *        The version of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The name of the alias.
         * </p>
         * 
         * @param name
         *        The name of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the alias.
         * </p>
         * 
         * @param description
         *        The description of the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String contactFlowModuleId;

        private String contactFlowModuleArn;

        private String aliasId;

        private Long version;

        private String name;

        private String description;

        private String lastModifiedRegion;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowModuleAliasInfo model) {
            contactFlowModuleId(model.contactFlowModuleId);
            contactFlowModuleArn(model.contactFlowModuleArn);
            aliasId(model.aliasId);
            version(model.version);
            name(model.name);
            description(model.description);
            lastModifiedRegion(model.lastModifiedRegion);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getContactFlowModuleId() {
            return contactFlowModuleId;
        }

        public final void setContactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
        }

        @Override
        public final Builder contactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
            return this;
        }

        public final String getContactFlowModuleArn() {
            return contactFlowModuleArn;
        }

        public final void setContactFlowModuleArn(String contactFlowModuleArn) {
            this.contactFlowModuleArn = contactFlowModuleArn;
        }

        @Override
        public final Builder contactFlowModuleArn(String contactFlowModuleArn) {
            this.contactFlowModuleArn = contactFlowModuleArn;
            return this;
        }

        public final String getAliasId() {
            return aliasId;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ContactFlowModuleAliasInfo build() {
            return new ContactFlowModuleAliasInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
