/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter for contact flow attributes with multiple condition types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowAttributeFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowAttributeFilter.Builder, ContactFlowAttributeFilter> {
    private static final SdkField<List<ContactFlowAttributeAndCondition>> OR_CONDITIONS_FIELD = SdkField
            .<List<ContactFlowAttributeAndCondition>> builder(MarshallingType.LIST)
            .memberName("OrConditions")
            .getter(getter(ContactFlowAttributeFilter::orConditions))
            .setter(setter(Builder::orConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactFlowAttributeAndCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactFlowAttributeAndCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ContactFlowAttributeAndCondition> AND_CONDITION_FIELD = SdkField
            .<ContactFlowAttributeAndCondition> builder(MarshallingType.SDK_POJO).memberName("AndCondition")
            .getter(getter(ContactFlowAttributeFilter::andCondition)).setter(setter(Builder::andCondition))
            .constructor(ContactFlowAttributeAndCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndCondition").build()).build();

    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
            .memberName("TagCondition").getter(getter(ContactFlowAttributeFilter::tagCondition))
            .setter(setter(Builder::tagCondition)).constructor(TagCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagCondition").build()).build();

    private static final SdkField<ContactFlowTypeCondition> CONTACT_FLOW_TYPE_CONDITION_FIELD = SdkField
            .<ContactFlowTypeCondition> builder(MarshallingType.SDK_POJO).memberName("ContactFlowTypeCondition")
            .getter(getter(ContactFlowAttributeFilter::contactFlowTypeCondition))
            .setter(setter(Builder::contactFlowTypeCondition)).constructor(ContactFlowTypeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowTypeCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD,
            AND_CONDITION_FIELD, TAG_CONDITION_FIELD, CONTACT_FLOW_TYPE_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ContactFlowAttributeAndCondition> orConditions;

    private final ContactFlowAttributeAndCondition andCondition;

    private final TagCondition tagCondition;

    private final ContactFlowTypeCondition contactFlowTypeCondition;

    private ContactFlowAttributeFilter(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andCondition = builder.andCondition;
        this.tagCondition = builder.tagCondition;
        this.contactFlowTypeCondition = builder.contactFlowTypeCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrConditions() {
        return orConditions != null && !(orConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an OR condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an OR condition.
     */
    public final List<ContactFlowAttributeAndCondition> orConditions() {
        return orConditions;
    }

    /**
     * <p>
     * A list of conditions which would be applied together with a AND condition.
     * </p>
     * 
     * @return A list of conditions which would be applied together with a AND condition.
     */
    public final ContactFlowAttributeAndCondition andCondition() {
        return andCondition;
    }

    /**
     * Returns the value of the TagCondition property for this object.
     * 
     * @return The value of the TagCondition property for this object.
     */
    public final TagCondition tagCondition() {
        return tagCondition;
    }

    /**
     * <p>
     * Contact flow type condition within attribute filter.
     * </p>
     * 
     * @return Contact flow type condition within attribute filter.
     */
    public final ContactFlowTypeCondition contactFlowTypeCondition() {
        return contactFlowTypeCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOrConditions() ? orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(andCondition());
        hashCode = 31 * hashCode + Objects.hashCode(tagCondition());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowTypeCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowAttributeFilter)) {
            return false;
        }
        ContactFlowAttributeFilter other = (ContactFlowAttributeFilter) obj;
        return hasOrConditions() == other.hasOrConditions() && Objects.equals(orConditions(), other.orConditions())
                && Objects.equals(andCondition(), other.andCondition()) && Objects.equals(tagCondition(), other.tagCondition())
                && Objects.equals(contactFlowTypeCondition(), other.contactFlowTypeCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowAttributeFilter").add("OrConditions", hasOrConditions() ? orConditions() : null)
                .add("AndCondition", andCondition()).add("TagCondition", tagCondition())
                .add("ContactFlowTypeCondition", contactFlowTypeCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrConditions":
            return Optional.ofNullable(clazz.cast(orConditions()));
        case "AndCondition":
            return Optional.ofNullable(clazz.cast(andCondition()));
        case "TagCondition":
            return Optional.ofNullable(clazz.cast(tagCondition()));
        case "ContactFlowTypeCondition":
            return Optional.ofNullable(clazz.cast(contactFlowTypeCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndCondition", AND_CONDITION_FIELD);
        map.put("TagCondition", TAG_CONDITION_FIELD);
        map.put("ContactFlowTypeCondition", CONTACT_FLOW_TYPE_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowAttributeFilter, T> g) {
        return obj -> g.apply((ContactFlowAttributeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowAttributeFilter> {
        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(Collection<ContactFlowAttributeAndCondition> orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * 
         * @param orConditions
         *        A list of conditions which would be applied together with an OR condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orConditions(ContactFlowAttributeAndCondition... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an OR condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowAttributeAndCondition.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowAttributeAndCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ContactFlowAttributeAndCondition.Builder#build()} is
         * called immediately and its result is passed to {@link #orConditions(List<ContactFlowAttributeAndCondition>)}.
         * 
         * @param orConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ContactFlowAttributeAndCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orConditions(java.util.Collection<ContactFlowAttributeAndCondition>)
         */
        Builder orConditions(Consumer<ContactFlowAttributeAndCondition.Builder>... orConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with a AND condition.
         * </p>
         * 
         * @param andCondition
         *        A list of conditions which would be applied together with a AND condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andCondition(ContactFlowAttributeAndCondition andCondition);

        /**
         * <p>
         * A list of conditions which would be applied together with a AND condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFlowAttributeAndCondition.Builder}
         * avoiding the need to create one manually via {@link ContactFlowAttributeAndCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFlowAttributeAndCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #andCondition(ContactFlowAttributeAndCondition)}.
         * 
         * @param andCondition
         *        a consumer that will call methods on {@link ContactFlowAttributeAndCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andCondition(ContactFlowAttributeAndCondition)
         */
        default Builder andCondition(Consumer<ContactFlowAttributeAndCondition.Builder> andCondition) {
            return andCondition(ContactFlowAttributeAndCondition.builder().applyMutation(andCondition).build());
        }

        /**
         * Sets the value of the TagCondition property for this object.
         *
         * @param tagCondition
         *        The new value for the TagCondition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagCondition(TagCondition tagCondition);

        /**
         * Sets the value of the TagCondition property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TagCondition.Builder} avoiding the need
         * to create one manually via {@link TagCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #tagCondition(TagCondition)}.
         * 
         * @param tagCondition
         *        a consumer that will call methods on {@link TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagCondition(TagCondition)
         */
        default Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return tagCondition(TagCondition.builder().applyMutation(tagCondition).build());
        }

        /**
         * <p>
         * Contact flow type condition within attribute filter.
         * </p>
         * 
         * @param contactFlowTypeCondition
         *        Contact flow type condition within attribute filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowTypeCondition(ContactFlowTypeCondition contactFlowTypeCondition);

        /**
         * <p>
         * Contact flow type condition within attribute filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFlowTypeCondition.Builder}
         * avoiding the need to create one manually via {@link ContactFlowTypeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFlowTypeCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #contactFlowTypeCondition(ContactFlowTypeCondition)}.
         * 
         * @param contactFlowTypeCondition
         *        a consumer that will call methods on {@link ContactFlowTypeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactFlowTypeCondition(ContactFlowTypeCondition)
         */
        default Builder contactFlowTypeCondition(Consumer<ContactFlowTypeCondition.Builder> contactFlowTypeCondition) {
            return contactFlowTypeCondition(ContactFlowTypeCondition.builder().applyMutation(contactFlowTypeCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<ContactFlowAttributeAndCondition> orConditions = DefaultSdkAutoConstructList.getInstance();

        private ContactFlowAttributeAndCondition andCondition;

        private TagCondition tagCondition;

        private ContactFlowTypeCondition contactFlowTypeCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowAttributeFilter model) {
            orConditions(model.orConditions);
            andCondition(model.andCondition);
            tagCondition(model.tagCondition);
            contactFlowTypeCondition(model.contactFlowTypeCondition);
        }

        public final List<ContactFlowAttributeAndCondition.Builder> getOrConditions() {
            List<ContactFlowAttributeAndCondition.Builder> result = ContactFlowAttributeOrConditionListCopier
                    .copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<ContactFlowAttributeAndCondition.BuilderImpl> orConditions) {
            this.orConditions = ContactFlowAttributeOrConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<ContactFlowAttributeAndCondition> orConditions) {
            this.orConditions = ContactFlowAttributeOrConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(ContactFlowAttributeAndCondition... orConditions) {
            orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<ContactFlowAttributeAndCondition.Builder>... orConditions) {
            orConditions(Stream.of(orConditions).map(c -> ContactFlowAttributeAndCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ContactFlowAttributeAndCondition.Builder getAndCondition() {
            return andCondition != null ? andCondition.toBuilder() : null;
        }

        public final void setAndCondition(ContactFlowAttributeAndCondition.BuilderImpl andCondition) {
            this.andCondition = andCondition != null ? andCondition.build() : null;
        }

        @Override
        public final Builder andCondition(ContactFlowAttributeAndCondition andCondition) {
            this.andCondition = andCondition;
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return tagCondition != null ? tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            this.tagCondition = tagCondition;
            return this;
        }

        public final ContactFlowTypeCondition.Builder getContactFlowTypeCondition() {
            return contactFlowTypeCondition != null ? contactFlowTypeCondition.toBuilder() : null;
        }

        public final void setContactFlowTypeCondition(ContactFlowTypeCondition.BuilderImpl contactFlowTypeCondition) {
            this.contactFlowTypeCondition = contactFlowTypeCondition != null ? contactFlowTypeCondition.build() : null;
        }

        @Override
        public final Builder contactFlowTypeCondition(ContactFlowTypeCondition contactFlowTypeCondition) {
            this.contactFlowTypeCondition = contactFlowTypeCondition;
            return this;
        }

        @Override
        public ContactFlowAttributeFilter build() {
            return new ContactFlowAttributeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
