/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of conditions which would be applied together with an AND condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlowAttributeAndCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactFlowAttributeAndCondition.Builder, ContactFlowAttributeAndCondition> {
    private static final SdkField<List<TagCondition>> TAG_CONDITIONS_FIELD = SdkField
            .<List<TagCondition>> builder(MarshallingType.LIST)
            .memberName("TagConditions")
            .getter(getter(ContactFlowAttributeAndCondition::tagConditions))
            .setter(setter(Builder::tagConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ContactFlowTypeCondition> CONTACT_FLOW_TYPE_CONDITION_FIELD = SdkField
            .<ContactFlowTypeCondition> builder(MarshallingType.SDK_POJO).memberName("ContactFlowTypeCondition")
            .getter(getter(ContactFlowAttributeAndCondition::contactFlowTypeCondition))
            .setter(setter(Builder::contactFlowTypeCondition)).constructor(ContactFlowTypeCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowTypeCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_CONDITIONS_FIELD,
            CONTACT_FLOW_TYPE_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TagCondition> tagConditions;

    private final ContactFlowTypeCondition contactFlowTypeCondition;

    private ContactFlowAttributeAndCondition(BuilderImpl builder) {
        this.tagConditions = builder.tagConditions;
        this.contactFlowTypeCondition = builder.contactFlowTypeCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTagConditions() {
        return tagConditions != null && !(tagConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tag-based conditions for contact flow filtering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagConditions} method.
     * </p>
     * 
     * @return Tag-based conditions for contact flow filtering.
     */
    public final List<TagCondition> tagConditions() {
        return tagConditions;
    }

    /**
     * <p>
     * Contact flow type condition.
     * </p>
     * 
     * @return Contact flow type condition.
     */
    public final ContactFlowTypeCondition contactFlowTypeCondition() {
        return contactFlowTypeCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTagConditions() ? tagConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowTypeCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowAttributeAndCondition)) {
            return false;
        }
        ContactFlowAttributeAndCondition other = (ContactFlowAttributeAndCondition) obj;
        return hasTagConditions() == other.hasTagConditions() && Objects.equals(tagConditions(), other.tagConditions())
                && Objects.equals(contactFlowTypeCondition(), other.contactFlowTypeCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlowAttributeAndCondition")
                .add("TagConditions", hasTagConditions() ? tagConditions() : null)
                .add("ContactFlowTypeCondition", contactFlowTypeCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagConditions":
            return Optional.ofNullable(clazz.cast(tagConditions()));
        case "ContactFlowTypeCondition":
            return Optional.ofNullable(clazz.cast(contactFlowTypeCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TagConditions", TAG_CONDITIONS_FIELD);
        map.put("ContactFlowTypeCondition", CONTACT_FLOW_TYPE_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowAttributeAndCondition, T> g) {
        return obj -> g.apply((ContactFlowAttributeAndCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlowAttributeAndCondition> {
        /**
         * <p>
         * Tag-based conditions for contact flow filtering.
         * </p>
         * 
         * @param tagConditions
         *        Tag-based conditions for contact flow filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagConditions(Collection<TagCondition> tagConditions);

        /**
         * <p>
         * Tag-based conditions for contact flow filtering.
         * </p>
         * 
         * @param tagConditions
         *        Tag-based conditions for contact flow filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagConditions(TagCondition... tagConditions);

        /**
         * <p>
         * Tag-based conditions for contact flow filtering.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.TagCondition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.TagCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.TagCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #tagConditions(List<TagCondition>)}.
         * 
         * @param tagConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagConditions(java.util.Collection<TagCondition>)
         */
        Builder tagConditions(Consumer<TagCondition.Builder>... tagConditions);

        /**
         * <p>
         * Contact flow type condition.
         * </p>
         * 
         * @param contactFlowTypeCondition
         *        Contact flow type condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowTypeCondition(ContactFlowTypeCondition contactFlowTypeCondition);

        /**
         * <p>
         * Contact flow type condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFlowTypeCondition.Builder}
         * avoiding the need to create one manually via {@link ContactFlowTypeCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFlowTypeCondition.Builder#build()} is called immediately
         * and its result is passed to {@link #contactFlowTypeCondition(ContactFlowTypeCondition)}.
         * 
         * @param contactFlowTypeCondition
         *        a consumer that will call methods on {@link ContactFlowTypeCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactFlowTypeCondition(ContactFlowTypeCondition)
         */
        default Builder contactFlowTypeCondition(Consumer<ContactFlowTypeCondition.Builder> contactFlowTypeCondition) {
            return contactFlowTypeCondition(ContactFlowTypeCondition.builder().applyMutation(contactFlowTypeCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<TagCondition> tagConditions = DefaultSdkAutoConstructList.getInstance();

        private ContactFlowTypeCondition contactFlowTypeCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowAttributeAndCondition model) {
            tagConditions(model.tagConditions);
            contactFlowTypeCondition(model.contactFlowTypeCondition);
        }

        public final List<TagCondition.Builder> getTagConditions() {
            List<TagCondition.Builder> result = TagAndConditionListCopier.copyToBuilder(this.tagConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagConditions(Collection<TagCondition.BuilderImpl> tagConditions) {
            this.tagConditions = TagAndConditionListCopier.copyFromBuilder(tagConditions);
        }

        @Override
        public final Builder tagConditions(Collection<TagCondition> tagConditions) {
            this.tagConditions = TagAndConditionListCopier.copy(tagConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagConditions(TagCondition... tagConditions) {
            tagConditions(Arrays.asList(tagConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagConditions(Consumer<TagCondition.Builder>... tagConditions) {
            tagConditions(Stream.of(tagConditions).map(c -> TagCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ContactFlowTypeCondition.Builder getContactFlowTypeCondition() {
            return contactFlowTypeCondition != null ? contactFlowTypeCondition.toBuilder() : null;
        }

        public final void setContactFlowTypeCondition(ContactFlowTypeCondition.BuilderImpl contactFlowTypeCondition) {
            this.contactFlowTypeCondition = contactFlowTypeCondition != null ? contactFlowTypeCondition.build() : null;
        }

        @Override
        public final Builder contactFlowTypeCondition(ContactFlowTypeCondition contactFlowTypeCondition) {
            this.contactFlowTypeCondition = contactFlowTypeCondition;
            return this;
        }

        @Override
        public ContactFlowAttributeAndCondition build() {
            return new ContactFlowAttributeAndCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
