/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactFlow implements SdkPojo, Serializable, ToCopyableBuilder<ContactFlow.Builder, ContactFlow> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ContactFlow::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ContactFlow::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ContactFlow::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ContactFlow::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ContactFlow::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ContactFlow::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ContactFlow::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(ContactFlow::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(ContactFlow::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> FLOW_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowContentSha256").getter(getter(ContactFlow::flowContentSha256))
            .setter(setter(Builder::flowContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowContentSha256").build()).build();

    private static final SdkField<Long> VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Version")
            .getter(getter(ContactFlow::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(ContactFlow::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ContactFlow::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(ContactFlow::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, TYPE_FIELD, STATE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CONTENT_FIELD, TAGS_FIELD,
            FLOW_CONTENT_SHA256_FIELD, VERSION_FIELD, VERSION_DESCRIPTION_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_MODIFIED_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String type;

    private final String state;

    private final String status;

    private final String description;

    private final String content;

    private final Map<String, String> tags;

    private final String flowContentSha256;

    private final Long version;

    private final String versionDescription;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private ContactFlow(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.type = builder.type;
        this.state = builder.state;
        this.status = builder.status;
        this.description = builder.description;
        this.content = builder.content;
        this.tags = builder.tags;
        this.flowContentSha256 = builder.flowContentSha256;
        this.version = builder.version;
        this.versionDescription = builder.versionDescription;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier of the flow.
     * </p>
     * 
     * @return The identifier of the flow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the flow.
     * </p>
     * 
     * @return The name of the flow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the flow. For descriptions of the available types, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a
     * flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the flow. For descriptions of the available types, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types"
     *         >Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
     * @see ContactFlowType
     */
    public final ContactFlowType type() {
        return ContactFlowType.fromValue(type);
    }

    /**
     * <p>
     * The type of the flow. For descriptions of the available types, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a
     * flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactFlowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the flow. For descriptions of the available types, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types"
     *         >Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
     * @see ContactFlowType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ContactFlowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowState
     */
    public final ContactFlowState state() {
        return ContactFlowState.fromValue(state);
    }

    /**
     * <p>
     * The type of flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ContactFlowState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The type of flow.
     * @see ContactFlowState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContactFlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow.
     * @see ContactFlowStatus
     */
    public final ContactFlowStatus status() {
        return ContactFlowStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ContactFlowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the flow.
     * @see ContactFlowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The description of the flow.
     * </p>
     * 
     * @return The description of the flow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The JSON string that represents the content of the flow. For an example, see <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon
     * Connect Flow language</a>.
     * </p>
     * <p>
     * Length Constraints: Minimum length of 1. Maximum length of 256000.
     * </p>
     * 
     * @return The JSON string that represents the content of the flow. For an example, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in
     *         Amazon Connect Flow language</a>. </p>
     *         <p>
     *         Length Constraints: Minimum length of 1. Maximum length of 256000.
     */
    public final String content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates the checksum value of the flow content.
     * </p>
     * 
     * @return Indicates the checksum value of the flow content.
     */
    public final String flowContentSha256() {
        return flowContentSha256;
    }

    /**
     * <p>
     * The identifier of the flow version.
     * </p>
     * 
     * @return The identifier of the flow version.
     */
    public final Long version() {
        return version;
    }

    /**
     * <p>
     * The description of the flow version.
     * </p>
     * 
     * @return The description of the flow version.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * The time at which the flow was last modified.
     * </p>
     * 
     * @return The time at which the flow was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The region in which the flow was last modified
     * </p>
     * 
     * @return The region in which the flow was last modified
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(flowContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlow)) {
            return false;
        }
        ContactFlow other = (ContactFlow) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(description(), other.description())
                && Objects.equals(content(), other.content()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(flowContentSha256(), other.flowContentSha256())
                && Objects.equals(version(), other.version()) && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactFlow").add("Arn", arn()).add("Id", id()).add("Name", name()).add("Type", typeAsString())
                .add("State", stateAsString()).add("Status", statusAsString()).add("Description", description())
                .add("Content", content()).add("Tags", hasTags() ? tags() : null).add("FlowContentSha256", flowContentSha256())
                .add("Version", version()).add("VersionDescription", versionDescription())
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FlowContentSha256":
            return Optional.ofNullable(clazz.cast(flowContentSha256()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("FlowContentSha256", FLOW_CONTENT_SHA256_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlow, T> g) {
        return obj -> g.apply((ContactFlow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactFlow> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier of the flow.
         * </p>
         * 
         * @param id
         *        The identifier of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the flow.
         * </p>
         * 
         * @param name
         *        The name of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the flow. For descriptions of the available types, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types"
         * >Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of the flow. For descriptions of the available types, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types"
         *        >Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the flow. For descriptions of the available types, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types"
         * >Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param type
         *        The type of the flow. For descriptions of the available types, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types"
         *        >Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @see ContactFlowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowType
         */
        Builder type(ContactFlowType type);

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param state
         *        The type of flow.
         * @see ContactFlowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowState
         */
        Builder state(String state);

        /**
         * <p>
         * The type of flow.
         * </p>
         * 
         * @param state
         *        The type of flow.
         * @see ContactFlowState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowState
         */
        Builder state(ContactFlowState state);

        /**
         * <p>
         * The status of the flow.
         * </p>
         * 
         * @param status
         *        The status of the flow.
         * @see ContactFlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the flow.
         * </p>
         * 
         * @param status
         *        The status of the flow.
         * @see ContactFlowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowStatus
         */
        Builder status(ContactFlowStatus status);

        /**
         * <p>
         * The description of the flow.
         * </p>
         * 
         * @param description
         *        The description of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The JSON string that represents the content of the flow. For an example, see <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in
         * Amazon Connect Flow language</a>.
         * </p>
         * <p>
         * Length Constraints: Minimum length of 1. Maximum length of 256000.
         * </p>
         * 
         * @param content
         *        The JSON string that represents the content of the flow. For an example, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow
         *        in Amazon Connect Flow language</a>. </p>
         *        <p>
         *        Length Constraints: Minimum length of 1. Maximum length of 256000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Indicates the checksum value of the flow content.
         * </p>
         * 
         * @param flowContentSha256
         *        Indicates the checksum value of the flow content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowContentSha256(String flowContentSha256);

        /**
         * <p>
         * The identifier of the flow version.
         * </p>
         * 
         * @param version
         *        The identifier of the flow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Long version);

        /**
         * <p>
         * The description of the flow version.
         * </p>
         * 
         * @param versionDescription
         *        The description of the flow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * The time at which the flow was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time at which the flow was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The region in which the flow was last modified
         * </p>
         * 
         * @param lastModifiedRegion
         *        The region in which the flow was last modified
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String type;

        private String state;

        private String status;

        private String description;

        private String content;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String flowContentSha256;

        private Long version;

        private String versionDescription;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlow model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            type(model.type);
            state(model.state);
            status(model.status);
            description(model.description);
            content(model.content);
            tags(model.tags);
            flowContentSha256(model.flowContentSha256);
            version(model.version);
            versionDescription(model.versionDescription);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContactFlowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ContactFlowState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ContactFlowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getFlowContentSha256() {
            return flowContentSha256;
        }

        public final void setFlowContentSha256(String flowContentSha256) {
            this.flowContentSha256 = flowContentSha256;
        }

        @Override
        public final Builder flowContentSha256(String flowContentSha256) {
            this.flowContentSha256 = flowContentSha256;
            return this;
        }

        public final Long getVersion() {
            return version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public ContactFlow build() {
            return new ContactFlow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
