/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the contact evaluations where the key is the FormId, which is a unique identifier for the form.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactEvaluation implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactEvaluation.Builder, ContactEvaluation> {
    private static final SdkField<String> FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FormId")
            .getter(getter(ContactEvaluation::formId)).setter(setter(Builder::formId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormId").build()).build();

    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationArn").getter(getter(ContactEvaluation::evaluationArn)).setter(setter(Builder::evaluationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ContactEvaluation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(ContactEvaluation::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(ContactEvaluation::endTimestamp)).setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final SdkField<Instant> DELETE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeleteTimestamp").getter(getter(ContactEvaluation::deleteTimestamp))
            .setter(setter(Builder::deleteTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTimestamp").build()).build();

    private static final SdkField<String> EXPORT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExportLocation").getter(getter(ContactEvaluation::exportLocation))
            .setter(setter(Builder::exportLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORM_ID_FIELD,
            EVALUATION_ARN_FIELD, STATUS_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, DELETE_TIMESTAMP_FIELD,
            EXPORT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String formId;

    private final String evaluationArn;

    private final String status;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private final Instant deleteTimestamp;

    private final String exportLocation;

    private ContactEvaluation(BuilderImpl builder) {
        this.formId = builder.formId;
        this.evaluationArn = builder.evaluationArn;
        this.status = builder.status;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.deleteTimestamp = builder.deleteTimestamp;
        this.exportLocation = builder.exportLocation;
    }

    /**
     * <p>
     * The <code>FormId</code> of the contact evaluation.
     * </p>
     * 
     * @return The <code>FormId</code> of the contact evaluation.
     */
    public final String formId() {
        return formId;
    }

    /**
     * <p>
     * The Amazon Resource Name for the evaluation form. It is always present.
     * </p>
     * 
     * @return The Amazon Resource Name for the evaluation form. It is always present.
     */
    public final String evaluationArn() {
        return evaluationArn;
    }

    /**
     * <p>
     * The status of the evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the evaluation.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the evaluation was started, in UTC time.
     * </p>
     * 
     * @return The date and time when the evaluation was started, in UTC time.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The date and time when the evaluation was submitted, in UTC time.
     * </p>
     * 
     * @return The date and time when the evaluation was submitted, in UTC time.
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * <p>
     * The date and time when the evaluation was deleted, in UTC time.
     * </p>
     * 
     * @return The date and time when the evaluation was deleted, in UTC time.
     */
    public final Instant deleteTimestamp() {
        return deleteTimestamp;
    }

    /**
     * <p>
     * The path where evaluation was exported.
     * </p>
     * 
     * @return The path where evaluation was exported.
     */
    public final String exportLocation() {
        return exportLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(deleteTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(exportLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactEvaluation)) {
            return false;
        }
        ContactEvaluation other = (ContactEvaluation) obj;
        return Objects.equals(formId(), other.formId()) && Objects.equals(evaluationArn(), other.evaluationArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp())
                && Objects.equals(deleteTimestamp(), other.deleteTimestamp())
                && Objects.equals(exportLocation(), other.exportLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactEvaluation").add("FormId", formId()).add("EvaluationArn", evaluationArn())
                .add("Status", statusAsString()).add("StartTimestamp", startTimestamp()).add("EndTimestamp", endTimestamp())
                .add("DeleteTimestamp", deleteTimestamp()).add("ExportLocation", exportLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FormId":
            return Optional.ofNullable(clazz.cast(formId()));
        case "EvaluationArn":
            return Optional.ofNullable(clazz.cast(evaluationArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "DeleteTimestamp":
            return Optional.ofNullable(clazz.cast(deleteTimestamp()));
        case "ExportLocation":
            return Optional.ofNullable(clazz.cast(exportLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FormId", FORM_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("DeleteTimestamp", DELETE_TIMESTAMP_FIELD);
        map.put("ExportLocation", EXPORT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactEvaluation, T> g) {
        return obj -> g.apply((ContactEvaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactEvaluation> {
        /**
         * <p>
         * The <code>FormId</code> of the contact evaluation.
         * </p>
         * 
         * @param formId
         *        The <code>FormId</code> of the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formId(String formId);

        /**
         * <p>
         * The Amazon Resource Name for the evaluation form. It is always present.
         * </p>
         * 
         * @param evaluationArn
         *        The Amazon Resource Name for the evaluation form. It is always present.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationArn(String evaluationArn);

        /**
         * <p>
         * The status of the evaluation.
         * </p>
         * 
         * @param status
         *        The status of the evaluation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the evaluation.
         * </p>
         * 
         * @param status
         *        The status of the evaluation.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The date and time when the evaluation was started, in UTC time.
         * </p>
         * 
         * @param startTimestamp
         *        The date and time when the evaluation was started, in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The date and time when the evaluation was submitted, in UTC time.
         * </p>
         * 
         * @param endTimestamp
         *        The date and time when the evaluation was submitted, in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * The date and time when the evaluation was deleted, in UTC time.
         * </p>
         * 
         * @param deleteTimestamp
         *        The date and time when the evaluation was deleted, in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteTimestamp(Instant deleteTimestamp);

        /**
         * <p>
         * The path where evaluation was exported.
         * </p>
         * 
         * @param exportLocation
         *        The path where evaluation was exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportLocation(String exportLocation);
    }

    static final class BuilderImpl implements Builder {
        private String formId;

        private String evaluationArn;

        private String status;

        private Instant startTimestamp;

        private Instant endTimestamp;

        private Instant deleteTimestamp;

        private String exportLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactEvaluation model) {
            formId(model.formId);
            evaluationArn(model.evaluationArn);
            status(model.status);
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
            deleteTimestamp(model.deleteTimestamp);
            exportLocation(model.exportLocation);
        }

        public final String getFormId() {
            return formId;
        }

        public final void setFormId(String formId) {
            this.formId = formId;
        }

        @Override
        public final Builder formId(String formId) {
            this.formId = formId;
            return this;
        }

        public final String getEvaluationArn() {
            return evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final Instant getDeleteTimestamp() {
            return deleteTimestamp;
        }

        public final void setDeleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
        }

        @Override
        public final Builder deleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
            return this;
        }

        public final String getExportLocation() {
            return exportLocation;
        }

        public final void setExportLocation(String exportLocation) {
            this.exportLocation = exportLocation;
        }

        @Override
        public final Builder exportLocation(String exportLocation) {
            this.exportLocation = exportLocation;
            return this;
        }

        @Override
        public ContactEvaluation build() {
            return new ContactEvaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
