/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A boolean search condition for Search APIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BooleanCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<BooleanCondition.Builder, BooleanCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(BooleanCondition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonType").getter(getter(BooleanCondition::comparisonTypeAsString))
            .setter(setter(Builder::comparisonType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD,
            COMPARISON_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String comparisonType;

    private BooleanCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.comparisonType = builder.comparisonType;
    }

    /**
     * <p>
     * A name of the property to be searched.
     * </p>
     * 
     * @return A name of the property to be searched.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * Boolean property comparison type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link BooleanComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return Boolean property comparison type.
     * @see BooleanComparisonType
     */
    public final BooleanComparisonType comparisonType() {
        return BooleanComparisonType.fromValue(comparisonType);
    }

    /**
     * <p>
     * Boolean property comparison type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link BooleanComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return Boolean property comparison type.
     * @see BooleanComparisonType
     */
    public final String comparisonTypeAsString() {
        return comparisonType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BooleanCondition)) {
            return false;
        }
        BooleanCondition other = (BooleanCondition) obj;
        return Objects.equals(fieldName(), other.fieldName())
                && Objects.equals(comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BooleanCondition").add("FieldName", fieldName()).add("ComparisonType", comparisonTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "ComparisonType":
            return Optional.ofNullable(clazz.cast(comparisonTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("ComparisonType", COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BooleanCondition, T> g) {
        return obj -> g.apply((BooleanCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BooleanCondition> {
        /**
         * <p>
         * A name of the property to be searched.
         * </p>
         * 
         * @param fieldName
         *        A name of the property to be searched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * Boolean property comparison type.
         * </p>
         * 
         * @param comparisonType
         *        Boolean property comparison type.
         * @see BooleanComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BooleanComparisonType
         */
        Builder comparisonType(String comparisonType);

        /**
         * <p>
         * Boolean property comparison type.
         * </p>
         * 
         * @param comparisonType
         *        Boolean property comparison type.
         * @see BooleanComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BooleanComparisonType
         */
        Builder comparisonType(BooleanComparisonType comparisonType);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(BooleanCondition model) {
            fieldName(model.fieldName);
            comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getComparisonType() {
            return comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(BooleanComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        @Override
        public BooleanCondition build() {
            return new BooleanCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
