/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information of the AI agent involved in the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AiAgentInfo implements SdkPojo, Serializable, ToCopyableBuilder<AiAgentInfo.Builder, AiAgentInfo> {
    private static final SdkField<String> AI_USE_CASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AiUseCase").getter(getter(AiAgentInfo::aiUseCaseAsString)).setter(setter(Builder::aiUseCase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiUseCase").build()).build();

    private static final SdkField<String> AI_AGENT_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AiAgentVersionId").getter(getter(AiAgentInfo::aiAgentVersionId))
            .setter(setter(Builder::aiAgentVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiAgentVersionId").build()).build();

    private static final SdkField<Boolean> AI_AGENT_ESCALATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AiAgentEscalated").getter(getter(AiAgentInfo::aiAgentEscalated))
            .setter(setter(Builder::aiAgentEscalated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AiAgentEscalated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_USE_CASE_FIELD,
            AI_AGENT_VERSION_ID_FIELD, AI_AGENT_ESCALATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aiUseCase;

    private final String aiAgentVersionId;

    private final Boolean aiAgentEscalated;

    private AiAgentInfo(BuilderImpl builder) {
        this.aiUseCase = builder.aiUseCase;
        this.aiAgentVersionId = builder.aiAgentVersionId;
        this.aiAgentEscalated = builder.aiAgentEscalated;
    }

    /**
     * <p>
     * The use case or scenario for which the AI agent is involved in the contact
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiUseCase} will
     * return {@link AiUseCase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiUseCaseAsString}.
     * </p>
     * 
     * @return The use case or scenario for which the AI agent is involved in the contact
     * @see AiUseCase
     */
    public final AiUseCase aiUseCase() {
        return AiUseCase.fromValue(aiUseCase);
    }

    /**
     * <p>
     * The use case or scenario for which the AI agent is involved in the contact
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aiUseCase} will
     * return {@link AiUseCase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #aiUseCaseAsString}.
     * </p>
     * 
     * @return The use case or scenario for which the AI agent is involved in the contact
     * @see AiUseCase
     */
    public final String aiUseCaseAsString() {
        return aiUseCase;
    }

    /**
     * <p>
     * The unique identifier that specifies both the AI agent ID and its version number that was involved in the contact
     * </p>
     * 
     * @return The unique identifier that specifies both the AI agent ID and its version number that was involved in the
     *         contact
     */
    public final String aiAgentVersionId() {
        return aiAgentVersionId;
    }

    /**
     * <p>
     * A boolean flag indicating whether the contact initially handled by this AI agent was escalated to a human agent.
     * </p>
     * 
     * @return A boolean flag indicating whether the contact initially handled by this AI agent was escalated to a human
     *         agent.
     */
    public final Boolean aiAgentEscalated() {
        return aiAgentEscalated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiUseCaseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(aiAgentEscalated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AiAgentInfo)) {
            return false;
        }
        AiAgentInfo other = (AiAgentInfo) obj;
        return Objects.equals(aiUseCaseAsString(), other.aiUseCaseAsString())
                && Objects.equals(aiAgentVersionId(), other.aiAgentVersionId())
                && Objects.equals(aiAgentEscalated(), other.aiAgentEscalated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AiAgentInfo").add("AiUseCase", aiUseCaseAsString()).add("AiAgentVersionId", aiAgentVersionId())
                .add("AiAgentEscalated", aiAgentEscalated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AiUseCase":
            return Optional.ofNullable(clazz.cast(aiUseCaseAsString()));
        case "AiAgentVersionId":
            return Optional.ofNullable(clazz.cast(aiAgentVersionId()));
        case "AiAgentEscalated":
            return Optional.ofNullable(clazz.cast(aiAgentEscalated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AiUseCase", AI_USE_CASE_FIELD);
        map.put("AiAgentVersionId", AI_AGENT_VERSION_ID_FIELD);
        map.put("AiAgentEscalated", AI_AGENT_ESCALATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AiAgentInfo, T> g) {
        return obj -> g.apply((AiAgentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AiAgentInfo> {
        /**
         * <p>
         * The use case or scenario for which the AI agent is involved in the contact
         * </p>
         * 
         * @param aiUseCase
         *        The use case or scenario for which the AI agent is involved in the contact
         * @see AiUseCase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AiUseCase
         */
        Builder aiUseCase(String aiUseCase);

        /**
         * <p>
         * The use case or scenario for which the AI agent is involved in the contact
         * </p>
         * 
         * @param aiUseCase
         *        The use case or scenario for which the AI agent is involved in the contact
         * @see AiUseCase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AiUseCase
         */
        Builder aiUseCase(AiUseCase aiUseCase);

        /**
         * <p>
         * The unique identifier that specifies both the AI agent ID and its version number that was involved in the
         * contact
         * </p>
         * 
         * @param aiAgentVersionId
         *        The unique identifier that specifies both the AI agent ID and its version number that was involved in
         *        the contact
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentVersionId(String aiAgentVersionId);

        /**
         * <p>
         * A boolean flag indicating whether the contact initially handled by this AI agent was escalated to a human
         * agent.
         * </p>
         * 
         * @param aiAgentEscalated
         *        A boolean flag indicating whether the contact initially handled by this AI agent was escalated to a
         *        human agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiAgentEscalated(Boolean aiAgentEscalated);
    }

    static final class BuilderImpl implements Builder {
        private String aiUseCase;

        private String aiAgentVersionId;

        private Boolean aiAgentEscalated;

        private BuilderImpl() {
        }

        private BuilderImpl(AiAgentInfo model) {
            aiUseCase(model.aiUseCase);
            aiAgentVersionId(model.aiAgentVersionId);
            aiAgentEscalated(model.aiAgentEscalated);
        }

        public final String getAiUseCase() {
            return aiUseCase;
        }

        public final void setAiUseCase(String aiUseCase) {
            this.aiUseCase = aiUseCase;
        }

        @Override
        public final Builder aiUseCase(String aiUseCase) {
            this.aiUseCase = aiUseCase;
            return this;
        }

        @Override
        public final Builder aiUseCase(AiUseCase aiUseCase) {
            this.aiUseCase(aiUseCase == null ? null : aiUseCase.toString());
            return this;
        }

        public final String getAiAgentVersionId() {
            return aiAgentVersionId;
        }

        public final void setAiAgentVersionId(String aiAgentVersionId) {
            this.aiAgentVersionId = aiAgentVersionId;
        }

        @Override
        public final Builder aiAgentVersionId(String aiAgentVersionId) {
            this.aiAgentVersionId = aiAgentVersionId;
            return this;
        }

        public final Boolean getAiAgentEscalated() {
            return aiAgentEscalated;
        }

        public final void setAiAgentEscalated(Boolean aiAgentEscalated) {
            this.aiAgentEscalated = aiAgentEscalated;
        }

        @Override
        public final Builder aiAgentEscalated(Boolean aiAgentEscalated) {
            this.aiAgentEscalated = aiAgentEscalated;
            return this;
        }

        @Override
        public AiAgentInfo build() {
            return new AiAgentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
