/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.connect.internal.ConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.connect.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.connect.model.AccessDeniedException;
import software.amazon.awssdk.services.connect.model.ActivateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.ActivateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.AssociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.AssociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.AssociateBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateBotResponse;
import software.amazon.awssdk.services.connect.model.AssociateContactWithUserRequest;
import software.amazon.awssdk.services.connect.model.AssociateContactWithUserResponse;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyRequest;
import software.amazon.awssdk.services.connect.model.AssociateDefaultVocabularyResponse;
import software.amazon.awssdk.services.connect.model.AssociateEmailAddressAliasRequest;
import software.amazon.awssdk.services.connect.model.AssociateEmailAddressAliasResponse;
import software.amazon.awssdk.services.connect.model.AssociateFlowRequest;
import software.amazon.awssdk.services.connect.model.AssociateFlowResponse;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.AssociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.AssociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.AssociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.AssociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.AssociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.AssociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.AssociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.AssociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.AssociateSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.AssociateSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserRequest;
import software.amazon.awssdk.services.connect.model.AssociateTrafficDistributionGroupUserResponse;
import software.amazon.awssdk.services.connect.model.AssociateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.AssociateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.AssociateWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.AssociateWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.BatchAssociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchCreateDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.BatchDeleteDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchDeleteDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.BatchDescribeDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchDescribeDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.BatchDisassociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataRequest;
import software.amazon.awssdk.services.connect.model.BatchGetAttachedFileMetadataResponse;
import software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationRequest;
import software.amazon.awssdk.services.connect.model.BatchGetFlowAssociationResponse;
import software.amazon.awssdk.services.connect.model.BatchPutContactRequest;
import software.amazon.awssdk.services.connect.model.BatchPutContactResponse;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueRequest;
import software.amazon.awssdk.services.connect.model.BatchUpdateDataTableValueResponse;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ClaimPhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadRequest;
import software.amazon.awssdk.services.connect.model.CompleteAttachedFileUploadResponse;
import software.amazon.awssdk.services.connect.model.ConditionalOperationFailedException;
import software.amazon.awssdk.services.connect.model.ConflictException;
import software.amazon.awssdk.services.connect.model.ConnectException;
import software.amazon.awssdk.services.connect.model.ContactFlowNotPublishedException;
import software.amazon.awssdk.services.connect.model.ContactNotFoundException;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.CreateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleVersionRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowModuleVersionResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowResponse;
import software.amazon.awssdk.services.connect.model.CreateContactFlowVersionRequest;
import software.amazon.awssdk.services.connect.model.CreateContactFlowVersionResponse;
import software.amazon.awssdk.services.connect.model.CreateContactRequest;
import software.amazon.awssdk.services.connect.model.CreateContactResponse;
import software.amazon.awssdk.services.connect.model.CreateDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.CreateDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.CreateDataTableRequest;
import software.amazon.awssdk.services.connect.model.CreateDataTableResponse;
import software.amazon.awssdk.services.connect.model.CreateEmailAddressRequest;
import software.amazon.awssdk.services.connect.model.CreateEmailAddressResponse;
import software.amazon.awssdk.services.connect.model.CreateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.CreateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.CreateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.CreateInstanceRequest;
import software.amazon.awssdk.services.connect.model.CreateInstanceResponse;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.CreateIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.CreateParticipantRequest;
import software.amazon.awssdk.services.connect.model.CreateParticipantResponse;
import software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationRequest;
import software.amazon.awssdk.services.connect.model.CreatePersistentContactAssociationResponse;
import software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.CreatePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.CreatePromptRequest;
import software.amazon.awssdk.services.connect.model.CreatePromptResponse;
import software.amazon.awssdk.services.connect.model.CreatePushNotificationRegistrationRequest;
import software.amazon.awssdk.services.connect.model.CreatePushNotificationRegistrationResponse;
import software.amazon.awssdk.services.connect.model.CreateQueueRequest;
import software.amazon.awssdk.services.connect.model.CreateQueueResponse;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.CreateQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateRuleRequest;
import software.amazon.awssdk.services.connect.model.CreateRuleResponse;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.CreateTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.CreateTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.CreateTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.CreateUseCaseRequest;
import software.amazon.awssdk.services.connect.model.CreateUseCaseResponse;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.CreateUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.CreateUserRequest;
import software.amazon.awssdk.services.connect.model.CreateUserResponse;
import software.amazon.awssdk.services.connect.model.CreateViewRequest;
import software.amazon.awssdk.services.connect.model.CreateViewResponse;
import software.amazon.awssdk.services.connect.model.CreateViewVersionRequest;
import software.amazon.awssdk.services.connect.model.CreateViewVersionResponse;
import software.amazon.awssdk.services.connect.model.CreateVocabularyRequest;
import software.amazon.awssdk.services.connect.model.CreateVocabularyResponse;
import software.amazon.awssdk.services.connect.model.CreateWorkspacePageRequest;
import software.amazon.awssdk.services.connect.model.CreateWorkspacePageResponse;
import software.amazon.awssdk.services.connect.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DeactivateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DeleteAttachedFileRequest;
import software.amazon.awssdk.services.connect.model.DeleteAttachedFileResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleVersionRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowModuleVersionResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowVersionRequest;
import software.amazon.awssdk.services.connect.model.DeleteContactFlowVersionResponse;
import software.amazon.awssdk.services.connect.model.DeleteDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.DeleteDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.DeleteDataTableRequest;
import software.amazon.awssdk.services.connect.model.DeleteDataTableResponse;
import software.amazon.awssdk.services.connect.model.DeleteEmailAddressRequest;
import software.amazon.awssdk.services.connect.model.DeleteEmailAddressResponse;
import software.amazon.awssdk.services.connect.model.DeleteEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DeleteEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DeleteHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.connect.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationRequest;
import software.amazon.awssdk.services.connect.model.DeleteIntegrationAssociationResponse;
import software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.DeletePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.DeletePromptRequest;
import software.amazon.awssdk.services.connect.model.DeletePromptResponse;
import software.amazon.awssdk.services.connect.model.DeletePushNotificationRegistrationRequest;
import software.amazon.awssdk.services.connect.model.DeletePushNotificationRegistrationResponse;
import software.amazon.awssdk.services.connect.model.DeleteQueueRequest;
import software.amazon.awssdk.services.connect.model.DeleteQueueResponse;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DeleteQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DeleteRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.DeleteRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.DeleteRuleRequest;
import software.amazon.awssdk.services.connect.model.DeleteRuleResponse;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DeleteTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.DeleteTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.DeleteTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseRequest;
import software.amazon.awssdk.services.connect.model.DeleteUseCaseResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DeleteUserRequest;
import software.amazon.awssdk.services.connect.model.DeleteUserResponse;
import software.amazon.awssdk.services.connect.model.DeleteViewRequest;
import software.amazon.awssdk.services.connect.model.DeleteViewResponse;
import software.amazon.awssdk.services.connect.model.DeleteViewVersionRequest;
import software.amazon.awssdk.services.connect.model.DeleteViewVersionResponse;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DeleteVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceMediaRequest;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceMediaResponse;
import software.amazon.awssdk.services.connect.model.DeleteWorkspacePageRequest;
import software.amazon.awssdk.services.connect.model.DeleteWorkspacePageResponse;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.DescribeAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.DescribeAuthenticationProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeAuthenticationProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowModuleResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DescribeContactRequest;
import software.amazon.awssdk.services.connect.model.DescribeContactResponse;
import software.amazon.awssdk.services.connect.model.DescribeDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribeDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribeDataTableRequest;
import software.amazon.awssdk.services.connect.model.DescribeDataTableResponse;
import software.amazon.awssdk.services.connect.model.DescribeEmailAddressRequest;
import software.amazon.awssdk.services.connect.model.DescribeEmailAddressResponse;
import software.amazon.awssdk.services.connect.model.DescribeEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.DescribeEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.DescribeHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceResponse;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DescribeInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.DescribePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.DescribePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.DescribePromptRequest;
import software.amazon.awssdk.services.connect.model.DescribePromptResponse;
import software.amazon.awssdk.services.connect.model.DescribeQueueRequest;
import software.amazon.awssdk.services.connect.model.DescribeQueueResponse;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectRequest;
import software.amazon.awssdk.services.connect.model.DescribeQuickConnectResponse;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeRuleRequest;
import software.amazon.awssdk.services.connect.model.DescribeRuleResponse;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeTrafficDistributionGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyGroupResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.DescribeUserRequest;
import software.amazon.awssdk.services.connect.model.DescribeUserResponse;
import software.amazon.awssdk.services.connect.model.DescribeViewRequest;
import software.amazon.awssdk.services.connect.model.DescribeViewResponse;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyRequest;
import software.amazon.awssdk.services.connect.model.DescribeVocabularyResponse;
import software.amazon.awssdk.services.connect.model.DescribeWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.DescribeWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DestinationNotAllowedException;
import software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetRequest;
import software.amazon.awssdk.services.connect.model.DisassociateAnalyticsDataSetResponse;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginRequest;
import software.amazon.awssdk.services.connect.model.DisassociateApprovedOriginResponse;
import software.amazon.awssdk.services.connect.model.DisassociateBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociateEmailAddressAliasRequest;
import software.amazon.awssdk.services.connect.model.DisassociateEmailAddressAliasResponse;
import software.amazon.awssdk.services.connect.model.DisassociateFlowRequest;
import software.amazon.awssdk.services.connect.model.DisassociateFlowResponse;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.DisassociateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLambdaFunctionResponse;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotRequest;
import software.amazon.awssdk.services.connect.model.DisassociateLexBotResponse;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowRequest;
import software.amazon.awssdk.services.connect.model.DisassociatePhoneNumberContactFlowResponse;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.DisassociateQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyRequest;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityKeyResponse;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserRequest;
import software.amazon.awssdk.services.connect.model.DisassociateTrafficDistributionGroupUserResponse;
import software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.DisassociateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.DisassociateWorkspaceRequest;
import software.amazon.awssdk.services.connect.model.DisassociateWorkspaceResponse;
import software.amazon.awssdk.services.connect.model.DismissUserContactRequest;
import software.amazon.awssdk.services.connect.model.DismissUserContactResponse;
import software.amazon.awssdk.services.connect.model.DuplicateResourceException;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.EvaluateDataTableValuesResponse;
import software.amazon.awssdk.services.connect.model.GetAttachedFileRequest;
import software.amazon.awssdk.services.connect.model.GetAttachedFileResponse;
import software.amazon.awssdk.services.connect.model.GetContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.GetContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.GetContactMetricsRequest;
import software.amazon.awssdk.services.connect.model.GetContactMetricsResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse;
import software.amazon.awssdk.services.connect.model.GetEffectiveHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.GetEffectiveHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.GetFederationTokenRequest;
import software.amazon.awssdk.services.connect.model.GetFederationTokenResponse;
import software.amazon.awssdk.services.connect.model.GetFlowAssociationRequest;
import software.amazon.awssdk.services.connect.model.GetFlowAssociationResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataRequest;
import software.amazon.awssdk.services.connect.model.GetMetricDataResponse;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Request;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Response;
import software.amazon.awssdk.services.connect.model.GetPromptFileRequest;
import software.amazon.awssdk.services.connect.model.GetPromptFileResponse;
import software.amazon.awssdk.services.connect.model.GetTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.GetTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.GetTrafficDistributionRequest;
import software.amazon.awssdk.services.connect.model.GetTrafficDistributionResponse;
import software.amazon.awssdk.services.connect.model.IdempotencyException;
import software.amazon.awssdk.services.connect.model.ImportPhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ImportPhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.ImportWorkspaceMediaRequest;
import software.amazon.awssdk.services.connect.model.ImportWorkspaceMediaResponse;
import software.amazon.awssdk.services.connect.model.InternalServiceException;
import software.amazon.awssdk.services.connect.model.InvalidContactFlowException;
import software.amazon.awssdk.services.connect.model.InvalidContactFlowModuleException;
import software.amazon.awssdk.services.connect.model.InvalidParameterException;
import software.amazon.awssdk.services.connect.model.InvalidRequestException;
import software.amazon.awssdk.services.connect.model.LimitExceededException;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataLakeDataSetsRequest;
import software.amazon.awssdk.services.connect.model.ListAnalyticsDataLakeDataSetsResponse;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsRequest;
import software.amazon.awssdk.services.connect.model.ListApprovedOriginsResponse;
import software.amazon.awssdk.services.connect.model.ListAssociatedContactsRequest;
import software.amazon.awssdk.services.connect.model.ListAssociatedContactsResponse;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListAuthenticationProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListBotsRequest;
import software.amazon.awssdk.services.connect.model.ListBotsResponse;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsRequest;
import software.amazon.awssdk.services.connect.model.ListContactEvaluationsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleAliasesResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModuleVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.ListContactReferencesRequest;
import software.amazon.awssdk.services.connect.model.ListContactReferencesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTableAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTableAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablePrimaryValuesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTableValuesResponse;
import software.amazon.awssdk.services.connect.model.ListDataTablesRequest;
import software.amazon.awssdk.services.connect.model.ListDataTablesResponse;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.ListEntitySecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListEntitySecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesResponse;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsRequest;
import software.amazon.awssdk.services.connect.model.ListInstanceStorageConfigsResponse;
import software.amazon.awssdk.services.connect.model.ListInstancesRequest;
import software.amazon.awssdk.services.connect.model.ListInstancesResponse;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsRequest;
import software.amazon.awssdk.services.connect.model.ListIntegrationAssociationsResponse;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse;
import software.amazon.awssdk.services.connect.model.ListLexBotsRequest;
import software.amazon.awssdk.services.connect.model.ListLexBotsResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.ListPromptsRequest;
import software.amazon.awssdk.services.connect.model.ListPromptsResponse;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQueueQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.ListQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Request;
import software.amazon.awssdk.services.connect.model.ListRealtimeContactAnalysisSegmentsV2Response;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileManualAssignmentQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileManualAssignmentQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListRulesRequest;
import software.amazon.awssdk.services.connect.model.ListRulesResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityKeysResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilePermissionsResponse;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupUsersResponse;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUseCasesRequest;
import software.amazon.awssdk.services.connect.model.ListUseCasesResponse;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.ListUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.ListUsersRequest;
import software.amazon.awssdk.services.connect.model.ListUsersResponse;
import software.amazon.awssdk.services.connect.model.ListViewVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListViewVersionsResponse;
import software.amazon.awssdk.services.connect.model.ListViewsRequest;
import software.amazon.awssdk.services.connect.model.ListViewsResponse;
import software.amazon.awssdk.services.connect.model.ListWorkspaceMediaRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspaceMediaResponse;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspacePagesResponse;
import software.amazon.awssdk.services.connect.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.connect.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.connect.model.MaximumResultReturnedException;
import software.amazon.awssdk.services.connect.model.MonitorContactRequest;
import software.amazon.awssdk.services.connect.model.MonitorContactResponse;
import software.amazon.awssdk.services.connect.model.OutboundContactNotPermittedException;
import software.amazon.awssdk.services.connect.model.OutputTypeNotFoundException;
import software.amazon.awssdk.services.connect.model.PauseContactRequest;
import software.amazon.awssdk.services.connect.model.PauseContactResponse;
import software.amazon.awssdk.services.connect.model.PropertyValidationException;
import software.amazon.awssdk.services.connect.model.PutUserStatusRequest;
import software.amazon.awssdk.services.connect.model.PutUserStatusResponse;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.ReleasePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.ReplicateInstanceRequest;
import software.amazon.awssdk.services.connect.model.ReplicateInstanceResponse;
import software.amazon.awssdk.services.connect.model.ResourceConflictException;
import software.amazon.awssdk.services.connect.model.ResourceInUseException;
import software.amazon.awssdk.services.connect.model.ResourceNotFoundException;
import software.amazon.awssdk.services.connect.model.ResourceNotReadyException;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.ResumeContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.ResumeContactRequest;
import software.amazon.awssdk.services.connect.model.ResumeContactResponse;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.SearchAgentStatusesResponse;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.SearchContactEvaluationsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactEvaluationsResponse;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesResponse;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowsResponse;
import software.amazon.awssdk.services.connect.model.SearchContactsRequest;
import software.amazon.awssdk.services.connect.model.SearchContactsResponse;
import software.amazon.awssdk.services.connect.model.SearchDataTablesRequest;
import software.amazon.awssdk.services.connect.model.SearchDataTablesResponse;
import software.amazon.awssdk.services.connect.model.SearchEmailAddressesRequest;
import software.amazon.awssdk.services.connect.model.SearchEmailAddressesResponse;
import software.amazon.awssdk.services.connect.model.SearchEvaluationFormsRequest;
import software.amazon.awssdk.services.connect.model.SearchEvaluationFormsResponse;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesResponse;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationsResponse;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.SearchPromptsRequest;
import software.amazon.awssdk.services.connect.model.SearchPromptsResponse;
import software.amazon.awssdk.services.connect.model.SearchQueuesRequest;
import software.amazon.awssdk.services.connect.model.SearchQueuesResponse;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsRequest;
import software.amazon.awssdk.services.connect.model.SearchQuickConnectsResponse;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.SearchUserHierarchyGroupsResponse;
import software.amazon.awssdk.services.connect.model.SearchUsersRequest;
import software.amazon.awssdk.services.connect.model.SearchUsersResponse;
import software.amazon.awssdk.services.connect.model.SearchViewsRequest;
import software.amazon.awssdk.services.connect.model.SearchViewsResponse;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.SearchVocabulariesResponse;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspaceAssociationsResponse;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesRequest;
import software.amazon.awssdk.services.connect.model.SearchWorkspacesResponse;
import software.amazon.awssdk.services.connect.model.SendChatIntegrationEventRequest;
import software.amazon.awssdk.services.connect.model.SendChatIntegrationEventResponse;
import software.amazon.awssdk.services.connect.model.SendOutboundEmailRequest;
import software.amazon.awssdk.services.connect.model.SendOutboundEmailResponse;
import software.amazon.awssdk.services.connect.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.connect.model.StartAttachedFileUploadRequest;
import software.amazon.awssdk.services.connect.model.StartAttachedFileUploadResponse;
import software.amazon.awssdk.services.connect.model.StartChatContactRequest;
import software.amazon.awssdk.services.connect.model.StartChatContactResponse;
import software.amazon.awssdk.services.connect.model.StartContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.StartContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.StartContactMediaProcessingRequest;
import software.amazon.awssdk.services.connect.model.StartContactMediaProcessingResponse;
import software.amazon.awssdk.services.connect.model.StartContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StartContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StartContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StartContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.StartEmailContactRequest;
import software.amazon.awssdk.services.connect.model.StartEmailContactResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundChatContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundChatContactResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundEmailContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundEmailContactResponse;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactRequest;
import software.amazon.awssdk.services.connect.model.StartOutboundVoiceContactResponse;
import software.amazon.awssdk.services.connect.model.StartScreenSharingRequest;
import software.amazon.awssdk.services.connect.model.StartScreenSharingResponse;
import software.amazon.awssdk.services.connect.model.StartTaskContactRequest;
import software.amazon.awssdk.services.connect.model.StartTaskContactResponse;
import software.amazon.awssdk.services.connect.model.StartWebRtcContactRequest;
import software.amazon.awssdk.services.connect.model.StartWebRtcContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactMediaProcessingRequest;
import software.amazon.awssdk.services.connect.model.StopContactMediaProcessingResponse;
import software.amazon.awssdk.services.connect.model.StopContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.StopContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.StopContactRequest;
import software.amazon.awssdk.services.connect.model.StopContactResponse;
import software.amazon.awssdk.services.connect.model.StopContactStreamingRequest;
import software.amazon.awssdk.services.connect.model.StopContactStreamingResponse;
import software.amazon.awssdk.services.connect.model.SubmitContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.SubmitContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingRequest;
import software.amazon.awssdk.services.connect.model.SuspendContactRecordingResponse;
import software.amazon.awssdk.services.connect.model.TagContactRequest;
import software.amazon.awssdk.services.connect.model.TagContactResponse;
import software.amazon.awssdk.services.connect.model.TagResourceRequest;
import software.amazon.awssdk.services.connect.model.TagResourceResponse;
import software.amazon.awssdk.services.connect.model.ThrottlingException;
import software.amazon.awssdk.services.connect.model.TooManyRequestsException;
import software.amazon.awssdk.services.connect.model.TransferContactRequest;
import software.amazon.awssdk.services.connect.model.TransferContactResponse;
import software.amazon.awssdk.services.connect.model.UntagContactRequest;
import software.amazon.awssdk.services.connect.model.UntagContactResponse;
import software.amazon.awssdk.services.connect.model.UntagResourceRequest;
import software.amazon.awssdk.services.connect.model.UntagResourceResponse;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateAgentStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateAuthenticationProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateAuthenticationProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactAttributesResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactEvaluationRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactEvaluationResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleAliasRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleAliasResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowModuleMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactFlowNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactRoutingDataRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactRoutingDataResponse;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleRequest;
import software.amazon.awssdk.services.connect.model.UpdateContactScheduleResponse;
import software.amazon.awssdk.services.connect.model.UpdateDataTableAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdateDataTableAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdateDataTableMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateDataTableMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateDataTablePrimaryValuesRequest;
import software.amazon.awssdk.services.connect.model.UpdateDataTablePrimaryValuesResponse;
import software.amazon.awssdk.services.connect.model.UpdateEmailAddressMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateEmailAddressMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateEvaluationFormRequest;
import software.amazon.awssdk.services.connect.model.UpdateEvaluationFormResponse;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationOverrideRequest;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationOverrideResponse;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateInstanceStorageConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateParticipantAuthenticationRequest;
import software.amazon.awssdk.services.connect.model.UpdateParticipantAuthenticationResponse;
import software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateParticipantRoleConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberRequest;
import software.amazon.awssdk.services.connect.model.UpdatePhoneNumberResponse;
import software.amazon.awssdk.services.connect.model.UpdatePredefinedAttributeRequest;
import software.amazon.awssdk.services.connect.model.UpdatePredefinedAttributeResponse;
import software.amazon.awssdk.services.connect.model.UpdatePromptRequest;
import software.amazon.awssdk.services.connect.model.UpdatePromptResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueHoursOfOperationResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueMaxContactsResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundCallerConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundEmailConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueOutboundEmailConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusRequest;
import software.amazon.awssdk.services.connect.model.UpdateQueueStatusResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateQuickConnectNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileAgentAvailabilityTimerResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileConcurrencyResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileDefaultOutboundQueueResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesRequest;
import software.amazon.awssdk.services.connect.model.UpdateRoutingProfileQueuesResponse;
import software.amazon.awssdk.services.connect.model.UpdateRuleRequest;
import software.amazon.awssdk.services.connect.model.UpdateRuleResponse;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateTaskTemplateRequest;
import software.amazon.awssdk.services.connect.model.UpdateTaskTemplateResponse;
import software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionRequest;
import software.amazon.awssdk.services.connect.model.UpdateTrafficDistributionResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyGroupNameResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserHierarchyStructureResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserIdentityInfoResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserPhoneConfigResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserProficienciesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserProficienciesResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserRoutingProfileResponse;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesRequest;
import software.amazon.awssdk.services.connect.model.UpdateUserSecurityProfilesResponse;
import software.amazon.awssdk.services.connect.model.UpdateViewContentRequest;
import software.amazon.awssdk.services.connect.model.UpdateViewContentResponse;
import software.amazon.awssdk.services.connect.model.UpdateViewMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateViewMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceMetadataRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceMetadataResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspacePageRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspacePageResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceThemeRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceThemeResponse;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceVisibilityRequest;
import software.amazon.awssdk.services.connect.model.UpdateWorkspaceVisibilityResponse;
import software.amazon.awssdk.services.connect.model.UserNotFoundException;
import software.amazon.awssdk.services.connect.transform.ActivateEvaluationFormRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateAnalyticsDataSetRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateApprovedOriginRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateBotRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateContactWithUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateDefaultVocabularyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateEmailAddressAliasRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateFlowRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateInstanceStorageConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateLambdaFunctionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateLexBotRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociatePhoneNumberContactFlowRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateQueueQuickConnectsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateRoutingProfileQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateSecurityKeyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateTrafficDistributionGroupUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateUserProficienciesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.AssociateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchAssociateAnalyticsDataSetRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchCreateDataTableValueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchDeleteDataTableValueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchDescribeDataTableValueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchDisassociateAnalyticsDataSetRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchGetAttachedFileMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchGetFlowAssociationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchPutContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.BatchUpdateDataTableValueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ClaimPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CompleteAttachedFileUploadRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateAgentStatusRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateContactFlowModuleAliasRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateContactFlowModuleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateContactFlowModuleVersionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateContactFlowRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateContactFlowVersionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateDataTableAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateDataTableRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateEvaluationFormRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateHoursOfOperationOverrideRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateHoursOfOperationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateInstanceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateIntegrationAssociationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateParticipantRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreatePersistentContactAssociationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreatePredefinedAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreatePromptRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreatePushNotificationRegistrationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateQuickConnectRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateRoutingProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateTaskTemplateRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateTrafficDistributionGroupRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateUseCaseRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateUserHierarchyGroupRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateViewRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateViewVersionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateVocabularyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateWorkspacePageRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.CreateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeactivateEvaluationFormRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteAttachedFileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteContactEvaluationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteContactFlowModuleAliasRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteContactFlowModuleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteContactFlowModuleVersionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteContactFlowRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteContactFlowVersionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteDataTableAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteDataTableRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteEvaluationFormRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteHoursOfOperationOverrideRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteHoursOfOperationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteIntegrationAssociationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeletePredefinedAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeletePromptRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeletePushNotificationRegistrationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteQuickConnectRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteRoutingProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteTaskTemplateRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteTrafficDistributionGroupRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteUseCaseRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteUserHierarchyGroupRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteViewRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteViewVersionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteVocabularyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteWorkspaceMediaRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteWorkspacePageRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DeleteWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeAgentStatusRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeContactEvaluationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeContactFlowModuleAliasRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeContactFlowModuleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeContactFlowRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeDataTableAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeDataTableRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeEvaluationFormRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeHoursOfOperationOverrideRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeHoursOfOperationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeInstanceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeInstanceStorageConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribePredefinedAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribePromptRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeQueueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeQuickConnectRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeRoutingProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeRuleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeTrafficDistributionGroupRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeUserHierarchyGroupRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeUserHierarchyStructureRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeViewRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeVocabularyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DescribeWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateAnalyticsDataSetRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateApprovedOriginRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateBotRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateEmailAddressAliasRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateFlowRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateInstanceStorageConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateLambdaFunctionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateLexBotRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociatePhoneNumberContactFlowRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateQueueQuickConnectsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateRoutingProfileQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateSecurityKeyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateTrafficDistributionGroupUserRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateUserProficienciesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DisassociateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.DismissUserContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.EvaluateDataTableValuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetAttachedFileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetContactAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetContactMetricsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetCurrentMetricDataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetCurrentUserDataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetEffectiveHoursOfOperationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetFederationTokenRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetFlowAssociationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetMetricDataV2RequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetPromptFileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetTaskTemplateRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.GetTrafficDistributionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ImportPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ImportWorkspaceMediaRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListAgentStatusesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListAnalyticsDataAssociationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListAnalyticsDataLakeDataSetsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListApprovedOriginsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListAssociatedContactsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListAuthenticationProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListBotsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactFlowModuleAliasesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactFlowModuleVersionsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactFlowModulesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactFlowVersionsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactFlowsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListContactReferencesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListDataTableAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListDataTablePrimaryValuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListDataTableValuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListDataTablesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListDefaultVocabulariesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListEntitySecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListEvaluationFormVersionsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListEvaluationFormsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListFlowAssociationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListHoursOfOperationOverridesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListHoursOfOperationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListInstanceAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListInstanceStorageConfigsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListIntegrationAssociationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListLambdaFunctionsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListLexBotsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListPhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListPhoneNumbersV2RequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListPredefinedAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListPromptsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListQueueQuickConnectsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListQuickConnectsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListRealtimeContactAnalysisSegmentsV2RequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListRoutingProfileManualAssignmentQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListRoutingProfileQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListRoutingProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListRulesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListSecurityKeysRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListSecurityProfileApplicationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListSecurityProfileFlowModulesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListSecurityProfilePermissionsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListTaskTemplatesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListTrafficDistributionGroupUsersRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListTrafficDistributionGroupsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListUseCasesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListUserHierarchyGroupsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListUserProficienciesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListViewVersionsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListViewsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListWorkspaceMediaRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListWorkspacePagesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ListWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.MonitorContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.PauseContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.PutUserStatusRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ReleasePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ReplicateInstanceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ResumeContactRecordingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.ResumeContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchAgentStatusesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchAvailablePhoneNumbersRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchContactEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchContactFlowModulesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchContactFlowsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchContactsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchDataTablesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchEmailAddressesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchEvaluationFormsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchHoursOfOperationOverridesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchHoursOfOperationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchPredefinedAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchPromptsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchQuickConnectsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchResourceTagsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchRoutingProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchUserHierarchyGroupsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchUsersRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchViewsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchVocabulariesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchWorkspaceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SearchWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SendChatIntegrationEventRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SendOutboundEmailRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartAttachedFileUploadRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartChatContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartContactEvaluationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartContactMediaProcessingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartContactRecordingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartContactStreamingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartEmailContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartOutboundChatContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartOutboundEmailContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartOutboundVoiceContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartScreenSharingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartTaskContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StartWebRtcContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StopContactMediaProcessingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StopContactRecordingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StopContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.StopContactStreamingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SubmitContactEvaluationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.SuspendContactRecordingRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.TagContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.TransferContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UntagContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateAgentStatusRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateAuthenticationProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactAttributesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactEvaluationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactFlowContentRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactFlowMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactFlowModuleAliasRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactFlowModuleContentRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactFlowModuleMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactFlowNameRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactRoutingDataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateContactScheduleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateDataTableAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateDataTableMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateDataTablePrimaryValuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateEmailAddressMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateEvaluationFormRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateHoursOfOperationOverrideRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateHoursOfOperationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateInstanceAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateInstanceStorageConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateParticipantAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateParticipantRoleConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdatePhoneNumberMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdatePhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdatePredefinedAttributeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdatePromptRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQueueHoursOfOperationRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQueueMaxContactsRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQueueNameRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQueueOutboundCallerConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQueueOutboundEmailConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQueueStatusRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQuickConnectConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateQuickConnectNameRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateRoutingProfileAgentAvailabilityTimerRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateRoutingProfileConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateRoutingProfileDefaultOutboundQueueRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateRoutingProfileNameRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateRoutingProfileQueuesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateRuleRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateTaskTemplateRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateTrafficDistributionRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserHierarchyGroupNameRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserHierarchyRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserHierarchyStructureRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserIdentityInfoRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserPhoneConfigRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserProficienciesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserRoutingProfileRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateUserSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateViewContentRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateViewMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateWorkspaceMetadataRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateWorkspacePageRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateWorkspaceThemeRequestMarshaller;
import software.amazon.awssdk.services.connect.transform.UpdateWorkspaceVisibilityRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ConnectClient}.
 *
 * @see ConnectClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConnectClient implements ConnectClient {
    private static final Logger log = Logger.loggerFor(DefaultConnectClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConnectClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Connect" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it
     * is available to start new evaluations based on the form.
     * </p>
     *
     * @param activateEvaluationFormRequest
     * @return Result of the ActivateEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ActivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ActivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ActivateEvaluationFormResponse activateEvaluationForm(ActivateEvaluationFormRequest activateEvaluationFormRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ActivateEvaluationFormResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ActivateEvaluationFormResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(activateEvaluationFormRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, activateEvaluationFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ActivateEvaluationForm");

            return clientHandler
                    .execute(new ClientExecutionParams<ActivateEvaluationFormRequest, ActivateEvaluationFormResponse>()
                            .withOperationName("ActivateEvaluationForm").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(activateEvaluationFormRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ActivateEvaluationFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only
     * one dataset in a single call.
     * </p>
     *
     * @param associateAnalyticsDataSetRequest
     * @return Result of the AssociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateAnalyticsDataSetResponse associateAnalyticsDataSet(
            AssociateAnalyticsDataSetRequest associateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateAnalyticsDataSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateAnalyticsDataSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAnalyticsDataSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAnalyticsDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAnalyticsDataSet");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateAnalyticsDataSetRequest, AssociateAnalyticsDataSetResponse>()
                            .withOperationName("AssociateAnalyticsDataSet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateAnalyticsDataSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateAnalyticsDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates an approved origin to an Amazon Connect instance.
     * </p>
     *
     * @param associateApprovedOriginRequest
     * @return Result of the AssociateApprovedOrigin operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateApprovedOrigin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateApprovedOriginResponse associateApprovedOrigin(AssociateApprovedOriginRequest associateApprovedOriginRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateApprovedOriginResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateApprovedOriginResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateApprovedOriginRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateApprovedOriginRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateApprovedOrigin");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateApprovedOriginRequest, AssociateApprovedOriginResponse>()
                            .withOperationName("AssociateApprovedOrigin").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateApprovedOriginRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateApprovedOriginRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     * </p>
     *
     * @param associateBotRequest
     * @return Result of the AssociateBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateBotResponse associateBot(AssociateBotRequest associateBotRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, LimitExceededException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateBotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateBot");

            return clientHandler.execute(new ClientExecutionParams<AssociateBotRequest, AssociateBotResponse>()
                    .withOperationName("AssociateBot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateBotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a queued contact with an agent.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Programmatically assign queued contacts to available users.
     * </p>
     * </li>
     * <li>
     * <p>
     * Leverage the IAM context key <code>connect:PreferredUserArn</code> to restrict contact association to specific
     * preferred user.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use this API with chat, email, and task contacts. It does not support voice contacts.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use it to associate contacts with users regardless of their current state, including custom states. Ensure your
     * application logic accounts for user availability before making associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * It honors the IAM context key <code>connect:PreferredUserArn</code> to prevent unauthorized contact associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * It respects the IAM context key <code>connect:PreferredUserArn</code> to enforce authorization controls and
     * prevent unauthorized contact associations. Verify that your IAM policies are properly configured to support your
     * intended use cases.
     * </p>
     * </li>
     * <li>
     * <p>
     * The service quota <i>Queues per routing profile per instance</i> applies to manually assigned queues, too. For
     * more information about this quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     *
     * @param associateContactWithUserRequest
     * @return Result of the AssociateContactWithUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateContactWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateContactWithUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateContactWithUserResponse associateContactWithUser(
            AssociateContactWithUserRequest associateContactWithUserRequest) throws InvalidRequestException,
            InvalidParameterException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateContactWithUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateContactWithUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateContactWithUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateContactWithUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateContactWithUser");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateContactWithUserRequest, AssociateContactWithUserResponse>()
                            .withOperationName("AssociateContactWithUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateContactWithUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateContactWithUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in
     * post-call and real-time analysis sessions for the given language.
     * </p>
     *
     * @param associateDefaultVocabularyRequest
     * @return Result of the AssociateDefaultVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateDefaultVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateDefaultVocabularyResponse associateDefaultVocabulary(
            AssociateDefaultVocabularyRequest associateDefaultVocabularyRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateDefaultVocabularyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateDefaultVocabularyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateDefaultVocabularyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateDefaultVocabularyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateDefaultVocabulary");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateDefaultVocabularyRequest, AssociateDefaultVocabularyResponse>()
                            .withOperationName("AssociateDefaultVocabulary").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateDefaultVocabularyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateDefaultVocabularyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an email address alias with an existing email address in an Amazon Connect instance. This creates a
     * forwarding relationship where emails sent to the alias email address are automatically forwarded to the primary
     * email address.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Unified customer support</b>: Create multiple entry points (for example, support@example.com,
     * help@example.com, customercare@example.com) that all forward to a single agent queue for streamlined management.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Department consolidation</b>: Forward emails from legacy department addresses (for example, sales@example.com,
     * info@example.com) to a centralized customer service email during organizational restructuring.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Brand management</b>: Enable you to use familiar brand-specific email addresses that forward to the
     * appropriate Amazon Connect instance email address.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Important things to know</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Each email address can have a maximum of one alias. You cannot create multiple aliases for the same email
     * address.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the alias email address already receives direct emails, it continues to receive direct emails plus forwarded
     * emails.
     * </p>
     * </li>
     * <li>
     * <p>
     * You cannot chain email aliases together (that is, create an alias of an alias).
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>AssociateEmailAddressAlias</code> does not return the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A confirmation of the alias relationship details (you must call <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html"
     * >DescribeEmailAddress</a> to verify).
     * </p>
     * </li>
     * <li>
     * <p>
     * The timestamp of when the association occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * The status of the forwarding configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     * <p>
     * <b>Related operations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateEmailAddressAlias.html">
     * DisassociateEmailAddressAlias</a>: Removes the alias association between two email addresses in an Amazon Connect
     * instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html">
     * DescribeEmailAddress</a>: View current alias configurations for an email address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchEmailAddresses.html">
     * SearchEmailAddresses</a>: Find email addresses and their alias relationships across an instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateEmailAddress.html">CreateEmailAddress</
     * a>: Create new email addresses that can participate in alias relationships.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteEmailAddress.html">DeleteEmailAddress</
     * a>: Remove email addresses (automatically removes any alias relationships).
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateEmailAddressMetadata.html">
     * UpdateEmailAddressMetadata</a>: Modify email address properties (does not affect alias relationships).
     * </p>
     * </li>
     * </ul>
     *
     * @param associateEmailAddressAliasRequest
     * @return Result of the AssociateEmailAddressAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateEmailAddressAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateEmailAddressAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateEmailAddressAliasResponse associateEmailAddressAlias(
            AssociateEmailAddressAliasRequest associateEmailAddressAliasRequest) throws ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InvalidParameterException, InvalidRequestException,
            InternalServiceException, ResourceConflictException, IdempotencyException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateEmailAddressAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateEmailAddressAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateEmailAddressAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateEmailAddressAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateEmailAddressAlias");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateEmailAddressAliasRequest, AssociateEmailAddressAliasResponse>()
                            .withOperationName("AssociateEmailAddressAlias").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateEmailAddressAliasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateEmailAddressAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a connect resource to a flow.
     * </p>
     *
     * @param associateFlowRequest
     * @return Result of the AssociateFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateFlowResponse associateFlow(AssociateFlowRequest associateFlowRequest) throws AccessDeniedException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateFlow");

            return clientHandler.execute(new ClientExecutionParams<AssociateFlowRequest, AssociateFlowResponse>()
                    .withOperationName("AssociateFlow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateFlowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration
     * in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing
     * chat transcripts.
     * </p>
     * <p>
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the
     * resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     * </p>
     *
     * @param associateInstanceStorageConfigRequest
     * @return Result of the AssociateInstanceStorageConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateInstanceStorageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateInstanceStorageConfigResponse associateInstanceStorageConfig(
            AssociateInstanceStorageConfigRequest associateInstanceStorageConfigRequest) throws ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, InvalidRequestException, InvalidParameterException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateInstanceStorageConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateInstanceStorageConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateInstanceStorageConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateInstanceStorageConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateInstanceStorageConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateInstanceStorageConfigRequest, AssociateInstanceStorageConfigResponse>()
                            .withOperationName("AssociateInstanceStorageConfig").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateInstanceStorageConfigRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateInstanceStorageConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     * </p>
     *
     * @param associateLambdaFunctionRequest
     * @return Result of the AssociateLambdaFunction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLambdaFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateLambdaFunctionResponse associateLambdaFunction(AssociateLambdaFunctionRequest associateLambdaFunctionRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateLambdaFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateLambdaFunctionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateLambdaFunctionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateLambdaFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateLambdaFunction");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateLambdaFunctionRequest, AssociateLambdaFunctionResponse>()
                            .withOperationName("AssociateLambdaFunction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateLambdaFunctionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateLambdaFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports
     * the association of Amazon Lex V1 bots.
     * </p>
     *
     * @param associateLexBotRequest
     * @return Result of the AssociateLexBot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateLexBot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateLexBotResponse associateLexBot(AssociateLexBotRequest associateLexBotRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateLexBotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateLexBotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateLexBotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateLexBotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateLexBot");

            return clientHandler.execute(new ClientExecutionParams<AssociateLexBotRequest, AssociateLexBotResponse>()
                    .withOperationName("AssociateLexBot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateLexBotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateLexBotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a flow with a phone number claimed to your Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the
     * Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone
     * number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is
     * claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon
     * Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If
     * a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </important>
     *
     * @param associatePhoneNumberContactFlowRequest
     * @return Result of the AssociatePhoneNumberContactFlow operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociatePhoneNumberContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociatePhoneNumberContactFlowResponse associatePhoneNumberContactFlow(
            AssociatePhoneNumberContactFlowRequest associatePhoneNumberContactFlowRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociatePhoneNumberContactFlowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociatePhoneNumberContactFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associatePhoneNumberContactFlowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associatePhoneNumberContactFlowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePhoneNumberContactFlow");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociatePhoneNumberContactFlowRequest, AssociatePhoneNumberContactFlowResponse>()
                            .withOperationName("AssociatePhoneNumberContactFlow").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associatePhoneNumberContactFlowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociatePhoneNumberContactFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a set of quick connects with a queue.
     * </p>
     *
     * @param associateQueueQuickConnectsRequest
     * @return Result of the AssociateQueueQuickConnects operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateQueueQuickConnects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateQueueQuickConnectsResponse associateQueueQuickConnects(
            AssociateQueueQuickConnectsRequest associateQueueQuickConnectsRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateQueueQuickConnectsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateQueueQuickConnectsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateQueueQuickConnectsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateQueueQuickConnectsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateQueueQuickConnects");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateQueueQuickConnectsRequest, AssociateQueueQuickConnectsResponse>()
                            .withOperationName("AssociateQueueQuickConnects").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateQueueQuickConnectsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateQueueQuickConnectsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a set of queues with a routing profile.
     * </p>
     *
     * @param associateRoutingProfileQueuesRequest
     * @return Result of the AssociateRoutingProfileQueues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateRoutingProfileQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateRoutingProfileQueuesResponse associateRoutingProfileQueues(
            AssociateRoutingProfileQueuesRequest associateRoutingProfileQueuesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateRoutingProfileQueuesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateRoutingProfileQueuesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateRoutingProfileQueuesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateRoutingProfileQueuesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateRoutingProfileQueues");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateRoutingProfileQueuesRequest, AssociateRoutingProfileQueuesResponse>()
                            .withOperationName("AssociateRoutingProfileQueues").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateRoutingProfileQueuesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateRoutingProfileQueuesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Associates a security key to the instance.
     * </p>
     *
     * @param associateSecurityKeyRequest
     * @return Result of the AssociateSecurityKey operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateSecurityKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateSecurityKeyResponse associateSecurityKey(AssociateSecurityKeyRequest associateSecurityKeyRequest)
            throws ResourceNotFoundException, ResourceConflictException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSecurityKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSecurityKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSecurityKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSecurityKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSecurityKey");

            return clientHandler.execute(new ClientExecutionParams<AssociateSecurityKeyRequest, AssociateSecurityKeyResponse>()
                    .withOperationName("AssociateSecurityKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateSecurityKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateSecurityKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associate security profiles with an Entity in an Amazon Connect instance.
     * </p>
     *
     * @param associateSecurityProfilesRequest
     * @return Result of the AssociateSecurityProfiles operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ConditionalOperationFailedException
     *         Request processing failed because dependent condition failed.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateSecurityProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSecurityProfilesResponse associateSecurityProfiles(
            AssociateSecurityProfilesRequest associateSecurityProfilesRequest) throws ResourceNotFoundException,
            InvalidRequestException, InvalidParameterException, AccessDeniedException, InternalServiceException,
            ConditionalOperationFailedException, ResourceConflictException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSecurityProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSecurityProfilesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSecurityProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSecurityProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSecurityProfiles");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateSecurityProfilesRequest, AssociateSecurityProfilesResponse>()
                            .withOperationName("AssociateSecurityProfiles").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateSecurityProfilesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateSecurityProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an agent with a traffic distribution group. This API can be called only in the Region where the
     * traffic distribution group is created.
     * </p>
     *
     * @param associateTrafficDistributionGroupUserRequest
     * @return Result of the AssociateTrafficDistributionGroupUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateTrafficDistributionGroupUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateTrafficDistributionGroupUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTrafficDistributionGroupUserResponse associateTrafficDistributionGroupUser(
            AssociateTrafficDistributionGroupUserRequest associateTrafficDistributionGroupUserRequest)
            throws InvalidRequestException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            ResourceConflictException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTrafficDistributionGroupUserResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AssociateTrafficDistributionGroupUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTrafficDistributionGroupUserRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateTrafficDistributionGroupUserRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrafficDistributionGroupUser");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTrafficDistributionGroupUserRequest, AssociateTrafficDistributionGroupUserResponse>()
                            .withOperationName("AssociateTrafficDistributionGroupUser").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(associateTrafficDistributionGroupUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTrafficDistributionGroupUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a set of proficiencies with a user.
     * </p>
     *
     * @param associateUserProficienciesRequest
     * @return Result of the AssociateUserProficiencies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateUserProficiencies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateUserProficiencies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateUserProficienciesResponse associateUserProficiencies(
            AssociateUserProficienciesRequest associateUserProficienciesRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateUserProficienciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateUserProficienciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateUserProficienciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateUserProficienciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateUserProficiencies");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateUserProficienciesRequest, AssociateUserProficienciesResponse>()
                            .withOperationName("AssociateUserProficiencies").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateUserProficienciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateUserProficienciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a workspace with one or more users or routing profiles, allowing them to access the workspace's
     * configured views and pages.
     * </p>
     *
     * @param associateWorkspaceRequest
     * @return Result of the AssociateWorkspace operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.AssociateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateWorkspaceResponse associateWorkspace(AssociateWorkspaceRequest associateWorkspaceRequest)
            throws InvalidRequestException, DuplicateResourceException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AccessDeniedException, InvalidParameterException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateWorkspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateWorkspaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWorkspace");

            return clientHandler.execute(new ClientExecutionParams<AssociateWorkspaceRequest, AssociateWorkspaceResponse>()
                    .withOperationName("AssociateWorkspace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateWorkspaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can
     * associate multiple datasets in a single call.
     * </p>
     *
     * @param batchAssociateAnalyticsDataSetRequest
     * @return Result of the BatchAssociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchAssociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchAssociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchAssociateAnalyticsDataSetResponse batchAssociateAnalyticsDataSet(
            BatchAssociateAnalyticsDataSetRequest batchAssociateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchAssociateAnalyticsDataSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchAssociateAnalyticsDataSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchAssociateAnalyticsDataSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchAssociateAnalyticsDataSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateAnalyticsDataSet");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateAnalyticsDataSetRequest, BatchAssociateAnalyticsDataSetResponse>()
                            .withOperationName("BatchAssociateAnalyticsDataSet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchAssociateAnalyticsDataSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchAssociateAnalyticsDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates values for attributes in a data table. The value may be a default or it may be associated with a primary
     * value. The value must pass all customer defined validation as well as the default validation for the value type.
     * The operation must conform to Batch Operation API Standards. Although the standard specifies that successful and
     * failed entities are listed separately in the response, authorization fails if any primary values or attributes
     * are unauthorized. The combination of primary values and the attribute name serve as the identifier for the
     * individual item request.
     * </p>
     *
     * @param batchCreateDataTableValueRequest
     * @return Result of the BatchCreateDataTableValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchCreateDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchCreateDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchCreateDataTableValueResponse batchCreateDataTableValue(
            BatchCreateDataTableValueRequest batchCreateDataTableValueRequest) throws InvalidRequestException, ConflictException,
            DuplicateResourceException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, InvalidParameterException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchCreateDataTableValueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchCreateDataTableValueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchCreateDataTableValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchCreateDataTableValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchCreateDataTableValue");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchCreateDataTableValueRequest, BatchCreateDataTableValueResponse>()
                            .withOperationName("BatchCreateDataTableValue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchCreateDataTableValueRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchCreateDataTableValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes multiple values from a data table. API users may delete values at any time. When deletion is requested
     * from the admin website, a warning is shown alerting the user of the most recent time the attribute and its values
     * were accessed. System managed values are not deletable by customers.
     * </p>
     *
     * @param batchDeleteDataTableValueRequest
     * @return Result of the BatchDeleteDataTableValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchDeleteDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDeleteDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDeleteDataTableValueResponse batchDeleteDataTableValue(
            BatchDeleteDataTableValueRequest batchDeleteDataTableValueRequest) throws InvalidRequestException, ConflictException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            InvalidParameterException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteDataTableValueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteDataTableValueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteDataTableValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteDataTableValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteDataTableValue");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteDataTableValueRequest, BatchDeleteDataTableValueResponse>()
                            .withOperationName("BatchDeleteDataTableValue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDeleteDataTableValueRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDeleteDataTableValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves multiple values from a data table without evaluating expressions. Returns the raw stored values along
     * with metadata such as lock versions and modification timestamps. "Describe" is a deprecated term but is allowed
     * to maintain consistency with existing operations.
     * </p>
     *
     * @param batchDescribeDataTableValueRequest
     * @return Result of the BatchDescribeDataTableValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchDescribeDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDescribeDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDescribeDataTableValueResponse batchDescribeDataTableValue(
            BatchDescribeDataTableValueRequest batchDescribeDataTableValueRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            InvalidParameterException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDescribeDataTableValueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDescribeDataTableValueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDescribeDataTableValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDescribeDataTableValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDescribeDataTableValue");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeDataTableValueRequest, BatchDescribeDataTableValueResponse>()
                            .withOperationName("BatchDescribeDataTableValue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDescribeDataTableValueRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDescribeDataTableValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate
     * multiple datasets in a single call.
     * </p>
     *
     * @param batchDisassociateAnalyticsDataSetRequest
     * @return Result of the BatchDisassociateAnalyticsDataSet operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchDisassociateAnalyticsDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchDisassociateAnalyticsDataSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDisassociateAnalyticsDataSetResponse batchDisassociateAnalyticsDataSet(
            BatchDisassociateAnalyticsDataSetRequest batchDisassociateAnalyticsDataSetRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDisassociateAnalyticsDataSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDisassociateAnalyticsDataSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDisassociateAnalyticsDataSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateAnalyticsDataSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDisassociateAnalyticsDataSet");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateAnalyticsDataSetRequest, BatchDisassociateAnalyticsDataSetResponse>()
                            .withOperationName("BatchDisassociateAnalyticsDataSet").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDisassociateAnalyticsDataSetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDisassociateAnalyticsDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file
     * provided in the input list must be associated with the input AssociatedResourceArn.
     * </p>
     *
     * @param batchGetAttachedFileMetadataRequest
     * @return Result of the BatchGetAttachedFileMetadata operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchGetAttachedFileMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetAttachedFileMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetAttachedFileMetadataResponse batchGetAttachedFileMetadata(
            BatchGetAttachedFileMetadataRequest batchGetAttachedFileMetadataRequest) throws AccessDeniedException,
            InvalidRequestException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetAttachedFileMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetAttachedFileMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetAttachedFileMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetAttachedFileMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAttachedFileMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetAttachedFileMetadataRequest, BatchGetAttachedFileMetadataResponse>()
                            .withOperationName("BatchGetAttachedFileMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetAttachedFileMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetAttachedFileMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieve the flow associations for the given resources.
     * </p>
     *
     * @param batchGetFlowAssociationRequest
     * @return Result of the BatchGetFlowAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchGetFlowAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchGetFlowAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetFlowAssociationResponse batchGetFlowAssociation(BatchGetFlowAssociationRequest batchGetFlowAssociationRequest)
            throws AccessDeniedException, ResourceNotFoundException, InternalServiceException, InvalidRequestException,
            InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetFlowAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetFlowAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetFlowAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetFlowAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetFlowAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetFlowAssociationRequest, BatchGetFlowAssociationResponse>()
                            .withOperationName("BatchGetFlowAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetFlowAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetFlowAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <note>
     * <p>
     * Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call
     * this API.
     * </p>
     * </note>
     * <p>
     * Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial
     * requests via the <a
     * href="https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html"
     * >PutDialRequestBatch</a> API. It then uses BatchPutContact to create contacts corresponding to those dial
     * requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting
     * voice call uses the same contactId that was created by BatchPutContact.
     * </p>
     *
     * @param batchPutContactRequest
     * @return Result of the BatchPutContact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchPutContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchPutContact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchPutContactResponse batchPutContact(BatchPutContactRequest batchPutContactRequest) throws AccessDeniedException,
            InternalServiceException, InvalidRequestException, ResourceNotFoundException, LimitExceededException,
            IdempotencyException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchPutContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchPutContactResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchPutContactRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutContactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutContact");

            return clientHandler.execute(new ClientExecutionParams<BatchPutContactRequest, BatchPutContactResponse>()
                    .withOperationName("BatchPutContact").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchPutContactRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchPutContactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates multiple data table values using all properties from BatchCreateDataTableValue. System managed values are
     * not modifiable by customers. The operation requires proper lock versions to prevent concurrent modification
     * conflicts.
     * </p>
     *
     * @param batchUpdateDataTableValueRequest
     * @return Result of the BatchUpdateDataTableValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.BatchUpdateDataTableValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/BatchUpdateDataTableValue"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchUpdateDataTableValueResponse batchUpdateDataTableValue(
            BatchUpdateDataTableValueRequest batchUpdateDataTableValueRequest) throws InvalidRequestException, ConflictException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            InvalidParameterException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchUpdateDataTableValueResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchUpdateDataTableValueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchUpdateDataTableValueRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchUpdateDataTableValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchUpdateDataTableValue");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchUpdateDataTableValueRequest, BatchUpdateDataTableValueResponse>()
                            .withOperationName("BatchUpdateDataTableValue").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchUpdateDataTableValueRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchUpdateDataTableValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this
     * API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group
     * was created.
     * </p>
     * <p>
     * For more information about how to use this operation, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html">Claim a phone number in your
     * country</a> and <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html"
     * >Claim phone numbers to traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <important>
     * <p>
     * You can call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html"
     * >SearchAvailablePhoneNumbers</a> API for available phone numbers that you can claim. Call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html"
     * >DescribePhoneNumber</a> API to verify the status of a previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a>
     * operation.
     * </p>
     * </important>
     * <p>
     * If you plan to claim and release numbers frequently, contact us for a service quota exception. Otherwise, it is
     * possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest
     * number released has expired.
     * </p>
     * <p>
     * By default you can claim and release up to 200% of your maximum number of active phone numbers. If you claim and
     * release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number
     * service level quota, you will be blocked from claiming any more numbers until 180 days past the oldest number
     * released has expired.
     * </p>
     * <p>
     * For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 180
     * day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point
     * you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.
     * </p>
     *
     * @param claimPhoneNumberRequest
     * @return Result of the ClaimPhoneNumber operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.ClaimPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ClaimPhoneNumberResponse claimPhoneNumber(ClaimPhoneNumberRequest claimPhoneNumberRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            IdempotencyException, AccessDeniedException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ClaimPhoneNumberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ClaimPhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(claimPhoneNumberRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, claimPhoneNumberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClaimPhoneNumber");

            return clientHandler.execute(new ClientExecutionParams<ClaimPhoneNumberRequest, ClaimPhoneNumberResponse>()
                    .withOperationName("ClaimPhoneNumber").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(claimPhoneNumberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ClaimPhoneNumberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the
     * StartAttachedFileUpload API.
     * </p>
     *
     * @param completeAttachedFileUploadRequest
     *        Request to CompleteAttachedFileUpload API
     * @return Result of the CompleteAttachedFileUpload operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CompleteAttachedFileUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CompleteAttachedFileUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompleteAttachedFileUploadResponse completeAttachedFileUpload(
            CompleteAttachedFileUploadRequest completeAttachedFileUploadRequest) throws AccessDeniedException,
            InvalidRequestException, InternalServiceException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CompleteAttachedFileUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CompleteAttachedFileUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(completeAttachedFileUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, completeAttachedFileUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteAttachedFileUpload");

            return clientHandler
                    .execute(new ClientExecutionParams<CompleteAttachedFileUploadRequest, CompleteAttachedFileUploadResponse>()
                            .withOperationName("CompleteAttachedFileUpload").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(completeAttachedFileUploadRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CompleteAttachedFileUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an agent status for the specified Amazon Connect instance.
     * </p>
     *
     * @param createAgentStatusRequest
     * @return Result of the CreateAgentStatus operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateAgentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAgentStatusResponse createAgentStatus(CreateAgentStatusRequest createAgentStatusRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAgentStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAgentStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAgentStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAgentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAgentStatus");

            return clientHandler.execute(new ClientExecutionParams<CreateAgentStatusRequest, CreateAgentStatusResponse>()
                    .withOperationName("CreateAgentStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAgentStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAgentStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * Only the VOICE, EMAIL, and TASK channels are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For VOICE: The supported initiation method is <code>TRANSFER</code>. The contacts created with this initiation
     * method have a subtype <code>connect:ExternalAudio</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For EMAIL: The supported initiation methods are <code>OUTBOUND</code>, <code>AGENT_REPLY</code>, and
     * <code>FLOW</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For TASK: The supported initiation method is <code>API</code>. Contacts created with this API have a sub-type of
     * <code>connect:ExternalTask</code>.
     * </p>
     * </li>
     * </ul>
     * </important>
     * <p>
     * Creates a new VOICE, EMAIL, or TASK contact.
     * </p>
     * <p>
     * After a contact is created, you can move it to the desired state by using the <code>InitiateAs</code> parameter.
     * While you can use API to create task contacts that are in the <code>COMPLETED</code> state, you must contact
     * Amazon Web Services Support before using it for bulk import use cases. Bulk import causes your requests to be
     * throttled or fail if your CreateContact limits aren't high enough.
     * </p>
     *
     * @param createContactRequest
     * @return Result of the CreateContact operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContact" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateContactResponse createContact(CreateContactRequest createContactRequest) throws AccessDeniedException,
            InternalServiceException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, IdempotencyException, ConflictException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContactResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateContactResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContact");

            return clientHandler.execute(new ClientExecutionParams<CreateContactRequest, CreateContactResponse>()
                    .withOperationName("CreateContact").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createContactRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateContactRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a flow for the specified Amazon Connect instance.
     * </p>
     * <p>
     * You can also create and update flows using the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow
     * language</a>.
     * </p>
     *
     * @param createContactFlowRequest
     * @return Result of the CreateContactFlow operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowException
     *         The flow is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateContactFlowResponse createContactFlow(CreateContactFlowRequest createContactFlowRequest)
            throws InvalidRequestException, InvalidContactFlowException, InvalidParameterException, DuplicateResourceException,
            LimitExceededException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContactFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateContactFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactFlowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContactFlow");

            return clientHandler.execute(new ClientExecutionParams<CreateContactFlowRequest, CreateContactFlowResponse>()
                    .withOperationName("CreateContactFlow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createContactFlowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateContactFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a flow module for the specified Amazon Connect instance.
     * </p>
     *
     * @param createContactFlowModuleRequest
     * @return Result of the CreateContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidContactFlowModuleException
     *         The problems with the module. Please fix before trying again.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContactFlowModuleResponse createContactFlowModule(CreateContactFlowModuleRequest createContactFlowModuleRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidContactFlowModuleException, InvalidParameterException,
            DuplicateResourceException, LimitExceededException, ResourceNotFoundException, ThrottlingException,
            IdempotencyException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContactFlowModuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateContactFlowModuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactFlowModuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactFlowModuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContactFlowModule");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateContactFlowModuleRequest, CreateContactFlowModuleResponse>()
                            .withOperationName("CreateContactFlowModule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createContactFlowModuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateContactFlowModuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a named alias that points to a specific version of a contact flow module.
     * </p>
     *
     * @param createContactFlowModuleAliasRequest
     * @return Result of the CreateContactFlowModuleAlias operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContactFlowModuleAliasResponse createContactFlowModuleAlias(
            CreateContactFlowModuleAliasRequest createContactFlowModuleAliasRequest) throws AccessDeniedException,
            DuplicateResourceException, InternalServiceException, ResourceNotFoundException, LimitExceededException,
            InvalidParameterException, InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContactFlowModuleAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateContactFlowModuleAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactFlowModuleAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactFlowModuleAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContactFlowModuleAlias");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateContactFlowModuleAliasRequest, CreateContactFlowModuleAliasResponse>()
                            .withOperationName("CreateContactFlowModuleAlias").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createContactFlowModuleAliasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateContactFlowModuleAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an immutable snapshot of a contact flow module, preserving its content and settings at a specific point
     * in time for version control and rollback capabilities.
     * </p>
     *
     * @param createContactFlowModuleVersionRequest
     * @return Result of the CreateContactFlowModuleVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowModuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContactFlowModuleVersionResponse createContactFlowModuleVersion(
            CreateContactFlowModuleVersionRequest createContactFlowModuleVersionRequest) throws AccessDeniedException,
            InternalServiceException, ResourceNotFoundException, LimitExceededException, InvalidParameterException,
            InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContactFlowModuleVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateContactFlowModuleVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactFlowModuleVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createContactFlowModuleVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContactFlowModuleVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateContactFlowModuleVersionRequest, CreateContactFlowModuleVersionResponse>()
                            .withOperationName("CreateContactFlowModuleVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createContactFlowModuleVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateContactFlowModuleVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Publishes a new version of the flow provided. Versions are immutable and monotonically increasing. If the
     * <code>FlowContentSha256</code> provided is different from the <code>FlowContentSha256</code> of the
     * <code>&#36LATEST</code> published flow content, then an error is returned. This API only supports creating
     * versions for flows of type <code>Campaign</code>.
     * </p>
     *
     * @param createContactFlowVersionRequest
     * @return Result of the CreateContactFlowVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateContactFlowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContactFlowVersionResponse createContactFlowVersion(
            CreateContactFlowVersionRequest createContactFlowVersionRequest) throws AccessDeniedException,
            InternalServiceException, ResourceNotFoundException, LimitExceededException, InvalidParameterException,
            InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateContactFlowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateContactFlowVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContactFlowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createContactFlowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContactFlowVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateContactFlowVersionRequest, CreateContactFlowVersionResponse>()
                            .withOperationName("CreateContactFlowVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createContactFlowVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateContactFlowVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new data table with the specified properties. Supports the creation of all table properties except for
     * attributes and values. A table with no attributes and values is a valid state for a table. The number of tables
     * per instance is limited to 100 per instance. Customers can request an increase by using AWS Service Quotas.
     * </p>
     *
     * @param createDataTableRequest
     * @return Result of the CreateDataTable operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDataTableResponse createDataTable(CreateDataTableRequest createDataTableRequest) throws InvalidRequestException,
            ConflictException, DuplicateResourceException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AccessDeniedException, InvalidParameterException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataTable");

            return clientHandler.execute(new ClientExecutionParams<CreateDataTableRequest, CreateDataTableResponse>()
                    .withOperationName("CreateDataTable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDataTableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an attribute to an existing data table. Creating a new primary attribute uses the empty value for the
     * specified value type for all existing records. This should not affect uniqueness of published data tables since
     * the existing primary values will already be unique. Creating attributes does not create any values. System
     * managed tables may not allow customers to create new attributes.
     * </p>
     *
     * @param createDataTableAttributeRequest
     * @return Result of the CreateDataTableAttribute operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDataTableAttributeResponse createDataTableAttribute(
            CreateDataTableAttributeRequest createDataTableAttributeRequest) throws InvalidRequestException, ConflictException,
            DuplicateResourceException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, InvalidParameterException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataTableAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDataTableAttributeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataTableAttributeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataTableAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataTableAttribute");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDataTableAttributeRequest, CreateDataTableAttributeResponse>()
                            .withOperationName("CreateDataTableAttribute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDataTableAttributeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDataTableAttributeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create new email address in the specified Amazon Connect instance. For more information about email addresses,
     * see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-email-address1.html">Create email
     * addresses</a> in the Amazon Connect Administrator Guide.
     * </p>
     *
     * @param createEmailAddressRequest
     * @return Result of the CreateEmailAddress operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws IdempotencyException
     *         An entity with the same name already exists.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateEmailAddressResponse createEmailAddress(CreateEmailAddressRequest createEmailAddressRequest)
            throws InvalidParameterException, InvalidRequestException, ServiceQuotaExceededException, ResourceNotFoundException,
            ThrottlingException, AccessDeniedException, InternalServiceException, IdempotencyException,
            DuplicateResourceException, ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEmailAddressResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEmailAddressResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEmailAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEmailAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEmailAddress");

            return clientHandler.execute(new ClientExecutionParams<CreateEmailAddressRequest, CreateEmailAddressResponse>()
                    .withOperationName("CreateEmailAddress").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createEmailAddressRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEmailAddressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions
     * related to agent performance, and create sections to organize such questions. Question and section identifiers
     * cannot be duplicated within the same evaluation form.
     * </p>
     *
     * @param createEvaluationFormRequest
     * @return Result of the CreateEvaluationForm operation returned by the service.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateEvaluationFormResponse createEvaluationForm(CreateEvaluationFormRequest createEvaluationFormRequest)
            throws InternalServiceException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEvaluationFormResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEvaluationFormResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEvaluationFormRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEvaluationFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEvaluationForm");

            return clientHandler.execute(new ClientExecutionParams<CreateEvaluationFormRequest, CreateEvaluationFormResponse>()
                    .withOperationName("CreateEvaluationForm").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createEvaluationFormRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEvaluationFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates hours of operation.
     * </p>
     *
     * @param createHoursOfOperationRequest
     * @return Result of the CreateHoursOfOperation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateHoursOfOperationResponse createHoursOfOperation(CreateHoursOfOperationRequest createHoursOfOperationRequest)
            throws DuplicateResourceException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateHoursOfOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateHoursOfOperationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHoursOfOperationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHoursOfOperationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHoursOfOperation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateHoursOfOperationRequest, CreateHoursOfOperationResponse>()
                            .withOperationName("CreateHoursOfOperation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createHoursOfOperationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateHoursOfOperationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an hours of operation override in an Amazon Connect hours of operation resource.
     * </p>
     *
     * @param createHoursOfOperationOverrideRequest
     * @return Result of the CreateHoursOfOperationOverride operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateHoursOfOperationOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperationOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateHoursOfOperationOverrideResponse createHoursOfOperationOverride(
            CreateHoursOfOperationOverrideRequest createHoursOfOperationOverrideRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateHoursOfOperationOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateHoursOfOperationOverrideResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHoursOfOperationOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createHoursOfOperationOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHoursOfOperationOverride");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateHoursOfOperationOverrideRequest, CreateHoursOfOperationOverrideResponse>()
                            .withOperationName("CreateHoursOfOperationOverride").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createHoursOfOperationOverrideRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateHoursOfOperationOverrideRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is in preview release for Amazon Connect and is subject to change.
     * </p>
     * <p>
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage,
     * such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any
     * configurations on features, such as Contact Lens for Amazon Connect.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Create an Amazon
     * Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you
     * exceed this limit, you will get an error message indicating there has been an excessive number of attempts at
     * creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in
     * your account.
     * </p>
     *
     * @param createInstanceRequest
     * @return Result of the CreateInstance operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateInstanceResponse createInstance(CreateInstanceRequest createInstanceRequest) throws InvalidRequestException,
            ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, InternalServiceException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstance");

            return clientHandler.execute(new ClientExecutionParams<CreateInstanceRequest, CreateInstanceResponse>()
                    .withOperationName("CreateInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     * </p>
     *
     * @param createIntegrationAssociationRequest
     * @return Result of the CreateIntegrationAssociation operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateIntegrationAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIntegrationAssociationResponse createIntegrationAssociation(
            CreateIntegrationAssociationRequest createIntegrationAssociationRequest) throws DuplicateResourceException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIntegrationAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIntegrationAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIntegrationAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIntegrationAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIntegrationAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIntegrationAssociationRequest, CreateIntegrationAssociationResponse>()
                            .withOperationName("CreateIntegrationAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIntegrationAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIntegrationAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new participant into an on-going chat contact or webRTC call. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html">Customize chat flow
     * experiences by integrating custom participants</a> or <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-multiuser-inapp.html">Enable multi-user web,
     * in-app, and video calling</a>.
     * </p>
     *
     * @param createParticipantRequest
     * @return Result of the CreateParticipant operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateParticipant
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateParticipant" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateParticipantResponse createParticipant(CreateParticipantRequest createParticipantRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ServiceQuotaExceededException,
            ThrottlingException, ConflictException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateParticipantResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateParticipantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createParticipantRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createParticipantRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateParticipant");

            return clientHandler.execute(new ClientExecutionParams<CreateParticipantRequest, CreateParticipantResponse>()
                    .withOperationName("CreateParticipant").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createParticipantRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateParticipantRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a> in
     * the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPersistentContactAssociationRequest
     * @return Result of the CreatePersistentContactAssociation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePersistentContactAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePersistentContactAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePersistentContactAssociationResponse createPersistentContactAssociation(
            CreatePersistentContactAssociationRequest createPersistentContactAssociationRequest) throws InvalidRequestException,
            InvalidParameterException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePersistentContactAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePersistentContactAssociationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPersistentContactAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPersistentContactAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePersistentContactAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePersistentContactAssociationRequest, CreatePersistentContactAssociationResponse>()
                            .withOperationName("CreatePersistentContactAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createPersistentContactAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePersistentContactAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new predefined attribute for the specified Amazon Connect instance. A <i>predefined attribute</i> is
     * made up of a name and a value.
     * </p>
     * <p>
     * For the predefined attributes per instance quota, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas"
     * >Amazon Connect quotas</a>.
     * </p>
     * <p>
     * <b>Use cases</b>
     * </p>
     * <p>
     * Following are common uses cases for this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create an attribute for routing proficiency (for example, agent certification) that has predefined values (for
     * example, a list of possible certifications). For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined
     * attributes for routing contacts to agents</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create an attribute for business unit name that has a list of predefined business unit names used in your
     * organization. This is a use case where information for a contact varies between transfers or conferences. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-contact-segment-attributes.html">Use contact
     * segment attributes</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Endpoints</b>: See <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect
     * endpoints and quotas</a>.
     * </p>
     *
     * @param createPredefinedAttributeRequest
     * @return Result of the CreatePredefinedAttribute operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePredefinedAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePredefinedAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePredefinedAttributeResponse createPredefinedAttribute(
            CreatePredefinedAttributeRequest createPredefinedAttributeRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePredefinedAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePredefinedAttributeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPredefinedAttributeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPredefinedAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePredefinedAttribute");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePredefinedAttributeRequest, CreatePredefinedAttributeResponse>()
                            .withOperationName("CreatePredefinedAttribute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createPredefinedAttributeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePredefinedAttributeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a prompt. For more information about prompts, such as supported file types and maximum length, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html">Create prompts</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPromptRequest
     * @return Result of the CreatePrompt operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePrompt
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePrompt" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePromptResponse createPrompt(CreatePromptRequest createPromptRequest) throws DuplicateResourceException,
            InvalidRequestException, InvalidParameterException, LimitExceededException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePromptResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePromptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPromptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPromptRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePrompt");

            return clientHandler.execute(new ClientExecutionParams<CreatePromptRequest, CreatePromptResponse>()
                    .withOperationName("CreatePrompt").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPromptRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePromptRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates registration for a device token and a chat contact to receive real-time push notifications. For more
     * information about push notifications, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-push-notifications-for-mobile-chat.html">Set
     * up push notifications in Amazon Connect for mobile chat</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createPushNotificationRegistrationRequest
     * @return Result of the CreatePushNotificationRegistration operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreatePushNotificationRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreatePushNotificationRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePushNotificationRegistrationResponse createPushNotificationRegistration(
            CreatePushNotificationRegistrationRequest createPushNotificationRegistrationRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            AccessDeniedException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePushNotificationRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePushNotificationRegistrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPushNotificationRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPushNotificationRegistrationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePushNotificationRegistration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePushNotificationRegistrationRequest, CreatePushNotificationRegistrationResponse>()
                            .withOperationName("CreatePushNotificationRegistration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createPushNotificationRegistrationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePushNotificationRegistrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new queue for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon
     * Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for
     * <code>OutboundCallerIdNumberId</code>. However, if the phone number is claimed to a traffic distribution group
     * that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that
     * is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is
     * provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Only use the phone number ARN format that doesn't contain <code>instance</code> in the path, for example,
     * <code>arn:aws:connect:us-east-1:1234567890:phone-number/uuid</code>. This is the same ARN format that is returned
     * when you call the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a>
     * API.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic
     * distribution group, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region"
     * >Allow or Deny queue API actions for phone numbers in a replica Region</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param createQueueRequest
     * @return Result of the CreateQueue operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateQueueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateQueueResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQueueRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQueueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQueue");

            return clientHandler.execute(new ClientExecutionParams<CreateQueueRequest, CreateQueueResponse>()
                    .withOperationName("CreateQueue").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createQueueRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateQueueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a quick connect for the specified Amazon Connect instance.
     * </p>
     *
     * @param createQuickConnectRequest
     * @return Result of the CreateQuickConnect operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateQuickConnect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateQuickConnectResponse createQuickConnect(CreateQuickConnectRequest createQuickConnectRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateQuickConnectResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateQuickConnectResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createQuickConnectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createQuickConnectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateQuickConnect");

            return clientHandler.execute(new ClientExecutionParams<CreateQuickConnectRequest, CreateQuickConnectResponse>()
                    .withOperationName("CreateQuickConnect").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createQuickConnectRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateQuickConnectRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new routing profile.
     * </p>
     *
     * @param createRoutingProfileRequest
     * @return Result of the CreateRoutingProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRoutingProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRoutingProfileResponse createRoutingProfile(CreateRoutingProfileRequest createRoutingProfileRequest)
            throws InvalidRequestException, InvalidParameterException, DuplicateResourceException, ResourceNotFoundException,
            LimitExceededException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRoutingProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateRoutingProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRoutingProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRoutingProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoutingProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateRoutingProfileRequest, CreateRoutingProfileResponse>()
                    .withOperationName("CreateRoutingProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRoutingProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRoutingProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a rule for the specified Amazon Connect instance.
     * </p>
     * <p>
     * Use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html">Rules
     * Function language</a> to code conditions for the rule.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            ResourceConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRule");

            return clientHandler.execute(new ClientExecutionParams<CreateRuleRequest, CreateRuleResponse>()
                    .withOperationName("CreateRule").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createRuleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a security profile.
     * </p>
     * <p>
     * For information about security profiles, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a>
     * in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the
     * security profile permissions, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile
     * permissions</a>.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateSecurityProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSecurityProfileResponse createSecurityProfile(CreateSecurityProfileRequest createSecurityProfileRequest)
            throws InvalidRequestException, InvalidParameterException, LimitExceededException, DuplicateResourceException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException,
            ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSecurityProfileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateSecurityProfileRequest, CreateSecurityProfileResponse>()
                    .withOperationName("CreateSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new task template in the specified Amazon Connect instance.
     * </p>
     *
     * @param createTaskTemplateRequest
     * @return Result of the CreateTaskTemplate operation returned by the service.
     * @throws PropertyValidationException
     *         The property is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateTaskTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTaskTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateTaskTemplateResponse createTaskTemplate(CreateTaskTemplateRequest createTaskTemplateRequest)
            throws PropertyValidationException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            ServiceQuotaExceededException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTaskTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTaskTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTaskTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTaskTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTaskTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateTaskTemplateRequest, CreateTaskTemplateResponse>()
                    .withOperationName("CreateTaskTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTaskTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTaskTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
     * </p>
     * <note>
     * <p>
     * The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code>
     * (see the <code>IsDefault</code> parameter in the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html"
     * >TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified
     * <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an
     * <code>InvalidRequestException</code> is returned.
     * </p>
     * </note>
     * <p>
     * For more information about creating traffic distribution groups, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Set up
     * traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     *
     * @param createTrafficDistributionGroupRequest
     * @return Result of the CreateTrafficDistributionGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ResourceNotReadyException
     *         The resource is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateTrafficDistributionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTrafficDistributionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrafficDistributionGroupResponse createTrafficDistributionGroup(
            CreateTrafficDistributionGroupRequest createTrafficDistributionGroupRequest) throws InvalidRequestException,
            AccessDeniedException, ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException,
            InternalServiceException, ResourceConflictException, ResourceNotReadyException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrafficDistributionGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTrafficDistributionGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrafficDistributionGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createTrafficDistributionGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrafficDistributionGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTrafficDistributionGroupRequest, CreateTrafficDistributionGroupResponse>()
                            .withOperationName("CreateTrafficDistributionGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTrafficDistributionGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTrafficDistributionGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a use case for an integration association.
     * </p>
     *
     * @param createUseCaseRequest
     * @return Result of the CreateUseCase operation returned by the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUseCaseResponse createUseCase(CreateUseCaseRequest createUseCaseRequest) throws DuplicateResourceException,
            ResourceNotFoundException, InternalServiceException, InvalidRequestException, ThrottlingException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUseCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUseCaseResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUseCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUseCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUseCase");

            return clientHandler.execute(new ClientExecutionParams<CreateUseCaseRequest, CreateUseCaseResponse>()
                    .withOperationName("CreateUseCase").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUseCaseRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUseCaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a user account for the specified Amazon Connect instance.
     * </p>
     * <important>
     * <p>
     * Certain <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html">UserIdentityInfo</a>
     * parameters are required in some situations. For example, <code>Email</code>, <code>FirstName</code> and
     * <code>LastName</code> are required if you are using Amazon Connect or SAML for identity management.
     * </p>
     * </important>
     * <p>
     * For information about how to create users using the Amazon Connect admin website, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon
     * Connect Administrator Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws InvalidRequestException,
            InvalidParameterException, LimitExceededException, DuplicateResourceException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateUserResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            return clientHandler.execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>()
                    .withOperationName("CreateUser").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createUserRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new user hierarchy group.
     * </p>
     *
     * @param createUserHierarchyGroupRequest
     * @return Result of the CreateUserHierarchyGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateUserHierarchyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserHierarchyGroupResponse createUserHierarchyGroup(
            CreateUserHierarchyGroupRequest createUserHierarchyGroupRequest) throws InvalidRequestException,
            InvalidParameterException, DuplicateResourceException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserHierarchyGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserHierarchyGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserHierarchyGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserHierarchyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserHierarchyGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUserHierarchyGroupRequest, CreateUserHierarchyGroupResponse>()
                            .withOperationName("CreateUserHierarchyGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createUserHierarchyGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUserHierarchyGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new view with the possible status of <code>SAVED</code> or <code>PUBLISHED</code>.
     * </p>
     * <p>
     * The views will have a unique name for each connect instance.
     * </p>
     * <p>
     * It performs basic content validation if the status is <code>SAVED</code> or full content validation if the status
     * is set to <code>PUBLISHED</code>. An error is returned if validation fails. It associates either the
     * <code>&#36SAVED</code> qualifier or both of the <code>&#36SAVED</code> and <code>&#36LATEST</code> qualifiers
     * with the provided view content based on the status. The view is idempotent if ClientToken is provided.
     * </p>
     *
     * @param createViewRequest
     * @return Result of the CreateView operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use (for example, you're trying to add a record with the same name as an
     *         existing record). If you are trying to delete a resource (for example, DeleteHoursOfOperation or
     *         DeletePredefinedAttribute), remove its reference from related resources and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateView" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateViewResponse createView(CreateViewRequest createViewRequest) throws AccessDeniedException,
            InvalidRequestException, InvalidParameterException, ResourceNotFoundException, InternalServiceException,
            DuplicateResourceException, ServiceQuotaExceededException, TooManyRequestsException, ResourceInUseException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateViewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateView");

            return clientHandler.execute(new ClientExecutionParams<CreateViewRequest, CreateViewResponse>()
                    .withOperationName("CreateView").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createViewRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Publishes a new version of the view identifier.
     * </p>
     * <p>
     * Versions are immutable and monotonically increasing.
     * </p>
     * <p>
     * It returns the highest version if there is no change in content compared to that version. An error is displayed
     * if the supplied ViewContentSha256 is different from the ViewContentSha256 of the <code>&#36LATEST</code> alias.
     * </p>
     *
     * @param createViewVersionRequest
     * @return Result of the CreateViewVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws TooManyRequestsException
     *         Displayed when rate-related API limits are exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ResourceInUseException
     *         That resource is already in use (for example, you're trying to add a record with the same name as an
     *         existing record). If you are trying to delete a resource (for example, DeleteHoursOfOperation or
     *         DeletePredefinedAttribute), remove its reference from related resources and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateViewVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateViewVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateViewVersionResponse createViewVersion(CreateViewVersionRequest createViewVersionRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, TooManyRequestsException, ServiceQuotaExceededException, ResourceInUseException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateViewVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateViewVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createViewVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createViewVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateViewVersion");

            return clientHandler.execute(new ClientExecutionParams<CreateViewVersionRequest, CreateViewVersionResponse>()
                    .withOperationName("CreateViewVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createViewVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateViewVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be
     * your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in
     * post-call and real-time contact analysis sessions for that language.
     * </p>
     *
     * @param createVocabularyRequest
     * @return Result of the CreateVocabulary operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateVocabulary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVocabularyResponse createVocabulary(CreateVocabularyRequest createVocabularyRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, ResourceConflictException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVocabularyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateVocabularyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVocabularyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVocabularyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVocabulary");

            return clientHandler.execute(new ClientExecutionParams<CreateVocabularyRequest, CreateVocabularyResponse>()
                    .withOperationName("CreateVocabulary").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createVocabularyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVocabularyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a workspace that defines the user experience by mapping views to pages. Workspaces can be assigned to
     * users or routing profiles.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return Result of the CreateWorkspace operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkspaceResponse createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) throws InvalidRequestException,
            DuplicateResourceException, ResourceNotFoundException, InternalServiceException, ThrottlingException,
            AccessDeniedException, InvalidParameterException, LimitExceededException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkspaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspace");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspaceRequest, CreateWorkspaceResponse>()
                    .withOperationName("CreateWorkspace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkspaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a view with a page in a workspace, defining what users see when they navigate to that page.
     * </p>
     *
     * @param createWorkspacePageRequest
     * @return Result of the CreateWorkspacePage operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws LimitExceededException
     *         The allowed limit for the resource has been exceeded.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.CreateWorkspacePage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateWorkspacePage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateWorkspacePageResponse createWorkspacePage(CreateWorkspacePageRequest createWorkspacePageRequest)
            throws InvalidRequestException, DuplicateResourceException, ResourceNotFoundException, InternalServiceException,
            ThrottlingException, AccessDeniedException, InvalidParameterException, ResourceConflictException,
            LimitExceededException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspacePageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkspacePageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkspacePageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspacePageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspacePage");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspacePageRequest, CreateWorkspacePageResponse>()
                    .withOperationName("CreateWorkspacePage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkspacePageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspacePageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no
     * longer available for users to start new evaluations based on the form.
     * </p>
     *
     * @param deactivateEvaluationFormRequest
     * @return Result of the DeactivateEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeactivateEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeactivateEvaluationForm"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeactivateEvaluationFormResponse deactivateEvaluationForm(
            DeactivateEvaluationFormRequest deactivateEvaluationFormRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServiceException, ResourceConflictException,
            AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeactivateEvaluationFormResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeactivateEvaluationFormResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deactivateEvaluationFormRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deactivateEvaluationFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateEvaluationForm");

            return clientHandler
                    .execute(new ClientExecutionParams<DeactivateEvaluationFormRequest, DeactivateEvaluationFormResponse>()
                            .withOperationName("DeactivateEvaluationForm").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deactivateEvaluationFormRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeactivateEvaluationFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an attached file along with the underlying S3 Object.
     * </p>
     * <important>
     * <p>
     * The attached file is <b>permanently deleted</b> if S3 bucket versioning is not enabled.
     * </p>
     * </important>
     *
     * @param deleteAttachedFileRequest
     *        Request to DeleteAttachedFile API
     * @return Result of the DeleteAttachedFile operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteAttachedFile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteAttachedFile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAttachedFileResponse deleteAttachedFile(DeleteAttachedFileRequest deleteAttachedFileRequest)
            throws AccessDeniedException, InvalidRequestException, InternalServiceException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAttachedFileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAttachedFileResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAttachedFileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAttachedFileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAttachedFile");

            return clientHandler.execute(new ClientExecutionParams<DeleteAttachedFileRequest, DeleteAttachedFileResponse>()
                    .withOperationName("DeleteAttachedFile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAttachedFileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAttachedFileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a contact evaluation in the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteContactEvaluationRequest
     * @return Result of the DeleteContactEvaluation operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactEvaluation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactEvaluation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContactEvaluationResponse deleteContactEvaluation(DeleteContactEvaluationRequest deleteContactEvaluationRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContactEvaluationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContactEvaluationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactEvaluationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactEvaluationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactEvaluation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteContactEvaluationRequest, DeleteContactEvaluationResponse>()
                            .withOperationName("DeleteContactEvaluation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteContactEvaluationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteContactEvaluationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a flow for the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteContactFlowRequest
     * @return Result of the DeleteContactFlow operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteContactFlowResponse deleteContactFlow(DeleteContactFlowRequest deleteContactFlowRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            InternalServiceException, ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContactFlowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteContactFlowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactFlowRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactFlowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactFlow");

            return clientHandler.execute(new ClientExecutionParams<DeleteContactFlowRequest, DeleteContactFlowResponse>()
                    .withOperationName("DeleteContactFlow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteContactFlowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteContactFlowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified flow module.
     * </p>
     *
     * @param deleteContactFlowModuleRequest
     * @return Result of the DeleteContactFlowModule operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowModule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContactFlowModuleResponse deleteContactFlowModule(DeleteContactFlowModuleRequest deleteContactFlowModuleRequest)
            throws AccessDeniedException, InvalidRequestException, InvalidParameterException, ResourceNotFoundException,
            ThrottlingException, InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContactFlowModuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContactFlowModuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactFlowModuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactFlowModuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactFlowModule");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteContactFlowModuleRequest, DeleteContactFlowModuleResponse>()
                            .withOperationName("DeleteContactFlowModule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteContactFlowModuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteContactFlowModuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an alias reference, breaking the named connection to the underlying module version without affecting the
     * version itself.
     * </p>
     *
     * @param deleteContactFlowModuleAliasRequest
     * @return Result of the DeleteContactFlowModuleAlias operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowModuleAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModuleAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContactFlowModuleAliasResponse deleteContactFlowModuleAlias(
            DeleteContactFlowModuleAliasRequest deleteContactFlowModuleAliasRequest) throws AccessDeniedException,
            InternalServiceException, ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContactFlowModuleAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContactFlowModuleAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactFlowModuleAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactFlowModuleAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactFlowModuleAlias");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteContactFlowModuleAliasRequest, DeleteContactFlowModuleAliasResponse>()
                            .withOperationName("DeleteContactFlowModuleAlias").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteContactFlowModuleAliasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteContactFlowModuleAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a specific version of a contact flow module.
     * </p>
     *
     * @param deleteContactFlowModuleVersionRequest
     * @return Result of the DeleteContactFlowModuleVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowModuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContactFlowModuleVersionResponse deleteContactFlowModuleVersion(
            DeleteContactFlowModuleVersionRequest deleteContactFlowModuleVersionRequest) throws AccessDeniedException,
            InternalServiceException, ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContactFlowModuleVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContactFlowModuleVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactFlowModuleVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteContactFlowModuleVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactFlowModuleVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteContactFlowModuleVersionRequest, DeleteContactFlowModuleVersionResponse>()
                            .withOperationName("DeleteContactFlowModuleVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteContactFlowModuleVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteContactFlowModuleVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the particular version specified in flow version identifier.
     * </p>
     *
     * @param deleteContactFlowVersionRequest
     * @return Result of the DeleteContactFlowVersion operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteContactFlowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContactFlowVersionResponse deleteContactFlowVersion(
            DeleteContactFlowVersionRequest deleteContactFlowVersionRequest) throws AccessDeniedException,
            InternalServiceException, ResourceNotFoundException, InvalidParameterException, InvalidRequestException,
            ThrottlingException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteContactFlowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteContactFlowVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContactFlowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteContactFlowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContactFlowVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteContactFlowVersionRequest, DeleteContactFlowVersionResponse>()
                            .withOperationName("DeleteContactFlowVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteContactFlowVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteContactFlowVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a data table and all associated attributes, versions, audits, and values. Does not update any references
     * to the data table, even from other data tables. This includes dynamic values and conditional validations. System
     * managed data tables are not deletable by customers. API users may delete the table at any time. When deletion is
     * requested from the admin website, a warning is shown alerting the user of the most recent time the table and its
     * values were accessed.
     * </p>
     *
     * @param deleteDataTableRequest
     * @return Result of the DeleteDataTable operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteDataTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteDataTable" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDataTableResponse deleteDataTable(DeleteDataTableRequest deleteDataTableRequest) throws InvalidRequestException,
            ConflictException, ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            InvalidParameterException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataTableResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataTableRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataTableRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataTable");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataTableRequest, DeleteDataTableResponse>()
                    .withOperationName("DeleteDataTable").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDataTableRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataTableRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an attribute and all its values from a data table.
     * </p>
     *
     * @param deleteDataTableAttributeRequest
     * @return Result of the DeleteDataTableAttribute operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ConflictException
     *         Operation cannot be performed at this time as there is a conflict with another operation or contact
     *         state.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteDataTableAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteDataTableAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDataTableAttributeResponse deleteDataTableAttribute(
            DeleteDataTableAttributeRequest deleteDataTableAttributeRequest) throws InvalidRequestException, ConflictException,
            ResourceNotFoundException, InternalServiceException, ThrottlingException, AccessDeniedException,
            InvalidParameterException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataTableAttributeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDataTableAttributeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataTableAttributeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataTableAttributeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataTableAttribute");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDataTableAttributeRequest, DeleteDataTableAttributeResponse>()
                            .withOperationName("DeleteDataTableAttribute").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDataTableAttributeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDataTableAttributeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes email address from the specified Amazon Connect instance.
     * </p>
     *
     * @param deleteEmailAddressRequest
     * @return Result of the DeleteEmailAddress operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws AccessDeniedException
     *         You do not have sufficient permissions to perform this action.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEmailAddress" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEmailAddressResponse deleteEmailAddress(DeleteEmailAddressRequest deleteEmailAddressRequest)
            throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, InvalidParameterException,
            InvalidRequestException, InternalServiceException, ResourceConflictException, AwsServiceException,
            SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEmailAddressResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEmailAddressResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailAddressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEmailAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailAddress");

            return clientHandler.execute(new ClientExecutionParams<DeleteEmailAddressRequest, DeleteEmailAddressResponse>()
                    .withOperationName("DeleteEmailAddress").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteEmailAddressRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEmailAddressRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an evaluation form in the specified Amazon Connect instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the version property is provided, only the specified version of the evaluation form is deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * If no version is provided, then the full form (all versions) is deleted.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteEvaluationFormRequest
     * @return Result of the DeleteEvaluationForm operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws ResourceConflictException
     *         A resource already has that name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteEvaluationForm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEvaluationForm" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEvaluationFormResponse deleteEvaluationForm(DeleteEvaluationFormRequest deleteEvaluationFormRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServiceException,
            ResourceConflictException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEvaluationFormResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEvaluationFormResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEvaluationFormRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEvaluationFormRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEvaluationForm");

            return clientHandler.execute(new ClientExecutionParams<DeleteEvaluationFormRequest, DeleteEvaluationFormResponse>()
                    .withOperationName("DeleteEvaluationForm").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteEvaluationFormRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEvaluationFormRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an hours of operation.
     * </p>
     *
     * @param deleteHoursOfOperationRequest
     * @return Result of the DeleteHoursOfOperation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidParameterException
     *         One or more of the specified parameters are not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InternalServiceException
     *         Request processing failed because of an error or failure with the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ConnectClient.DeleteHoursOfOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteHoursOfOperationResponse deleteHoursOfOperation(DeleteHoursOfOperationRequest deleteHoursOfOperationRequest)
            throws InvalidRequestException, InvalidParameterException, ResourceNotFoundException, ThrottlingException,
            InternalServiceException, AwsServiceException, SdkClientException, ConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteHoursOfOperationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteHoursOfOperationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ResourceNotReadyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotReadyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceNotReadyException::builder).build());
            case "ConditionalOperationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConditionalOperationFailedException")
                        .httpStatusCode(409).exceptionBuilderSupplier(ConditionalOperationFailedException::builder).build());
            case "DuplicateResourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateResourceException").httpStatusCode(409)
                        .exceptionBuilderSupplier(DuplicateResourceException::builder).build());
            case "InternalServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServiceException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRequestException::builder).build());
            case "OutputTypeNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutputTypeNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(OutputTypeNotFoundException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "MaximumResultReturnedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumResultReturnedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumResultReturnedException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ContactNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactNotFoundException").httpStatusCode(410)
                        .exceptionBuilderSupplier(ContactNotFoundException::builder).build());
            case "OutboundContactNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OutboundContactNotPermittedException")
                        .httpStatusCode(403).exceptionBuilderSupplier(OutboundContactNotPermittedException::builder).build());
            case "ContactFlowNotPublishedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ContactFlowNotPublishedException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ContactFlowNotPublishedException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(429)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "UserNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(UserNotFoundException::builder).build());
            case "DestinationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DestinationNotAllowedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(DestinationNotAllowedException::builder).build());
            case "PropertyValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PropertyValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PropertyValidationException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "TooManyRequestsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(429)
                        .exceptionBuilderSupplier(TooManyRequestsException::builder).build());
            case "InvalidContactFlowModuleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowModuleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowModuleException::builder).build());
            case "ResourceConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ResourceConflictException::builder).build());
            case "InvalidContactFlowException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContactFlowException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContactFlowException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "IdempotencyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyException").httpStatusCode(409)
                        .exceptionBuilderSupplier(IdempotencyException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteHoursOfOperationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteHoursOfOperationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteHours