/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ContactMetricResult;
import software.amazon.awssdk.services.connect.model.ContactMetricResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactMetricsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, GetContactMetricsResponse> {
    private static final SdkField<List<ContactMetricResult>> METRIC_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricResults").getter(GetContactMetricsResponse.getter(GetContactMetricsResponse::metricResults)).setter(GetContactMetricsResponse.setter(Builder::metricResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactMetricResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetContactMetricsResponse.getter(GetContactMetricsResponse::id)).setter(GetContactMetricsResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetContactMetricsResponse.getter(GetContactMetricsResponse::arn)).setter(GetContactMetricsResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_RESULTS_FIELD, ID_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetContactMetricsResponse.memberNameToFieldInitializer();
    private final List<ContactMetricResult> metricResults;
    private final String id;
    private final String arn;

    private GetContactMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metricResults = builder.metricResults;
        this.id = builder.id;
        this.arn = builder.arn;
    }

    public final boolean hasMetricResults() {
        return this.metricResults != null && !(this.metricResults instanceof SdkAutoConstructList);
    }

    public final List<ContactMetricResult> metricResults() {
        return this.metricResults;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricResults() ? this.metricResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactMetricsResponse)) {
            return false;
        }
        GetContactMetricsResponse other = (GetContactMetricsResponse)((Object)obj);
        return this.hasMetricResults() == other.hasMetricResults() && Objects.equals(this.metricResults(), other.metricResults()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"GetContactMetricsResponse").add("MetricResults", this.hasMetricResults() ? this.metricResults() : null).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricResults": {
                return Optional.ofNullable(clazz.cast(this.metricResults()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricResults", METRIC_RESULTS_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContactMetricsResponse, T> g) {
        return obj -> g.apply((GetContactMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<ContactMetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactMetricsResponse model) {
            super(model);
            this.metricResults(model.metricResults);
            this.id(model.id);
            this.arn(model.arn);
        }

        public final List<ContactMetricResult.Builder> getMetricResults() {
            List<ContactMetricResult.Builder> result = ContactMetricResultsCopier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<ContactMetricResult.BuilderImpl> metricResults) {
            this.metricResults = ContactMetricResultsCopier.copyFromBuilder(metricResults);
        }

        @Override
        public final Builder metricResults(Collection<ContactMetricResult> metricResults) {
            this.metricResults = ContactMetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(ContactMetricResult ... metricResults) {
            this.metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<ContactMetricResult.Builder> ... metricResults) {
            this.metricResults(Stream.of(metricResults).map(c -> (ContactMetricResult)((ContactMetricResult.Builder)ContactMetricResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public GetContactMetricsResponse build() {
            return new GetContactMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactMetricsResponse> {
        public Builder metricResults(Collection<ContactMetricResult> var1);

        public Builder metricResults(ContactMetricResult ... var1);

        public Builder metricResults(Consumer<ContactMetricResult.Builder> ... var1);

        public Builder id(String var1);

        public Builder arn(String var1);
    }
}

