/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutboundRawMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutboundRawMessage> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subject").getter(OutboundRawMessage.getter(OutboundRawMessage::subject)).setter(OutboundRawMessage.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(OutboundRawMessage.getter(OutboundRawMessage::body)).setter(OutboundRawMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(OutboundRawMessage.getter(OutboundRawMessage::contentType)).setter(OutboundRawMessage.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, BODY_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutboundRawMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subject;
    private final String body;
    private final String contentType;

    private OutboundRawMessage(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
        this.contentType = builder.contentType;
    }

    public final String subject() {
        return this.subject;
    }

    public final String body() {
        return this.body;
    }

    public final String contentType() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundRawMessage)) {
            return false;
        }
        OutboundRawMessage other = (OutboundRawMessage)obj;
        return Objects.equals(this.subject(), other.subject()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType());
    }

    public final String toString() {
        return ToString.builder((String)"OutboundRawMessage").add("Subject", (Object)(this.subject() == null ? null : "*** Sensitive Data Redacted ***")).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Subject", SUBJECT_FIELD);
        map.put("Body", BODY_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutboundRawMessage, T> g) {
        return obj -> g.apply((OutboundRawMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subject;
        private String body;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundRawMessage model) {
            this.subject(model.subject);
            this.body(model.body);
            this.contentType(model.contentType);
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public OutboundRawMessage build() {
            return new OutboundRawMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutboundRawMessage> {
        public Builder subject(String var1);

        public Builder body(String var1);

        public Builder contentType(String var1);
    }
}

