/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealTimeContactAnalysisTimeData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealTimeContactAnalysisTimeData> {
    private static final SdkField<Instant> ABSOLUTE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AbsoluteTime").getter(RealTimeContactAnalysisTimeData.getter(RealTimeContactAnalysisTimeData::absoluteTime)).setter(RealTimeContactAnalysisTimeData.setter(Builder::absoluteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbsoluteTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ABSOLUTE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RealTimeContactAnalysisTimeData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant absoluteTime;
    private final Type type;

    private RealTimeContactAnalysisTimeData(BuilderImpl builder) {
        this.absoluteTime = builder.absoluteTime;
        this.type = builder.type;
    }

    public final Instant absoluteTime() {
        return this.absoluteTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.absoluteTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisTimeData)) {
            return false;
        }
        RealTimeContactAnalysisTimeData other = (RealTimeContactAnalysisTimeData)obj;
        return Objects.equals(this.absoluteTime(), other.absoluteTime());
    }

    public final String toString() {
        return ToString.builder((String)"RealTimeContactAnalysisTimeData").add("AbsoluteTime", (Object)this.absoluteTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AbsoluteTime": {
                return Optional.ofNullable(clazz.cast(this.absoluteTime()));
            }
        }
        return Optional.empty();
    }

    public static RealTimeContactAnalysisTimeData fromAbsoluteTime(Instant absoluteTime) {
        return (RealTimeContactAnalysisTimeData)RealTimeContactAnalysisTimeData.builder().absoluteTime(absoluteTime).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Instant>> map = new HashMap<String, SdkField<Instant>>();
        map.put("AbsoluteTime", ABSOLUTE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisTimeData, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisTimeData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ABSOLUTE_TIME,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Instant absoluteTime;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisTimeData model) {
            this.absoluteTime(model.absoluteTime);
        }

        public final Instant getAbsoluteTime() {
            return this.absoluteTime;
        }

        public final void setAbsoluteTime(Instant absoluteTime) {
            Instant oldValue = this.absoluteTime;
            this.absoluteTime = absoluteTime;
            this.handleUnionValueChange(Type.ABSOLUTE_TIME, oldValue, this.absoluteTime);
        }

        @Override
        public final Builder absoluteTime(Instant absoluteTime) {
            Instant oldValue = this.absoluteTime;
            this.absoluteTime = absoluteTime;
            this.handleUnionValueChange(Type.ABSOLUTE_TIME, oldValue, this.absoluteTime);
            return this;
        }

        public RealTimeContactAnalysisTimeData build() {
            return new RealTimeContactAnalysisTimeData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealTimeContactAnalysisTimeData> {
        public Builder absoluteTime(Instant var1);
    }
}

