/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.AgentStatusSummary;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse;

public class ListAgentStatusesIterable
implements SdkIterable<ListAgentStatusesResponse> {
    private final ConnectClient client;
    private final ListAgentStatusesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentStatusesIterable(ConnectClient client, ListAgentStatusesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentStatusesResponseFetcher();
    }

    public Iterator<ListAgentStatusesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentStatusSummary> agentStatusSummaryList() {
        Function<ListAgentStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentStatusSummaryList() != null) {
                return response.agentStatusSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentStatusesResponseFetcher
    implements SyncPageFetcher<ListAgentStatusesResponse> {
        private ListAgentStatusesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentStatusesResponse nextPage(ListAgentStatusesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentStatusesIterable.this.client.listAgentStatuses(ListAgentStatusesIterable.this.firstRequest);
            }
            return ListAgentStatusesIterable.this.client.listAgentStatuses((ListAgentStatusesRequest)((Object)ListAgentStatusesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

